/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.ai.np.compilerplugin;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BaseNodeModifier;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NaturalExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TreeModifier;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.lib.ai.np.compilerplugin.CodeModifier;
import io.ballerina.openapi.service.mapper.type.TypeMapper;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.plugins.ModifierTask;
import io.ballerina.projects.plugins.SourceModifierContext;
import io.ballerina.tools.text.TextDocument;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.OpenAPISchema2JsonSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class RuntimePromptAsCodeCodeModificationTask
implements ModifierTask<SourceModifierContext> {
    private static final Token COLON = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN);
    private static final String SCHEMA_ANNOTATION_IDENTIFIER = "JsonSchema";
    private static final String STRING = "string";
    private static final String BYTE = "byte";
    private static final String NUMBER = "number";
    private final ModifierData modifierData = new ModifierData();
    private final CodeModifier.AnalysisData analysisData;

    RuntimePromptAsCodeCodeModificationTask(CodeModifier.AnalysisData analysisData) {
        this.analysisData = analysisData;
    }

    public void modify(SourceModifierContext modifierContext) {
        Package currentPackage = modifierContext.currentPackage();
        if (modifierContext.compilation().diagnosticResult().errorCount() > 0) {
            return;
        }
        for (ModuleId moduleId : currentPackage.moduleIds()) {
            Optional<String> aiImportPrefix;
            Document document;
            Module module = currentPackage.module(moduleId);
            for (DocumentId documentId : module.documentIds()) {
                document = module.document(documentId);
                RuntimePromptAsCodeCodeModificationTask.generateSchemasForExpectedTypes(document, this.modifierData, modifierContext, moduleId, this.analysisData.typeMapper);
            }
            for (DocumentId documentId : module.testDocumentIds()) {
                document = module.document(documentId);
                RuntimePromptAsCodeCodeModificationTask.generateSchemasForExpectedTypes(document, this.modifierData, modifierContext, moduleId, this.analysisData.typeMapper);
            }
            for (DocumentId documentId : module.documentIds()) {
                document = module.document(documentId);
                aiImportPrefix = this.getAiImportPrefix(document);
                modifierContext.modifySourceFile(RuntimePromptAsCodeCodeModificationTask.modifyDocument(document, this.modifierData, aiImportPrefix), documentId);
            }
            for (DocumentId documentId : module.testDocumentIds()) {
                document = module.document(documentId);
                aiImportPrefix = this.getAiImportPrefix(document);
                modifierContext.modifyTestSourceFile(RuntimePromptAsCodeCodeModificationTask.modifyDocument(document, this.modifierData, aiImportPrefix), documentId);
            }
        }
    }

    private Optional<String> getAiImportPrefix(Document document) {
        ModulePartNode modulePartNode = (ModulePartNode)document.syntaxTree().rootNode();
        for (ImportDeclarationNode importDeclarationNode : modulePartNode.imports()) {
            SeparatedNodeList moduleName;
            Optional importOrgNameNode = importDeclarationNode.orgName();
            if (importOrgNameNode.isEmpty() || !"ballerina".equals(((ImportOrgNameNode)importOrgNameNode.get()).orgName().text()) || (moduleName = importDeclarationNode.moduleName()).size() > 1 || !"ai".equals(((IdentifierToken)moduleName.iterator().next()).text())) continue;
            Optional prefix = importDeclarationNode.prefix();
            return Optional.of(prefix.isEmpty() ? "ai" : ((ImportPrefixNode)prefix.get()).prefix().text());
        }
        return Optional.empty();
    }

    private static void generateSchemasForExpectedTypes(Document document, ModifierData modifierData, SourceModifierContext modifierContext, ModuleId moduleId, TypeMapper typeMapper) {
        ModulePartNode modulePartNode = (ModulePartNode)document.syntaxTree().rootNode();
        NaturalExpressionSchemaGenerator naturalExpressionSchemaGenerator = new NaturalExpressionSchemaGenerator(modifierData, modifierContext, moduleId, document, typeMapper);
        modulePartNode.apply((NodeTransformer)naturalExpressionSchemaGenerator);
    }

    private static TextDocument modifyDocument(Document document, ModifierData modifierData, Optional<String> aiImportPrefix) {
        TypeDefinitionModifier typeDefinitionModifier = new TypeDefinitionModifier(modifierData.typeSchemas, modifierData, aiImportPrefix, document);
        ModulePartNode modulePartNode = (ModulePartNode)document.syntaxTree().rootNode();
        ModulePartNode finalRoot = (ModulePartNode)modulePartNode.apply((NodeTransformer)typeDefinitionModifier);
        finalRoot = finalRoot.modify(RuntimePromptAsCodeCodeModificationTask.updateImports(document, finalRoot, modifierData), finalRoot.members(), finalRoot.eofToken());
        return document.syntaxTree().modifyWith((Node)finalRoot).textDocument();
    }

    public static MetadataNode getMetadataNode(TypeDefinitionNode typeDefinitionNode) {
        return typeDefinitionNode.metadata().orElseGet(() -> {
            NodeList annotations = NodeFactory.createNodeList((Node[])new AnnotationNode[0]);
            return NodeFactory.createMetadataNode(null, (NodeList)annotations);
        });
    }

    private static NodeList<AnnotationNode> updateAnnotations(NodeList<AnnotationNode> currentAnnotations, String jsonSchema, String aiPrefix) {
        NodeList updatedAnnotations = NodeFactory.createNodeList((Node[])new AnnotationNode[0]);
        if (currentAnnotations.isEmpty()) {
            updatedAnnotations = updatedAnnotations.add((Node)RuntimePromptAsCodeCodeModificationTask.getSchemaAnnotation(jsonSchema, aiPrefix));
        }
        return updatedAnnotations;
    }

    public static AnnotationNode getSchemaAnnotation(String jsonSchema, String aiPrefix) {
        String configIdentifierString = aiPrefix + COLON.text() + SCHEMA_ANNOTATION_IDENTIFIER;
        IdentifierToken identifierToken = NodeFactory.createIdentifierToken((String)configIdentifierString);
        return NodeFactory.createAnnotationNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)NodeFactory.createSimpleNameReferenceNode((Token)identifierToken), (MappingConstructorExpressionNode)RuntimePromptAsCodeCodeModificationTask.getAnnotationExpression(jsonSchema));
    }

    public static MappingConstructorExpressionNode getAnnotationExpression(String jsonSchema) {
        return (MappingConstructorExpressionNode)NodeParser.parseExpression((String)jsonSchema);
    }

    private static boolean containsBallerinaAIImport(NodeList<ImportDeclarationNode> imports) {
        for (ImportDeclarationNode importDeclarationNode : imports) {
            Optional importOrgNameNode = importDeclarationNode.orgName();
            if (!importOrgNameNode.isPresent() || !((ImportOrgNameNode)importOrgNameNode.get()).orgName().text().equals("ballerina") || !((IdentifierToken)importDeclarationNode.moduleName().get(0)).text().equals("ai")) continue;
            return true;
        }
        return false;
    }

    private static NodeList<ImportDeclarationNode> updateImports(Document document, ModulePartNode modulePartNode, ModifierData modifierData) {
        NodeList imports = modulePartNode.imports();
        if (RuntimePromptAsCodeCodeModificationTask.containsBallerinaAIImport((NodeList<ImportDeclarationNode>)imports)) {
            return imports;
        }
        if (modifierData.documentsRequiringAiImport.contains(document)) {
            return imports.add((Node)RuntimePromptAsCodeCodeModificationTask.createImportDeclarationForAiModule());
        }
        return imports;
    }

    private static ImportDeclarationNode createImportDeclarationForAiModule() {
        return NodeParser.parseImportDeclaration((String)String.format("import %s/%s;", "ballerina", "ai"));
    }

    private static void populateTypeSchema(TypeSymbol memberType, TypeMapper typeMapper, Map<String, String> typeSchemas, TypeSymbol anydataType) {
        TypeSymbol typeSymbol = memberType;
        Objects.requireNonNull(typeSymbol);
        TypeSymbol typeSymbol2 = typeSymbol;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TypeReferenceTypeSymbol.class, ArrayTypeSymbol.class, TupleTypeSymbol.class, RecordTypeSymbol.class, UnionTypeSymbol.class}, (Object)typeSymbol2, n)) {
            case 0: {
                TypeReferenceTypeSymbol typeReference = (TypeReferenceTypeSymbol)typeSymbol2;
                if (!typeReference.subtypeOf(anydataType)) {
                    return;
                }
                typeSchemas.put((String)typeReference.definition().getName().get(), RuntimePromptAsCodeCodeModificationTask.getJsonSchema(typeMapper.getSchema((TypeSymbol)typeReference)));
                break;
            }
            case 1: {
                ArrayTypeSymbol arrayType = (ArrayTypeSymbol)typeSymbol2;
                RuntimePromptAsCodeCodeModificationTask.populateTypeSchema(arrayType.memberTypeDescriptor(), typeMapper, typeSchemas, anydataType);
                break;
            }
            case 2: {
                TupleTypeSymbol tupleType = (TupleTypeSymbol)typeSymbol2;
                tupleType.members().forEach(member -> RuntimePromptAsCodeCodeModificationTask.populateTypeSchema(member.typeDescriptor(), typeMapper, typeSchemas, anydataType));
                break;
            }
            case 3: {
                RecordTypeSymbol recordType = (RecordTypeSymbol)typeSymbol2;
                recordType.fieldDescriptors().values().forEach(field -> RuntimePromptAsCodeCodeModificationTask.populateTypeSchema(field.typeDescriptor(), typeMapper, typeSchemas, anydataType));
                break;
            }
            case 4: {
                UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol2;
                unionTypeSymbol.memberTypeDescriptors().forEach(member -> RuntimePromptAsCodeCodeModificationTask.populateTypeSchema(member, typeMapper, typeSchemas, anydataType));
                break;
            }
        }
    }

    private static String getJsonSchema(Schema schema) {
        RuntimePromptAsCodeCodeModificationTask.modifySchema(schema);
        OpenAPISchema2JsonSchema openAPISchema2JsonSchema = new OpenAPISchema2JsonSchema();
        openAPISchema2JsonSchema.process(schema);
        String newLineRegex = "\\R";
        String jsonCompressionRegex = "\\s*([{}\\[\\]:,])\\s*";
        return Json.pretty((Object)schema.getJsonSchema()).replaceAll(newLineRegex, "").replaceAll(jsonCompressionRegex, "$1");
    }

    private static void modifySchema(Schema schema) {
        List oneOf;
        List anyOf;
        List allOf;
        if (schema == null) {
            return;
        }
        RuntimePromptAsCodeCodeModificationTask.modifySchema(schema.getItems());
        RuntimePromptAsCodeCodeModificationTask.modifySchema(schema.getNot());
        Map properties = schema.getProperties();
        if (properties != null) {
            properties.values().forEach(RuntimePromptAsCodeCodeModificationTask::modifySchema);
        }
        if ((allOf = schema.getAllOf()) != null) {
            schema.setType(null);
            allOf.forEach(RuntimePromptAsCodeCodeModificationTask::modifySchema);
        }
        if ((anyOf = schema.getAnyOf()) != null) {
            schema.setType(null);
            anyOf.forEach(RuntimePromptAsCodeCodeModificationTask::modifySchema);
        }
        if ((oneOf = schema.getOneOf()) != null) {
            schema.setType(null);
            oneOf.forEach(RuntimePromptAsCodeCodeModificationTask::modifySchema);
        }
        if (BYTE.equals(schema.getFormat()) && STRING.equals(schema.getType())) {
            schema.setFormat(null);
            schema.setType(NUMBER);
        }
        RuntimePromptAsCodeCodeModificationTask.removeUnwantedFields(schema);
    }

    private static void removeUnwantedFields(Schema schema) {
        schema.setSpecVersion(null);
        schema.setSpecVersion(null);
        schema.setContains(null);
        schema.set$id(null);
        schema.set$schema(null);
        schema.set$anchor(null);
        schema.setExclusiveMaximumValue(null);
        schema.setExclusiveMinimumValue(null);
        schema.setDiscriminator(null);
        schema.setTitle(null);
        schema.setMaximum(null);
        schema.setExclusiveMaximum(null);
        schema.setMinimum(null);
        schema.setExclusiveMinimum(null);
        schema.setMaxLength(null);
        schema.setMinLength(null);
        schema.setMaxItems(null);
        schema.setMinItems(null);
        schema.setMaxProperties(null);
        schema.setMinProperties(null);
        schema.setAdditionalProperties(null);
        schema.setAdditionalProperties(null);
        schema.set$ref(null);
        schema.set$ref(null);
        schema.setReadOnly(null);
        schema.setWriteOnly(null);
        schema.setExample(null);
        schema.setExample(null);
        schema.setExternalDocs(null);
        schema.setDeprecated(null);
        schema.setPrefixItems(null);
        schema.setContentEncoding(null);
        schema.setContentMediaType(null);
        schema.setContentSchema(null);
        schema.setPropertyNames(null);
        schema.setUnevaluatedProperties(null);
        schema.setMaxContains(null);
        schema.setMinContains(null);
        schema.setAdditionalItems(null);
        schema.setUnevaluatedItems(null);
        schema.setIf(null);
        schema.setElse(null);
        schema.setThen(null);
        schema.setDependentSchemas(null);
        schema.set$comment(null);
        schema.setExamples(null);
        schema.setExtensions(null);
        schema.setConst(null);
    }

    static final class ModifierData {
        Set<Document> documentsRequiringAiImport = new HashSet<Document>(0);
        Map<String, String> typeSchemas = new HashMap<String, String>();

        ModifierData() {
        }
    }

    private static class NaturalExpressionSchemaGenerator
    extends BaseNodeModifier {
        private final ModifierData modifierData;
        private final SemanticModel semanticModel;
        private final Document document;
        private final TypeMapper typeMapper;

        NaturalExpressionSchemaGenerator(ModifierData modifierData, SourceModifierContext modifierContext, ModuleId moduleId, Document document, TypeMapper typeMapper) {
            this.modifierData = modifierData;
            this.semanticModel = modifierContext.compilation().getSemanticModel(moduleId);
            this.document = document;
            this.typeMapper = typeMapper;
        }

        public NaturalExpressionNode transform(NaturalExpressionNode naturalExpressionNode) {
            Optional typeSymbol = this.semanticModel.expectedType(this.document, naturalExpressionNode.lineRange().startLine());
            typeSymbol.ifPresent(symbol -> RuntimePromptAsCodeCodeModificationTask.populateTypeSchema(symbol, this.typeMapper, this.modifierData.typeSchemas, this.semanticModel.types().ANYDATA));
            return naturalExpressionNode;
        }
    }

    private static class TypeDefinitionModifier
    extends TreeModifier {
        private final Map<String, String> typeSchemas;
        private final ModifierData modifierData;
        private final Optional<String> aiImportPrefix;
        private final Document document;

        TypeDefinitionModifier(Map<String, String> typeSchemas, ModifierData modifierData, Optional<String> aiImportPrefix, Document document) {
            this.typeSchemas = typeSchemas;
            this.modifierData = modifierData;
            this.aiImportPrefix = aiImportPrefix;
            this.document = document;
        }

        public TypeDefinitionNode transform(TypeDefinitionNode typeDefinitionNode) {
            String typeName = typeDefinitionNode.typeName().text();
            if (!this.typeSchemas.containsKey(typeName)) {
                return typeDefinitionNode;
            }
            if (this.aiImportPrefix.isEmpty()) {
                this.modifierData.documentsRequiringAiImport.add(this.document);
            }
            MetadataNode updatedMetadataNode = this.updateMetadata(typeDefinitionNode, this.typeSchemas.get(typeName), this.aiImportPrefix.orElse("ai"));
            return typeDefinitionNode.modify().withMetadata(updatedMetadataNode).apply();
        }

        private MetadataNode updateMetadata(TypeDefinitionNode typeDefinitionNode, String schema, String aiPrefix) {
            MetadataNode metadataNode = RuntimePromptAsCodeCodeModificationTask.getMetadataNode(typeDefinitionNode);
            NodeList<AnnotationNode> updatedAnnotations = RuntimePromptAsCodeCodeModificationTask.updateAnnotations((NodeList<AnnotationNode>)metadataNode.annotations(), schema, aiPrefix);
            return metadataNode.modify().withAnnotations(updatedAnnotations).apply();
        }
    }
}

