/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.ai.np.compilerplugin;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.NaturalExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.lib.ai.np.compilerplugin.CodeModifier;
import io.ballerina.lib.ai.np.compilerplugin.Commons;
import io.ballerina.lib.ai.np.compilerplugin.DiagnosticLog;
import io.ballerina.projects.Document;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.Location;
import java.util.Optional;

public class Validator
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private static final String CODE_ANNOTATION = "code";
    private final CodeModifier.AnalysisData analysisData;
    private Optional<TypeSymbol> jsonOrErrorType = Optional.empty();

    Validator(CodeModifier.AnalysisData analysisData) {
        this.analysisData = analysisData;
    }

    public void perform(SyntaxNodeAnalysisContext ctx) {
        SemanticModel semanticModel = ctx.semanticModel();
        Types types = semanticModel.types();
        Package currentPackage = ctx.currentPackage();
        ModuleId moduleId = ctx.moduleId();
        Module module = currentPackage.module(moduleId);
        Document document = module.document(ctx.documentId());
        Node node = ctx.node();
        if (node instanceof NaturalExpressionNode) {
            NaturalExpressionNode naturalExpressionNode = (NaturalExpressionNode)node;
            this.validateNaturalExpression(semanticModel, types, document, naturalExpressionNode, ctx);
            return;
        }
        if (node instanceof AnnotationNode) {
            AnnotationNode annotationNode = (AnnotationNode)node;
            this.validateCompileTimeCodeGenAnnotation(semanticModel, annotationNode, ctx, currentPackage.project().kind() == ProjectKind.SINGLE_FILE_PROJECT);
            return;
        }
    }

    private void validateNaturalExpression(SemanticModel semanticModel, Types types, Document document, NaturalExpressionNode naturalExpressionNode, SyntaxNodeAnalysisContext ctx) {
        if (naturalExpressionNode.constKeyword().isPresent()) {
            return;
        }
        this.validateExpectedType((Location)naturalExpressionNode.location(), (TypeSymbol)semanticModel.expectedType(document, naturalExpressionNode.lineRange().startLine()).get(), types, ctx);
    }

    private void validateCompileTimeCodeGenAnnotation(SemanticModel semanticModel, AnnotationNode annotationNode, SyntaxNodeAnalysisContext ctx, boolean isSingleBalFileMode) {
        QualifiedNameReferenceNode qualifiedNameReferenceNode;
        Node node = annotationNode.annotReference();
        if (!(node instanceof QualifiedNameReferenceNode) || !CODE_ANNOTATION.equals((qualifiedNameReferenceNode = (QualifiedNameReferenceNode)node).identifier().text())) {
            return;
        }
        if (Validator.isLangNaturalModule((ModuleSymbol)((Symbol)semanticModel.symbol(node).get()).getModule().get()) && isSingleBalFileMode && Commons.isCodeAnnotation(annotationNode, semanticModel)) {
            DiagnosticLog.reportError(ctx, this.analysisData, (Location)annotationNode.location(), DiagnosticLog.DiagnosticCode.CODE_GEN_WITH_CODE_ANNOT_NOT_SUPPORTED_IN_SINGLE_BAL_FILE_MODE, new Object[0]);
        }
    }

    private void validateExpectedType(Location location, TypeSymbol expectedType, Types types, SyntaxNodeAnalysisContext ctx) {
        if (!expectedType.subtypeOf(this.getJsonOrErrorType(types))) {
            DiagnosticLog.reportError(ctx, this.analysisData, location, DiagnosticLog.DiagnosticCode.NON_JSON_EXPECTED_TYPE_NOT_YET_SUPPORTED, new Object[0]);
        }
    }

    private TypeSymbol getJsonOrErrorType(Types types) {
        if (this.jsonOrErrorType.isPresent()) {
            return this.jsonOrErrorType.get();
        }
        UnionTypeSymbol jsonOrErrorType = types.builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{types.JSON, types.ERROR}).build();
        this.jsonOrErrorType = Optional.of(jsonOrErrorType);
        return jsonOrErrorType;
    }

    private static boolean isLangNaturalModule(ModuleSymbol moduleSymbol) {
        ModuleID moduleId = moduleSymbol.id();
        return "ballerina".equals(moduleId.orgName()) && "lang.natural".equals(moduleId.moduleName());
    }
}

