/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.actions.websocketconnector;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnection;
import io.ballerina.stdlib.websocket.ModuleUtils;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.WebSocketService;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.observability.WebSocketObservabilityUtil;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionInfo;
import io.ballerina.stdlib.websocket.server.WebSocketServerService;
import io.netty.channel.ChannelFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Close {
    private static final Logger log = LoggerFactory.getLogger(Close.class);

    public static Object externClose(Environment env, BObject wsConnection, long statusCode, BString reason, Object bTimeoutInSecs) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            WebSocketConnectionInfo connectionInfo = (WebSocketConnectionInfo)wsConnection.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO");
            WebSocketObservabilityUtil.observeResourceInvocation(env, connectionInfo, "close");
            try {
                int timeoutInSecs = Close.getConnectionClosureTimeout(bTimeoutInSecs, connectionInfo);
                CountDownLatch countDownLatch = new CountDownLatch(1);
                ArrayList<BError> errors = new ArrayList<BError>(1);
                ChannelFuture closeFuture = Close.initiateConnectionClosure(errors, (int)statusCode, reason.getValue(), connectionInfo, countDownLatch);
                connectionInfo.getWebSocketConnection().readNextFrame();
                Close.waitForTimeout(errors, timeoutInSecs, countDownLatch, connectionInfo);
                closeFuture.channel().close().addListener(future -> {
                    WebSocketUtil.setListenerOpenField(connectionInfo);
                    if (errors.isEmpty()) {
                        balFuture.complete(null);
                    } else {
                        balFuture.complete(errors.getLast());
                    }
                });
                WebSocketObservabilityUtil.observeSend("close", connectionInfo);
            }
            catch (Exception e) {
                log.error("Error occurred when closing the connection", (Throwable)e);
                WebSocketObservabilityUtil.observeError(WebSocketObservabilityUtil.getConnectionInfo(wsConnection), "message_sent", "close", e.getMessage());
                balFuture.complete((Object)WebSocketUtil.createErrorByType(e));
            }
            return ModuleUtils.getResult(balFuture);
        });
    }

    public static int getConnectionClosureTimeout(Object bTimeoutInSecs, WebSocketConnectionInfo connectionInfo) {
        try {
            int timeoutInSecs = 0;
            if (bTimeoutInSecs instanceof BDecimal) {
                timeoutInSecs = Integer.parseInt(bTimeoutInSecs.toString());
            } else {
                WebSocketService webSocketService = connectionInfo.getService();
                if (webSocketService instanceof WebSocketServerService) {
                    WebSocketServerService webSocketServerService = (WebSocketServerService)webSocketService;
                    timeoutInSecs = webSocketServerService.getConnectionClosureTimeout();
                }
            }
            return timeoutInSecs;
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid timeout value: " + String.valueOf(bTimeoutInSecs), e);
        }
    }

    public static ChannelFuture initiateConnectionClosure(List<BError> errors, int statusCode, String reason, WebSocketConnectionInfo connectionInfo, CountDownLatch latch) throws IllegalAccessException {
        WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
        ChannelFuture closeFuture = webSocketConnection.initiateConnectionClosure(statusCode, reason);
        return closeFuture.addListener(future -> {
            Throwable cause = future.cause();
            if (!future.isSuccess() && cause != null) {
                Close.addError(cause.getMessage(), errors);
                WebSocketObservabilityUtil.observeError(connectionInfo, "close", cause.getMessage());
            }
            latch.countDown();
        });
    }

    public static void waitForTimeout(List<BError> errors, int timeoutInSecs, CountDownLatch latch, WebSocketConnectionInfo connectionInfo) {
        try {
            if (timeoutInSecs < 0) {
                latch.await();
            } else {
                boolean countDownReached = latch.await(timeoutInSecs, TimeUnit.SECONDS);
                if (!countDownReached) {
                    String errMsg = String.format("Could not receive a WebSocket close frame from remote endpoint within %d seconds", timeoutInSecs);
                    Close.addError(errMsg, errors);
                    WebSocketObservabilityUtil.observeError(connectionInfo, "close", errMsg);
                }
            }
        }
        catch (InterruptedException err) {
            String errMsg = "Connection interrupted while closing the connection";
            Close.addError(errMsg, errors);
            WebSocketObservabilityUtil.observeError(connectionInfo, "close", errMsg);
            Thread.currentThread().interrupt();
        }
    }

    private static void addError(String errMsg, List<BError> errors) {
        errors.add(WebSocketUtil.getWebSocketError(errMsg, null, WebSocketConstants.ErrorCode.ConnectionClosureError.errorCode(), null));
    }

    private Close() {
    }
}

