/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.client.listener;

import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.contract.websocket.ClientHandshakeListener;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnection;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.transport.message.HttpCarbonResponse;
import io.ballerina.stdlib.websocket.WebSocketService;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.client.listener.SyncClientConnectorListener;
import io.ballerina.stdlib.websocket.observability.WebSocketObservabilityUtil;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionInfo;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class WebSocketHandshakeListener
implements ClientHandshakeListener {
    private final WebSocketService wsService;
    private final SyncClientConnectorListener connectorListener;
    private final BObject webSocketClient;
    private WebSocketConnectionInfo connectionInfo;
    private final CompletableFuture<Object> balFuture;
    AtomicBoolean callbackCompleted;

    public WebSocketHandshakeListener(BObject webSocketClient, WebSocketService wsService, SyncClientConnectorListener connectorListener, CompletableFuture<Object> future, AtomicBoolean callbackCompleted) {
        this.webSocketClient = webSocketClient;
        this.wsService = wsService;
        this.connectorListener = connectorListener;
        this.balFuture = future;
        this.callbackCompleted = callbackCompleted;
    }

    public void onSuccess(WebSocketConnection webSocketConnection, HttpCarbonResponse carbonResponse) {
        this.webSocketClient.addNativeData("response", (Object)HttpUtil.createResponseStruct((HttpCarbonMessage)carbonResponse));
        WebSocketUtil.populatWebSocketEndpoint(webSocketConnection, this.webSocketClient);
        this.setWebSocketOpenConnectionInfo(webSocketConnection, this.webSocketClient, this.wsService);
        this.connectorListener.setConnectionInfo(this.connectionInfo);
        webSocketConnection.removeReadIdleStateHandler();
        if (!this.callbackCompleted.get()) {
            this.balFuture.complete(null);
            this.callbackCompleted.set(true);
        }
        WebSocketObservabilityUtil.observeConnection(this.connectionInfo);
    }

    public void onError(Throwable t, HttpCarbonResponse response) {
        if (response != null) {
            this.webSocketClient.addNativeData("response", (Object)HttpUtil.createResponseStruct((HttpCarbonMessage)response));
        }
        this.setWebSocketOpenConnectionInfo(null, this.webSocketClient, this.wsService);
        if (!this.callbackCompleted.get()) {
            this.balFuture.complete((Object)WebSocketUtil.createErrorByType(t));
            this.callbackCompleted.set(true);
        }
    }

    private void setWebSocketOpenConnectionInfo(WebSocketConnection webSocketConnection, BObject webSocketClient, WebSocketService wsService) {
        this.connectionInfo = new WebSocketConnectionInfo(wsService, webSocketConnection, webSocketClient);
        webSocketClient.addNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO", (Object)this.connectionInfo);
    }
}

