/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.server;

import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketMessage;
import io.ballerina.stdlib.http.uri.parser.DataElement;
import io.ballerina.stdlib.http.uri.parser.DataReturnAgent;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.server.WebSocketServerService;

public class WebSocketDataElement
implements DataElement<WebSocketServerService, WebSocketMessage> {
    private WebSocketServerService webSocketService;
    private boolean isFirstTraverse = true;

    public boolean hasData() {
        return true;
    }

    public void setData(WebSocketServerService webSocketService) {
        if (this.isFirstTraverse && webSocketService == null) {
            throw WebSocketUtil.getWebSocketError("Service has not been registered", null, WebSocketConstants.ErrorCode.Error.errorCode(), null);
        }
        if (this.isFirstTraverse) {
            this.isFirstTraverse = false;
            this.webSocketService = webSocketService;
        } else if (webSocketService == null) {
            this.isFirstTraverse = true;
            this.webSocketService = null;
        } else {
            throw WebSocketUtil.getWebSocketError("Two services have the same addressable URI", null, WebSocketConstants.ErrorCode.Error.errorCode(), null);
        }
    }

    public boolean getData(WebSocketMessage inboundMessage, DataReturnAgent<WebSocketServerService> dataReturnAgent) {
        if (this.webSocketService == null) {
            return false;
        }
        dataReturnAgent.setData((Object)this.webSocketService);
        return true;
    }
}

