/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.server;

import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.HttpResourceArguments;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketHandshaker;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketMessage;
import io.ballerina.stdlib.http.uri.URITemplate;
import io.ballerina.stdlib.http.uri.URITemplateException;
import io.ballerina.stdlib.http.uri.parser.DataElement;
import io.ballerina.stdlib.http.uri.parser.DataElementFactory;
import io.ballerina.stdlib.http.uri.parser.Literal;
import io.ballerina.stdlib.http.uri.parser.Node;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.server.WebSocketDataElement;
import io.ballerina.stdlib.websocket.server.WebSocketDataElementFactory;
import io.ballerina.stdlib.websocket.server.WebSocketServerService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServicesRegistry {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketServicesRegistry.class);
    private URITemplate<WebSocketServerService, WebSocketMessage> uriTemplate;
    Map<String, WebSocketServerService> servicesByBasePath = new ConcurrentHashMap<String, WebSocketServerService>();
    List<String> sortedServiceURIs = new CopyOnWriteArrayList<String>();

    public WebSocketServicesRegistry() {
        try {
            this.uriTemplate = new URITemplate((Node)new Literal((DataElement)new WebSocketDataElement(), "/"));
        }
        catch (URITemplateException uRITemplateException) {
            // empty catch block
        }
    }

    public void registerService(WebSocketServerService service) {
        String basePath = service.getBasePath();
        try {
            basePath = URLDecoder.decode(basePath, StandardCharsets.UTF_8.name());
            this.uriTemplate.parse(basePath, (Object)service, (DataElementFactory)new WebSocketDataElementFactory());
            this.servicesByBasePath.put(basePath, service);
            this.sortedServiceURIs.add(basePath);
            this.sortedServiceURIs.sort((basePath1, basePath2) -> basePath2.length() - basePath1.length());
        }
        catch (URITemplateException | UnsupportedEncodingException e) {
            logger.error("Error when registering service", e);
            throw WebSocketUtil.getWebSocketError("", e, WebSocketConstants.ErrorCode.Error.errorCode(), null);
        }
        logger.debug("WebSocketService deployed with context {}", (Object)basePath);
    }

    public WebSocketServerService findMatching(String path, HttpResourceArguments pathParams, WebSocketHandshaker webSocketHandshaker) {
        return (WebSocketServerService)this.uriTemplate.matches(path, pathParams, (Object)webSocketHandshaker);
    }

    public BError unRegisterService(BObject serviceObj) {
        try {
            String basePath = (String)serviceObj.getNativeData("BASE_PATH");
            if (basePath == null) {
                throw WebSocketUtil.getWebSocketError("Cannot detach service. Service has not been registered", null, WebSocketConstants.ErrorCode.Error.errorCode(), null);
            }
            this.uriTemplate.parse(basePath, null, (DataElementFactory)new WebSocketDataElementFactory());
            serviceObj.addNativeData("BASE_PATH", null);
        }
        catch (URITemplateException | UnsupportedEncodingException e) {
            logger.error("Error when unRegistering service", e);
            return WebSocketUtil.getWebSocketError("", e, WebSocketConstants.ErrorCode.Error.errorCode(), null);
        }
        catch (BError e) {
            return e;
        }
        return null;
    }

    Map<String, WebSocketServerService> getServicesByBasePath() {
        return this.servicesByBasePath;
    }

    List<String> getSortedServiceURIs() {
        return this.sortedServiceURIs;
    }

    String findTheMostSpecificBasePath(String requestURIPath, Map<String, WebSocketServerService> services, List<String> sortedServiceURIs) {
        for (String key : sortedServiceURIs) {
            if (!requestURIPath.toLowerCase(Locale.getDefault()).contains(key.toString().toLowerCase(Locale.getDefault()))) continue;
            if (requestURIPath.length() <= key.toString().length()) {
                return key.toString();
            }
            if (!requestURIPath.startsWith(key.toString().concat("/"))) continue;
            return key.toString();
        }
        if (services.containsKey("/")) {
            return "/";
        }
        return null;
    }
}

