/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.projects.CompilationCache;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.ProjectLoadResult;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.projects.directory.WorkspaceProject;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.repos.FileSystemCache;
import io.ballerina.projects.util.ProjectUtils;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="clean", description={"Clean the artifacts generated during the build"})
public class CleanCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final Path projectPath;
    private final boolean exitWhenFinish;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--target-dir"}, description={"target directory path"})
    private Path targetDir;
    @CommandLine.Option(names={"--dependency-cache"}, description={"clean the caches of project dependencies"})
    private boolean depCache;

    public CleanCommand(Path projectPath, boolean exitWhenFinish) {
        this.projectPath = projectPath;
        this.outStream = System.out;
        this.exitWhenFinish = exitWhenFinish;
    }

    public CleanCommand() {
        this.projectPath = Path.of(System.getProperty("user.dir"), new String[0]);
        this.outStream = System.out;
        this.exitWhenFinish = true;
    }

    public CleanCommand(Path projectPath, PrintStream printStream, boolean exitWhenFinish, Path targetDir) {
        this.projectPath = projectPath;
        this.outStream = printStream;
        this.exitWhenFinish = exitWhenFinish;
        this.targetDir = targetDir;
    }

    public CleanCommand(Path projectPath, PrintStream printStream, boolean depCache, boolean exitWhenFinish) {
        this.projectPath = projectPath;
        this.outStream = printStream;
        this.exitWhenFinish = exitWhenFinish;
        this.depCache = depCache;
    }

    @Override
    public void execute() {
        ProjectLoadResult loadResult;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("clean");
            this.outStream.println(commandUsageInfo);
            return;
        }
        if (this.targetDir != null) {
            if (Files.notExists(this.targetDir, new LinkOption[0])) {
                CommandUtil.printError(this.outStream, "provided target directory '" + String.valueOf(this.targetDir) + "' does not exist.", null, false);
            } else if (!Files.isDirectory(this.targetDir, new LinkOption[0])) {
                CommandUtil.printError(this.outStream, "provided target path '" + String.valueOf(this.targetDir) + "' is not a directory.", null, false);
            } else {
                boolean isValidTarget;
                Path cacheDir = this.targetDir.resolve("cache");
                boolean bl = isValidTarget = Files.exists(cacheDir, new LinkOption[0]) && (Files.exists(this.targetDir.resolve("bala"), new LinkOption[0]) || Files.exists(this.targetDir.resolve("bin"), new LinkOption[0]) || Files.exists(this.targetDir.resolve("apidocs"), new LinkOption[0]) || Files.exists(cacheDir.resolve("tests_cache"), new LinkOption[0]));
                if (!isValidTarget) {
                    CommandUtil.printError(this.outStream, "provided target directory '" + String.valueOf(this.targetDir) + "' is not a valid target directory.", null, false);
                    return;
                }
                ProjectUtils.deleteDirectory((Path)this.targetDir);
                this.outStream.println("Successfully deleted '" + String.valueOf(this.targetDir));
            }
            return;
        }
        try {
            loadResult = ProjectLoader.load((Path)this.projectPath);
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.outStream, "invalid project directory: " + e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        Project project = loadResult.project();
        if (project.kind().equals((Object)ProjectKind.SINGLE_FILE_PROJECT)) {
            CommandUtil.printError(this.outStream, "clean command is not supported for single file projects.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (project.kind().equals((Object)ProjectKind.WORKSPACE_PROJECT)) {
            List projectList;
            WorkspaceProject workspaceProject = (WorkspaceProject)project;
            if (this.depCache) {
                ResolutionOptions resolutionOptions = ResolutionOptions.builder().setOffline(true).build();
                projectList = workspaceProject.getResolution(resolutionOptions).dependencyGraph().toTopologicallySortedList();
            } else {
                projectList = workspaceProject.projects();
            }
            for (BuildProject buildProject : projectList) {
                if (this.depCache) {
                    this.cleanDependencyCaches(project);
                }
                this.cleanProject((Project)buildProject);
            }
            this.cleanProject(project);
        } else {
            if (this.depCache) {
                this.cleanDependencyCaches(project);
            }
            this.cleanProject(project);
        }
    }

    private void cleanDependencyCaches(Project project) {
        ResolutionOptions resolutionOptions = ResolutionOptions.builder().setOffline(true).setSticky(project.buildOptions().sticky()).setPackageLockingMode(project.buildOptions().lockingMode()).build();
        PackageResolution packageResolution = project.currentPackage().getResolution(resolutionOptions);
        for (ResolvedPackageDependency packageDependency : packageResolution.allDependencies()) {
            Project dependency = packageDependency.packageInstance().project();
            if (!dependency.kind().equals((Object)ProjectKind.BALA_PROJECT) || ProjectUtils.isBuiltInPackage((PackageOrg)packageDependency.packageInstance().packageOrg(), (String)packageDependency.packageInstance().packageName().toString()) || Files.notExists(dependency.sourceRoot(), new LinkOption[0]) || dependency.sourceRoot().startsWith(ProjectUtils.getBallerinaHomePath().resolve("repo"))) continue;
            ProjectUtils.deleteDirectory((Path)dependency.sourceRoot());
            this.outStream.println("Successfully deleted " + String.valueOf(dependency.sourceRoot()));
            Path birPath = ((FileSystemCache)dependency.projectEnvironmentContext().getService(CompilationCache.class)).cachePath();
            if (birPath == null || Files.notExists(birPath, new LinkOption[0])) continue;
            ProjectUtils.deleteDirectory((Path)birPath);
            this.outStream.println("Successfully deleted " + String.valueOf(birPath));
        }
    }

    private void cleanProject(Project project) {
        Path generatedDir;
        try {
            generatedDir = project.sourceRoot().resolve("generated");
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.outStream, e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (Files.exists(project.targetDir(), new LinkOption[0])) {
            ProjectUtils.deleteDirectory((Path)project.targetDir());
            this.outStream.println("Successfully deleted " + String.valueOf(project.targetDir()));
        }
        if (Files.exists(generatedDir, new LinkOption[0])) {
            ProjectUtils.deleteDirectory((Path)generatedDir);
            this.outStream.println("Successfully deleted " + String.valueOf(generatedDir));
        }
    }

    @Override
    public String getName() {
        return "clean";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("clean"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append(" bal clean \n");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

