/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.TaskExecutor;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.cmd.PackageLockingModeConverter;
import io.ballerina.cli.task.CompileTask;
import io.ballerina.cli.task.CreateDocsTask;
import io.ballerina.cli.task.CreateTargetDirTask;
import io.ballerina.cli.task.ResolveMavenDependenciesTask;
import io.ballerina.cli.task.RunBuildToolsTask;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.bala.BalaProject;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.environment.PackageLockingMode;
import io.ballerina.projects.repos.TempDirCompilationCache;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.docgen.docs.BallerinaDocGenerator;
import picocli.CommandLine;

@CommandLine.Command(name="doc", description={"Generate current package's documentation"})
public class DocCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private Path projectPath = Path.of(System.getProperty("user.dir"), new String[0]);
    private Path outputPath;
    private final boolean exitWhenFinish;
    @CommandLine.Option(names={"--o", "-o"}, description={"Location to save API Docs."})
    private String outputLoc;
    @CommandLine.Option(names={"--combine", "-combine"}, description={"Creates index using modules."})
    private boolean combine;
    @CommandLine.Option(names={"--offline"}, description={"Compiles offline without downloading dependencies."})
    private Boolean offline;
    @CommandLine.Option(names={"--old-parser"}, description={"Enable old parser."}, hidden=true)
    private boolean useOldParser;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--exclude", "-e"}, description={"List of modules to be excluded."})
    private String[] excludes;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental language features."})
    private boolean experimentalFlag;
    @CommandLine.Option(names={"--target-dir"}, description={"target directory path"})
    private Path targetDir;
    @CommandLine.Option(names={"--disable-syntax-tree-caching"}, hidden=true, description={"disable syntax tree caching for source files"}, defaultValue="false")
    private Boolean disableSyntaxTreeCaching;
    @CommandLine.Option(names={"--show-dependency-diagnostics"}, description={"Show the diagnostics generated by the dependencies"})
    private Boolean showDependencyDiagnostics;
    @CommandLine.Option(names={"--optimize-dependency-compilation"}, hidden=true, description={"experimental memory optimization for large projects"})
    private Boolean optimizeDependencyCompilation;
    @CommandLine.Option(names={"--locking-mode"}, hidden=true, description={"allow passing the package locking mode."}, converter={PackageLockingModeConverter.class})
    private PackageLockingMode lockingMode;

    public DocCommand() {
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = true;
    }

    DocCommand(PrintStream outStream, PrintStream errStream, boolean exitWhenFinish) {
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.offline = true;
    }

    DocCommand(PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, Path targetDir) {
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.targetDir = targetDir;
        this.offline = true;
    }

    @Override
    public void execute() {
        BuildProject project;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("doc");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (this.argList == null) {
            this.projectPath = Path.of(System.getProperty("user.dir"), new String[0]);
        } else {
            if (this.argList.get(0).endsWith(".bala")) {
                this.projectPath = Path.of(System.getProperty("user.dir"), new String[0]);
                Path balaPath = this.projectPath.resolve(this.argList.get(0));
                ProjectEnvironmentBuilder defaultBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
                defaultBuilder.addCompilationCacheFactory(TempDirCompilationCache::from);
                BalaProject balaProject = BalaProject.loadProject((ProjectEnvironmentBuilder)defaultBuilder, (Path)balaPath);
                try {
                    BallerinaDocGenerator.generateAPIDocs((Project)balaProject, (String)this.projectPath.toString(), (boolean)false);
                }
                catch (IOException e) {
                    CommandUtil.printError(this.errStream, e.getMessage(), null, false);
                    CommandUtil.exitError(this.exitWhenFinish);
                    return;
                }
                return;
            }
            this.projectPath = Path.of(this.argList.get(0), new String[0]);
        }
        if (this.combine) {
            this.outStream.println("Combining Docs");
            BallerinaDocGenerator.mergeApiDocs((Path)this.projectPath);
            if (this.exitWhenFinish) {
                Runtime.getRuntime().exit(0);
            }
        }
        if (this.argList != null && this.argList.get(0).endsWith(".bal")) {
            CommandUtil.printError(this.errStream, "generating API Documentation is not supported for a single Ballerina file.", null, false);
            CommandUtil.exitError(true);
            return;
        }
        if (this.argList != null && this.argList.size() > 1) {
            CommandUtil.printError(this.errStream, "too many arguments", "bal doc <project_path> [--offline]\n", false);
            CommandUtil.exitError(true);
            return;
        }
        BuildOptions buildOptions = this.constructBuildOptions();
        try {
            project = BuildProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.errStream, e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        this.projectPath = this.projectPath.normalize();
        this.outputPath = this.outputLoc != null ? Path.of(this.outputLoc, new String[0]).toAbsolutePath() : null;
        ArrayList<Diagnostic> buildToolDiagnostics = new ArrayList<Diagnostic>();
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CreateTargetDirTask()).addTask(new RunBuildToolsTask(this.outStream, false, buildToolDiagnostics)).addTask(new ResolveMavenDependenciesTask(this.outStream)).addTask(new CompileTask(this.outStream, this.errStream, false, false, false, buildToolDiagnostics)).addTask(new CreateDocsTask(this.outStream, this.outputPath)).build();
        taskExecutor.executeTasks((Project)project);
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    @Override
    public String getName() {
        return "doc";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("doc"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("  bal doc \n");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private BuildOptions constructBuildOptions() {
        BuildOptions.BuildOptionsBuilder buildOptionsBuilder = BuildOptions.builder();
        buildOptionsBuilder.setCodeCoverage(Boolean.valueOf(false)).setExperimental(Boolean.valueOf(this.experimentalFlag)).setOffline(this.offline).setTestReport(Boolean.valueOf(false)).setObservabilityIncluded(Boolean.valueOf(false)).disableSyntaxTreeCaching(this.disableSyntaxTreeCaching).setShowDependencyDiagnostics(this.showDependencyDiagnostics).setOptimizeDependencyCompilation(this.optimizeDependencyCompilation);
        if (this.targetDir != null) {
            buildOptionsBuilder.targetDir(this.targetDir.toString());
        }
        return buildOptionsBuilder.build();
    }
}

