/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.launcher.BLauncherException;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectLoadResult;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.projects.util.FileUtils;
import io.ballerina.projects.util.ProjectPaths;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.projects.util.TomlUtil;
import io.ballerina.toml.api.Toml;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="new", description={"Create a new Ballerina package"})
public class NewCommand
implements BLauncherCmd {
    private final PrintStream errStream;
    private final boolean exitWhenFinish;
    Path homeCache = RepoUtils.createAndGetHomeReposPath();
    @CommandLine.Parameters
    public List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--template", "-t"}, description={"Acceptable values: [main, service, lib] default: default"})
    public String template = "default";
    @CommandLine.Option(names={"--workspace"})
    private boolean workspace;

    public NewCommand() {
        this.errStream = System.err;
        this.exitWhenFinish = true;
        CommandUtil.initJarFs();
    }

    public NewCommand(PrintStream errStream, boolean exitWhenFinish) {
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        CommandUtil.initJarFs();
    }

    public NewCommand(PrintStream errStream, boolean exitWhenFinish, Path customHomeCache) {
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        CommandUtil.initJarFs();
        this.homeCache = customHomeCache;
    }

    @Override
    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("new");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (null == this.argList) {
            CommandUtil.printError(this.errStream, "project path is not provided.", "bal new <project-path>", true);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (1 != this.argList.size()) {
            CommandUtil.printError(this.errStream, "too many arguments", "bal new <project-path>", true);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        Path packagePath = Path.of(this.argList.get(0), new String[0]);
        Path currentDir = Path.of(System.getProperty("user.dir"), new String[0]);
        if (!packagePath.isAbsolute()) {
            packagePath = Path.of(currentDir.toString(), packagePath.toString()).normalize();
        }
        ArrayList<Path> filesInDir = new ArrayList();
        CommandUtil.setPrintStream(this.errStream);
        Optional<Path> optionalPackageName = Optional.ofNullable(packagePath.getFileName());
        if (optionalPackageName.isEmpty()) {
            CommandUtil.printError(this.errStream, "package name could not be derived", "bal new <project-path>", true);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String packageName = optionalPackageName.get().toString();
        boolean balFilesExist = false;
        if (Files.exists(packagePath, new LinkOption[0])) {
            if (ProjectUtils.isBallerinaProject((Path)packagePath)) {
                CommandUtil.printError(this.errStream, "directory is already a Ballerina project.", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            if (!this.workspace && FileUtils.checkBallerinaTomlInExistingDir((Path)packagePath)) {
                CommandUtil.printError(this.errStream, "directory already contains a Ballerina project", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            String packageFiles = CommandUtil.checkPackageFilesExists(packagePath);
            if (!packageFiles.isEmpty() && !this.template.equals("default")) {
                CommandUtil.printError(this.errStream, "existing " + packageFiles.substring(0, packageFiles.length() - 2) + " file/directory(s) were found. Please use a different directory or remove existing files.", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            try {
                balFilesExist = CommandUtil.balFilesExists(packagePath);
                if (balFilesExist && !this.template.equals("default")) {
                    CommandUtil.printError(this.errStream, "existing .bal files found. Please use a different directory or remove existing files.", null, false);
                    CommandUtil.exitError(this.exitWhenFinish);
                    return;
                }
            }
            catch (IOException e) {
                CommandUtil.printError(this.errStream, "error occurred while looking for existing package files: " + e.getMessage(), null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            Path packageDirectory = packagePath;
            filesInDir = FileUtils.getFilesInDirectory((Path)packageDirectory);
        } else {
            Path parent = packagePath.getParent();
            if (parent == null) {
                CommandUtil.printError(this.errStream, "destination '" + String.valueOf(packagePath) + "' does not exist.", "bal new <project-path>", true);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            if (!Files.exists(parent, new LinkOption[0])) {
                CommandUtil.printError(this.errStream, "destination '" + String.valueOf(parent) + "' does not exist.", "bal new <project-path>", true);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
        }
        if (this.workspace) {
            Object tplPackageName = "hello";
            try {
                Files.createDirectories(packagePath, new FileAttribute[0]);
                if ("default".equals(this.template) || "main".equals(this.template)) {
                    tplPackageName = (String)tplPackageName + "-app";
                } else if ("service".equals(this.template)) {
                    tplPackageName = (String)tplPackageName + "-service";
                } else if ("lib".equals(this.template)) {
                    tplPackageName = (String)tplPackageName + "-lib";
                }
                Files.writeString(packagePath.resolve("Ballerina.toml"), (CharSequence)"[workspace]\n", new OpenOption[0]);
                this.errStream.println("Created new workspace at " + String.valueOf(packagePath) + ".");
                packagePath = packagePath.resolve((String)tplPackageName);
                packageName = ((String)tplPackageName).replace("_", "-");
            }
            catch (IOException e) {
                CommandUtil.printError(this.errStream, "error while creating the workspace directory '" + String.valueOf(packagePath) + "'", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
        } else {
            if (!ProjectUtils.validateNameLength((String)packageName)) {
                CommandUtil.printError(this.errStream, "invalid package name : '" + packageName + "' :\nMaximum length of package name is 256 characters.", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            if (!ProjectUtils.validatePackageName((String)packageName)) {
                packageName = ProjectUtils.guessPkgName((String)packageName, (String)this.template);
                this.errStream.println("Package name is derived as '" + packageName + "'. Edit the Ballerina.toml to change it.");
                this.errStream.println();
            }
        }
        Optional workspaceRoot = ProjectPaths.workspaceRoot((Path)Optional.of(packagePath.getParent()).get());
        try {
            if (CommandUtil.getTemplates().contains(this.template)) {
                String existingFiles;
                if (Files.exists(packagePath, new LinkOption[0]) && !(existingFiles = CommandUtil.checkTemplateFilesExists(this.template, packagePath)).isEmpty()) {
                    CommandUtil.printError(this.errStream, "existing " + existingFiles.substring(0, existingFiles.length() - 2) + " file/directory(s) were found. Please use a different directory or remove existing files.", null, false);
                    CommandUtil.exitError(this.exitWhenFinish);
                    return;
                }
                String orgName = workspaceRoot.isEmpty() ? ProjectUtils.guessOrgName() : this.getOrgName((Path)workspaceRoot.get());
                CommandUtil.initPackageByTemplate(packagePath, orgName, packageName, this.template, balFilesExist);
            } else {
                Path balaCache = this.homeCache.resolve("repositories").resolve("central.ballerina.io").resolve("bala");
                CommandUtil.initPackageFromCentral(balaCache, packagePath, packageName, this.template, filesInDir);
            }
        }
        catch (AccessDeniedException e) {
            CommandUtil.printError(this.errStream, "error occurred while creating project : Insufficient Permission : " + e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
        }
        catch (BLauncherException e) {
            if (Files.exists(packagePath, new LinkOption[0])) {
                try {
                    Files.delete(packagePath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            CommandUtil.printError(this.errStream, e.getDetailedMessages().get(0), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
        }
        catch (IOException | URISyntaxException e) {
            CommandUtil.printError(this.errStream, "error occurred while creating project : " + e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
        }
        if (Files.exists(packagePath, new LinkOption[0])) {
            if (!Path.of(this.argList.get(0), new String[0]).isAbsolute()) {
                packagePath = Path.of(this.argList.get(0), new String[0]);
            }
            this.errStream.println("Created new package '" + packageName + "' at " + String.valueOf(packagePath) + ".");
        }
        if (workspaceRoot.isPresent()) {
            Path wpBallerinaToml = ((Path)workspaceRoot.get()).resolve("Ballerina.toml");
            try {
                TomlDocument tomlDocument = TomlDocument.from((String)"Ballerina.toml", (String)Files.readString(wpBallerinaToml));
                String relativePackagePath = this.workspace ? ((Path)workspaceRoot.get()).relativize(((Path)workspaceRoot.get()).resolve(packageName)).toString() : (packagePath.isAbsolute() ? ((Path)workspaceRoot.get()).relativize(packagePath).toString() : ((Path)workspaceRoot.get()).relativize(packagePath.toAbsolutePath()).toString());
                this.replacePackagesInWpBalToml(tomlDocument.toml(), wpBallerinaToml, relativePackagePath);
            }
            catch (IOException e) {
                CommandUtil.printError(this.errStream, e.getMessage(), null, false);
                CommandUtil.exitError(this.exitWhenFinish);
            }
        }
    }

    @Override
    public String getName() {
        return "new";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("new"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("  bal new <project-path> \n");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private void replacePackagesInWpBalToml(Toml toml, Path balTomlPath, String packagePath) throws IOException {
        Object modifiedContent;
        TomlTableNode pkgNode;
        StringBuilder replacementStr = new StringBuilder();
        TomlTableNode tomlAstNode = toml.rootNode();
        TopLevelNode topLevelPkgNode = (TopLevelNode)tomlAstNode.entries().get("workspace");
        if (topLevelPkgNode == null || topLevelPkgNode.kind() != TomlType.TABLE) {
            replacementStr.append("[workspace]\n");
        }
        if ((pkgNode = (TomlTableNode)topLevelPkgNode) == null) {
            CommandUtil.printError(this.errStream, "error while parsing the 'workspace' table in " + String.valueOf(balTomlPath), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        List packages = TomlUtil.getStringArrayFromTableNode((TomlTableNode)pkgNode, (String)"packages");
        replacementStr.append("packages = [");
        for (String pkg : packages) {
            replacementStr.append("\"").append(pkg).append("\", ");
        }
        replacementStr.append("\"").append(packagePath).append("\"").append("]");
        String content = Files.readString(balTomlPath);
        Pattern pattern = Pattern.compile("packages\\s*=\\s*\\[\\s*(?:\"[^\"]*\"\\s*,\\s*)*\"[^\"]*\"\\s*]", 32);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            String existingStr = matcher.group();
            modifiedContent = content.replace(existingStr, replacementStr);
        } else {
            modifiedContent = content + String.valueOf(replacementStr);
        }
        Files.writeString(balTomlPath, (CharSequence)modifiedContent, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private String getOrgName(Path workspaceRoot) throws IOException {
        TomlTableNode pkgNode;
        List packages;
        TomlDocument tomlDocument = TomlDocument.from((String)"Ballerina.toml", (String)Files.readString(workspaceRoot.resolve("Ballerina.toml")));
        TomlTableNode tomlAstNode = tomlDocument.toml().rootNode();
        TopLevelNode topLevelPkgNode = (TopLevelNode)tomlAstNode.entries().get("workspace");
        if (topLevelPkgNode != null && topLevelPkgNode.kind() == TomlType.TABLE && !(packages = TomlUtil.getStringArrayFromTableNode((TomlTableNode)(pkgNode = (TomlTableNode)topLevelPkgNode), (String)"packages")).isEmpty()) {
            String packageName = (String)packages.get(0);
            Path pkgRoot = workspaceRoot.resolve(packageName);
            try {
                ProjectLoadResult projectLoadResult = ProjectLoader.load((Path)pkgRoot);
                PackageManifest manifest = projectLoadResult.project().currentPackage().manifest();
                return manifest.org().toString();
            }
            catch (ProjectException projectException) {
                // empty catch block
            }
        }
        return ProjectUtils.guessOrgName();
    }
}

