/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.utils.CentralUtils;
import io.ballerina.cli.utils.FileUtils;
import io.ballerina.projects.DependencyManifest;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.Settings;
import io.ballerina.projects.bala.BalaProject;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.internal.model.Proxy;
import io.ballerina.projects.internal.model.Repository;
import io.ballerina.projects.repos.TempDirCompilationCache;
import io.ballerina.projects.util.ProjectUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.exceptions.NoPackageException;
import org.ballerinalang.maven.bala.client.MavenResolverClient;
import org.ballerinalang.maven.bala.client.MavenResolverClientException;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="push", description={"Publish a package to Ballerina Central"})
public class PushCommand
implements BLauncherCmd {
    private static final String TOOL_DIR = "tool";
    private static final String BAL_TOOL_JSON = "bal-tool.json";
    private static final String TOOL_ID = "tool_id";
    private static final String ORG = "org";
    private static final String PACKAGE_NAME = "name";
    @CommandLine.Parameters(arity="0..1")
    private Path balaPath;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--debug"}, hidden=true)
    private String debugPort;
    @CommandLine.Option(names={"--repository"})
    private String repositoryName;
    @CommandLine.Option(names={"--skip-source-check"}, description={"skip checking if source has changed"})
    private boolean skipSourceCheck;
    private final Path userDir;
    private final PrintStream errStream;
    private final PrintStream outStream;
    private final boolean exitWhenFinish;

    public PushCommand() {
        this.userDir = Path.of(System.getProperty("user.dir"), new String[0]);
        this.errStream = System.err;
        this.outStream = System.out;
        this.exitWhenFinish = true;
    }

    public PushCommand(Path userDir, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish) {
        this.userDir = userDir;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
    }

    public PushCommand(Path userDir, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, Path balaPath) {
        this.userDir = userDir;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.balaPath = balaPath;
    }

    @Override
    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("push");
            this.outStream.println(commandUsageInfo);
            if (this.exitWhenFinish) {
                Runtime.getRuntime().exit(0);
            }
            return;
        }
        BuildProject project = null;
        try {
            if (this.balaPath == null) {
                project = BuildProject.load((Path)this.userDir);
            }
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.errStream, e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (null != this.debugPort) {
            System.setProperty("debug", this.debugPort);
        }
        System.setProperty("enableOutputStream", "true");
        try {
            Settings settings = RepoUtils.readSettings();
            if (this.repositoryName != null) {
                boolean isCustomRepository = false;
                Repository targetRepository = null;
                for (Repository repository : settings.getRepositories()) {
                    if (!this.repositoryName.equals(repository.id())) continue;
                    isCustomRepository = true;
                    targetRepository = repository;
                    break;
                }
                if (!this.repositoryName.equals("local") && !isCustomRepository) {
                    String errMsg = "unsupported repository '" + this.repositoryName + "' found. Only 'local' repository and repositories mentioned in the Settings.toml are supported.";
                    CommandUtil.printError(this.errStream, errMsg, null, false);
                    CommandUtil.exitError(this.exitWhenFinish);
                    return;
                }
                if (this.balaPath == null && this.repositoryName.equals("local")) {
                    this.pushPackage(project);
                    return;
                }
                if (this.repositoryName.equals("local")) {
                    if (!this.balaPath.toFile().exists()) {
                        throw new ProjectException("path provided for the bala file does not exist: " + String.valueOf(this.balaPath) + ".");
                    }
                    if (!FileUtils.getExtension(this.balaPath).equals("bala")) {
                        throw new ProjectException("file provided is not a bala file: " + String.valueOf(this.balaPath) + ".");
                    }
                    PushCommand.validateReadmeAndBalToml(this.balaPath);
                    this.pushBalaToCustomRepo(this.balaPath);
                    return;
                }
                MavenResolverClient mvnClient = new MavenResolverClient();
                if (!targetRepository.username().isEmpty() && !targetRepository.password().isEmpty()) {
                    mvnClient.addRepository(targetRepository.id(), targetRepository.url(), targetRepository.username(), targetRepository.password());
                } else {
                    mvnClient.addRepository(targetRepository.id(), targetRepository.url());
                }
                Proxy proxy = settings.getProxy();
                mvnClient.setProxy(proxy.host(), proxy.port(), proxy.username(), proxy.password());
                if (this.balaPath == null) {
                    this.pushPackage(project, mvnClient);
                } else {
                    if (!this.balaPath.toFile().exists()) {
                        throw new ProjectException("path provided for the bala file does not exist: " + String.valueOf(this.balaPath) + ".");
                    }
                    if (!FileUtils.getExtension(this.balaPath).equals("bala")) {
                        throw new ProjectException("file provided is not a bala file: " + String.valueOf(this.balaPath) + ".");
                    }
                    PushCommand.validateReadmeAndBalToml(this.balaPath);
                    this.pushBalaToCustomRepo(this.balaPath, mvnClient);
                }
            } else {
                if (settings.diagnostics().hasErrors()) {
                    CommandUtil.printError(this.errStream, settings.getErrorMessage(), null, false);
                    CommandUtil.exitError(this.exitWhenFinish);
                    return;
                }
                CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy((Proxy)settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI((Settings)settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
                if (this.balaPath == null) {
                    this.pushPackage(project, client);
                } else {
                    if (!this.balaPath.toFile().exists()) {
                        throw new ProjectException("path provided for the bala file does not exist: " + String.valueOf(this.balaPath) + ".");
                    }
                    if (!FileUtils.getExtension(this.balaPath).equals("bala")) {
                        throw new ProjectException("file provided is not a bala file: " + String.valueOf(this.balaPath) + ".");
                    }
                    PushCommand.validateReadmeAndBalToml(this.balaPath);
                    this.pushBalaToRemote(this.balaPath, client);
                }
            }
        }
        catch (ProjectException | CentralClientException e) {
            CommandUtil.printError(this.errStream, e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    @Override
    public String getName() {
        return "push";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("push"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("  bal push \n");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private void pushPackage(BuildProject project) {
        Path balaFilePath = PushCommand.validateBalaFile(project, this.balaPath);
        this.pushBalaToCustomRepo(balaFilePath);
    }

    private void pushPackage(BuildProject project, MavenResolverClient client) {
        Path balaFilePath = PushCommand.validateBalaFile(project, this.balaPath);
        this.pushBalaToCustomRepo(balaFilePath, client);
    }

    private void pushPackage(BuildProject project, CentralAPIClient client) throws CentralClientException {
        Path balaFilePath = PushCommand.validateBala(project, client, this.balaPath);
        this.pushBalaToRemote(balaFilePath, client);
    }

    private static Path validateBala(BuildProject project, CentralAPIClient client, Path customBalaPath) throws CentralClientException {
        Path packageBalaFile = PushCommand.validateBalaFile(project, customBalaPath);
        DependencyManifest.Package pkgAsDependency = new DependencyManifest.Package(project.currentPackage().packageName(), project.currentPackage().packageOrg(), project.currentPackage().packageVersion());
        if (PushCommand.isPackageAvailableInRemote(pkgAsDependency, client)) {
            String pkg = pkgAsDependency.org().toString() + "/" + pkgAsDependency.name().toString() + ":" + pkgAsDependency.version().toString();
            throw new ProjectException("package '" + pkg + "' already exists in remote repository :" + CentralUtils.getCentralPackageURL(project.currentPackage().packageOrg().value(), project.currentPackage().packageName().value()) + ". build and push after updating the version in the Ballerina.toml.");
        }
        return packageBalaFile;
    }

    private static Path validateBalaFile(BuildProject project, Path customBalaPath) {
        PackageName pkgName = project.currentPackage().packageName();
        PackageOrg orgName = project.currentPackage().packageOrg();
        PackageVersion packageVersion = project.currentPackage().packageVersion();
        Path packageBalaFile = customBalaPath;
        if (packageBalaFile == null) {
            Path balaOutputDir = project.currentPackage().project().targetDir().resolve("bala");
            if (Files.notExists(balaOutputDir, new LinkOption[0])) {
                throw new ProjectException("cannot find bala file for the package: " + String.valueOf(pkgName) + ". Run 'bal pack' to compile and generate the bala.");
            }
            packageBalaFile = PushCommand.findBalaFile(pkgName, orgName, balaOutputDir);
        }
        if (null == packageBalaFile) {
            throw new ProjectException("cannot find bala file for the package: " + String.valueOf(pkgName) + ". Run 'bal pack' to compile and generate the bala.");
        }
        if (!packageBalaFile.toString().endsWith(packageVersion.toString() + ".bala")) {
            throw new ProjectException("'" + String.valueOf(packageBalaFile) + "' does not match with the package version '" + packageVersion.toString() + "' in Ballerina.toml file. Run 'bal pack' to recompile and generate the bala.");
        }
        PushCommand.validateReadmeAndBalToml(packageBalaFile);
        return packageBalaFile;
    }

    private static void validateReadmeAndBalToml(Path balaPath) {
        ProjectEnvironmentBuilder defaultBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
        defaultBuilder.addCompilationCacheFactory(TempDirCompilationCache::from);
        BalaProject balaProject = BalaProject.loadProject((ProjectEnvironmentBuilder)defaultBuilder, (Path)balaPath);
        try (ZipInputStream zip = new ZipInputStream(Files.newInputStream(balaPath, StandardOpenOption.READ));){
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                String readme = balaProject.currentPackage().manifest().readme() == null ? "docs/Package.md" : balaProject.currentPackage().manifest().readme();
                if (!entry.getName().equals(readme)) continue;
                if (entry.getSize() == 0L) {
                    throw new ProjectException("README file cannot be empty.");
                }
                return;
            }
        }
        catch (IOException e) {
            throw new ProjectException("error while validating the bala file: " + e.getMessage(), (Throwable)e);
        }
        throw new ProjectException("README.md file is missing in the bala file:" + String.valueOf(balaPath));
    }

    private void pushBalaToCustomRepo(Path balaFilePath) {
        ProjectEnvironmentBuilder defaultBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
        defaultBuilder.addCompilationCacheFactory(TempDirCompilationCache::from);
        BalaProject balaProject = BalaProject.loadProject((ProjectEnvironmentBuilder)defaultBuilder, (Path)balaFilePath);
        Path repoPath = RepoUtils.createAndGetHomeReposPath().resolve("repositories").resolve("local");
        String org = balaProject.currentPackage().packageOrg().value();
        String packageName = balaProject.currentPackage().packageName().value();
        String version = balaProject.currentPackage().packageVersion().toString();
        String platform = balaProject.platform();
        String ballerinaShortVersion = RepoUtils.getBallerinaShortVersion();
        Path balaDestPath = repoPath.resolve("bala").resolve(org).resolve(packageName).resolve(version).resolve(platform);
        Path balaVersionPath = repoPath.resolve("bala").resolve(org).resolve(packageName).resolve(version);
        Path balaCachesPath = repoPath.resolve("cache-" + ballerinaShortVersion).resolve(org).resolve(packageName).resolve(version);
        try {
            if (Files.exists(balaVersionPath, new LinkOption[0])) {
                ProjectUtils.deleteDirectory((Path)balaVersionPath);
            }
            if (Files.exists(balaCachesPath, new LinkOption[0])) {
                ProjectUtils.deleteDirectory((Path)balaCachesPath);
            }
            ProjectUtils.extractBala((Path)balaFilePath, (Path)balaDestPath);
            this.createLocalToolsJsonIfLocalTool(balaDestPath, org, packageName, repoPath.resolve("bala"));
        }
        catch (IOException e) {
            throw new ProjectException("error while pushing bala file '" + String.valueOf(balaFilePath) + "' to 'local' repository: " + e.getMessage());
        }
        Path relativePathToBalaFile = this.balaPath != null ? balaFilePath : this.userDir.toAbsolutePath().relativize(balaFilePath);
        this.outStream.println("Successfully pushed " + String.valueOf(relativePathToBalaFile) + " to '" + this.repositoryName + "' repository.");
    }

    private void createLocalToolsJsonIfLocalTool(Path balaDestPath, String org, String packageName, Path localRepoBalaPath) {
        JsonObject localToolJson;
        Path localToolJsonPath;
        Gson gson;
        block28: {
            JsonObject balToolJson;
            Path balToolJsonPath = balaDestPath.resolve(TOOL_DIR).resolve(BAL_TOOL_JSON);
            gson = new Gson();
            if (!balToolJsonPath.toFile().exists()) {
                return;
            }
            try (BufferedReader bufferedReader = Files.newBufferedReader(balToolJsonPath, StandardCharsets.UTF_8);){
                balToolJson = (JsonObject)gson.fromJson((Reader)bufferedReader, JsonObject.class);
            }
            catch (IOException e) {
                throw new ProjectException("Failed to read bal-tools.json file: " + e.getMessage());
            }
            Optional<String> optionalToolId = Optional.ofNullable(balToolJson.get(TOOL_ID).getAsString());
            if (optionalToolId.isEmpty()) {
                return;
            }
            String toolId = optionalToolId.get();
            JsonObject packageDesc = new JsonObject();
            packageDesc.addProperty(ORG, org);
            packageDesc.addProperty(PACKAGE_NAME, packageName);
            localToolJsonPath = localRepoBalaPath.resolve("local-tools.json");
            if (localToolJsonPath.toFile().exists()) {
                try (BufferedReader bufferedReader = Files.newBufferedReader(localToolJsonPath, StandardCharsets.UTF_8);){
                    localToolJson = (JsonObject)gson.fromJson((Reader)bufferedReader, JsonObject.class);
                    if (localToolJson.has(toolId)) {
                        localToolJson.remove(toolId);
                    }
                    localToolJson.add(toolId, (JsonElement)packageDesc);
                    break block28;
                }
                catch (IOException e) {
                    throw new ProjectException("Failed to read local-tools.json file: " + e.getMessage());
                }
            }
            localToolJson = new JsonObject();
            localToolJson.add(toolId, (JsonElement)packageDesc);
        }
        try (FileWriter writer = new FileWriter(localToolJsonPath.toFile(), StandardCharsets.UTF_8);){
            writer.write(gson.toJson((JsonElement)localToolJson));
        }
        catch (IOException e) {
            throw new ProjectException("Failed to write local-tools.json file: " + e.getMessage());
        }
    }

    private void pushBalaToRemote(Path balaPath, CentralAPIClient client) {
        block5: {
            Path balaFileName = balaPath.getFileName();
            if (null != balaFileName) {
                ProjectEnvironmentBuilder defaultBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
                defaultBuilder.addCompilationCacheFactory(TempDirCompilationCache::from);
                BalaProject balaProject = BalaProject.loadProject((ProjectEnvironmentBuilder)defaultBuilder, (Path)balaPath);
                String org = balaProject.currentPackage().manifest().org().toString();
                String name = balaProject.currentPackage().manifest().name().toString();
                String version = balaProject.currentPackage().manifest().version().toString();
                Path ballerinaHomePath = RepoUtils.createAndGetHomeReposPath();
                Path settingsTomlFilePath = ballerinaHomePath.resolve("Settings.toml");
                CentralUtils.authenticate(this.errStream, CentralUtils.getBallerinaCentralCliTokenUrl(), settingsTomlFilePath, client);
                try {
                    client.pushPackage(balaPath, org, name, version, JvmTarget.JAVA_21.code(), RepoUtils.getBallerinaVersion());
                }
                catch (CentralClientException e) {
                    String errorMessage = e.getMessage();
                    if (null == errorMessage || errorMessage.trim().isEmpty()) break block5;
                    if (errorMessage.contains("\n\tat")) {
                        errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n\tat"));
                    }
                    if ((errorMessage = errorMessage.replace("error: ", "")).contains("subject claims missing in the user info repsonse")) {
                        errorMessage = "invalid access token in the 'Settings.toml'";
                    }
                    throw new ProjectException(errorMessage);
                }
            }
        }
    }

    private void pushBalaToCustomRepo(Path balaPath, MavenResolverClient client) {
        Path balaFileName = balaPath.getFileName();
        if (null != balaFileName) {
            ProjectEnvironmentBuilder defaultBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
            defaultBuilder.addCompilationCacheFactory(TempDirCompilationCache::from);
            BalaProject balaProject = BalaProject.loadProject((ProjectEnvironmentBuilder)defaultBuilder, (Path)balaPath);
            String org = balaProject.currentPackage().manifest().org().toString();
            String name = balaProject.currentPackage().manifest().name().toString();
            String version = balaProject.currentPackage().manifest().version().toString();
            try {
                Path customRepoPath = Files.createTempDirectory("ballerina-" + System.nanoTime(), new FileAttribute[0]);
                client.pushPackage(balaPath, org, name, version, customRepoPath);
            }
            catch (IOException | MavenResolverClientException e) {
                throw new ProjectException(e.getMessage());
            }
            Path relativePathToBalaFile = this.balaPath != null ? balaPath : this.userDir.relativize(balaPath);
            this.outStream.println("Successfully pushed " + String.valueOf(relativePathToBalaFile) + " to '" + this.repositoryName + "' repository.");
        }
    }

    private static boolean isPackageAvailableInRemote(DependencyManifest.Package pkg, CentralAPIClient client) throws CentralClientException {
        String supportedPlatform = Arrays.stream(JvmTarget.values()).map(target -> target.code()).collect(Collectors.joining(","));
        try {
            client.getPackage(pkg.org().toString(), pkg.name().toString(), pkg.version().toString(), supportedPlatform, RepoUtils.getBallerinaVersion());
            return true;
        }
        catch (NoPackageException e) {
            return false;
        }
    }

    private static Path findBalaFile(PackageName pkgName, PackageOrg orgName, Path balaOutputDir) {
        Path balaFilePath = null;
        File[] balaFiles = new File(balaOutputDir.toString()).listFiles();
        if (balaFiles != null && balaFiles.length > 0) {
            for (File balaFile : balaFiles) {
                if (balaFile == null || !balaFile.getName().startsWith(String.valueOf(orgName) + "-" + String.valueOf(pkgName))) continue;
                balaFilePath = balaFile.toPath();
                break;
            }
        }
        return balaFilePath;
    }
}

