/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.TaskExecutor;
import io.ballerina.cli.cmd.CacheArtifactsTask;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.cmd.PackageLockingModeConverter;
import io.ballerina.cli.cmd.RestoreCachedArtifactsTask;
import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.task.CleanTargetDirTask;
import io.ballerina.cli.task.CompileTask;
import io.ballerina.cli.task.CreateExecutableTask;
import io.ballerina.cli.task.CreateFingerprintTask;
import io.ballerina.cli.task.DumpBuildTimeTask;
import io.ballerina.cli.task.ResolveMavenDependenciesTask;
import io.ballerina.cli.task.RunBuildToolsTask;
import io.ballerina.cli.task.RunExecutableTask;
import io.ballerina.cli.utils.BuildTime;
import io.ballerina.cli.utils.ProjectWatcher;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.ProjectLoadResult;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.projects.directory.WorkspaceProject;
import io.ballerina.projects.environment.PackageLockingMode;
import io.ballerina.projects.internal.model.BuildJson;
import io.ballerina.projects.internal.model.Target;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Compile and run the current package"})
public class RunCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private Path projectPath;
    private boolean exitWhenFinish;
    RunExecutableTask runExecutableTask;
    Project project;
    private static final PathMatcher JAR_EXTENSION_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.jar");
    @CommandLine.Parameters(description={"Program arguments"})
    private final List<String> argList = new ArrayList<String>();
    @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--offline"}, description={"Builds offline without downloading dependencies and then run."})
    private Boolean offline;
    @CommandLine.Option(names={"--debug"}, hidden=true)
    private String debugPort;
    @CommandLine.Option(names={"--watch"}, description={"watch for file changes and automatically re-run the project"})
    private boolean watch;
    private boolean initialWatch;
    @CommandLine.Option(names={"--dump-bir"}, hidden=true)
    private boolean dumpBIR;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental language features."})
    private boolean experimentalFlag;
    @CommandLine.Option(names={"--observability-included"}, description={"package observability in the executable when run is used with a source file or a module."})
    private Boolean observabilityIncluded;
    @CommandLine.Option(names={"--remote-management"}, description={"enable management service in the executable when run is used with a source file or a module."})
    private Boolean remoteManagement;
    @CommandLine.Option(names={"--sticky"}, description={"stick to exact versions locked (if exists)"})
    private Boolean sticky;
    @CommandLine.Option(names={"--dump-graph"}, description={"Print the dependency graph."}, hidden=true)
    private boolean dumpGraph;
    @CommandLine.Option(names={"--dump-raw-graphs"}, description={"Print all intermediate graphs created in the dependency resolution process."}, hidden=true)
    private boolean dumpRawGraphs;
    @CommandLine.Option(names={"--generate-config-schema"}, hidden=true)
    private Boolean configSchemaGen;
    @CommandLine.Option(names={"--target-dir"}, description={"target directory path"})
    private Path targetDir;
    @CommandLine.Option(names={"--disable-syntax-tree-caching"}, hidden=true, description={"disable syntax tree caching for source files"}, defaultValue="false")
    private Boolean disableSyntaxTreeCaching;
    @CommandLine.Option(names={"--dump-build-time"}, description={"calculate and dump build time"}, hidden=true)
    private Boolean dumpBuildTime;
    @CommandLine.Option(names={"--show-dependency-diagnostics"}, description={"Show the diagnostics generated by the dependencies"})
    private Boolean showDependencyDiagnostics;
    @CommandLine.Option(names={"--optimize-dependency-compilation"}, hidden=true, description={"experimental memory optimization for large projects"})
    private Boolean optimizeDependencyCompilation;
    @CommandLine.Option(names={"--locking-mode"}, hidden=true, description={"allow passing the package locking mode."}, converter={PackageLockingModeConverter.class})
    private PackageLockingMode lockingMode;
    private static final String runCmd = "bal run [--debug <port>] <executable-jar> \n    bal run [--experimental] [--offline]\n                  [<ballerina-file | package-path>] [-- program-args...]\n ";

    public RunCommand() {
        this.projectPath = Path.of(System.getProperty("user.dir"), new String[0]);
        this.outStream = System.err;
        this.errStream = System.err;
    }

    RunCommand(Path projectPath, PrintStream outStream, boolean exitWhenFinish) {
        this.projectPath = projectPath;
        this.exitWhenFinish = exitWhenFinish;
        this.outStream = outStream;
        this.errStream = outStream;
        this.offline = true;
    }

    RunCommand(Path projectPath, PrintStream outStream, boolean exitWhenFinish, Boolean optimizeDependencyCompilation) {
        this.projectPath = projectPath;
        this.exitWhenFinish = exitWhenFinish;
        this.outStream = outStream;
        this.errStream = outStream;
        this.optimizeDependencyCompilation = optimizeDependencyCompilation;
        this.offline = true;
    }

    RunCommand(Path projectPath, PrintStream outStream, boolean exitWhenFinish, Path targetDir) {
        this.projectPath = projectPath;
        this.exitWhenFinish = exitWhenFinish;
        this.outStream = outStream;
        this.errStream = outStream;
        this.targetDir = targetDir;
        this.offline = true;
    }

    @Override
    public void execute() {
        DiagnosticResult diagnosticResult;
        long start = 0L;
        int exitCode = 0;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("run");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (this.debugPort != null) {
            System.setProperty("debug", this.debugPort);
        }
        String[] args = new String[]{};
        if (!this.argList.isEmpty()) {
            if (!this.argList.get(0).equals("--")) {
                this.projectPath = Path.of(this.argList.get(0), new String[0]);
                if (JAR_EXTENSION_MATCHER.matches(this.projectPath)) {
                    CommandUtil.printError(this.errStream, "unsupported option(s) provided for jar execution", runCmd, true);
                    CommandUtil.exitError(this.exitWhenFinish);
                    return;
                }
                if (this.argList.size() > 1 && !this.argList.get(1).equals("--")) {
                    CommandUtil.printError(this.errStream, "unmatched command argument found: " + this.argList.get(1), runCmd, false);
                    CommandUtil.exitError(this.exitWhenFinish);
                    return;
                }
                if (this.argList.size() > 2 && this.argList.get(1).equals("--")) {
                    args = this.argList.subList(2, this.argList.size()).toArray(new String[0]);
                }
            } else if (this.argList.size() > 1 && this.argList.get(0).equals("--")) {
                args = this.argList.subList(1, this.argList.size()).toArray(new String[0]);
            }
        }
        if (this.watch) {
            try {
                ProjectWatcher projectWatcher = new ProjectWatcher(this, Path.of(this.projectPath.toString(), new String[0]), this.outStream);
                projectWatcher.watch();
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("unable to watch the project:" + e.getMessage());
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, e.getMessage(), runCmd, false);
                CommandUtil.exitError(this.exitWhenFinish);
            }
            return;
        }
        BuildOptions buildOptions = this.constructBuildOptions();
        Path absProjectPath = this.projectPath.toAbsolutePath().normalize();
        try {
            ProjectLoadResult loadResult;
            if (buildOptions.dumpBuildTime()) {
                BuildTime.getInstance().timestamp = start = System.currentTimeMillis();
            }
            if ((diagnosticResult = (loadResult = ProjectLoader.load((Path)this.projectPath, (BuildOptions)buildOptions)).diagnostics()).hasErrors()) {
                exitCode = 1;
            }
            this.project = loadResult.project();
            if (buildOptions.dumpBuildTime()) {
                BuildTime.getInstance().projectLoadDuration = System.currentTimeMillis() - start;
            }
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.errStream, e.getMessage(), runCmd, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        try {
            if (this.project.kind().equals((Object)ProjectKind.SINGLE_FILE_PROJECT)) {
                Target target = new Target(Files.createTempDirectory("ballerina-cache" + System.nanoTime(), new FileAttribute[0]));
                target.setOutputPath(target.getBinPath());
            }
            if (this.project.kind() == ProjectKind.WORKSPACE_PROJECT) {
                diagnosticResult.diagnostics().forEach(diagnostic -> this.errStream.println(diagnostic.toString()));
                WorkspaceProject workspaceProject = (WorkspaceProject)this.project;
                DependencyGraph<BuildProject> projectDependencyGraph = CommandUtil.resolveWorkspaceDependencies(workspaceProject, this.outStream);
                ArrayList<BuildProject> topologicallySortedList = new ArrayList<BuildProject>(projectDependencyGraph.toTopologicallySortedList());
                Optional<BuildProject> buildProjectOptional = projectDependencyGraph.getNodes().stream().filter(node -> node.sourceRoot().equals(absProjectPath)).findFirst();
                if (buildProjectOptional.isEmpty()) {
                    throw LauncherUtils.createLauncherException("no package found at the specified path: " + String.valueOf(absProjectPath));
                }
                Path relativePath = Paths.get(System.getProperty("user.dir"), new String[0]).relativize(buildProjectOptional.get().sourceRoot());
                if (this.project.sourceRoot().equals(absProjectPath)) {
                    CommandUtil.printError(this.errStream, "'bal run' command is not supported for workspaces. Please specify a package to run. \nExample:\n\tbal run " + String.valueOf(relativePath), runCmd, false);
                    CommandUtil.exitError(this.exitWhenFinish);
                    return;
                }
                Collection projectDependencies = projectDependencyGraph.getAllDependencies((Object)buildProjectOptional.orElseThrow());
                topologicallySortedList.removeIf(prj -> !projectDependencies.contains(prj) && prj != buildProjectOptional.get());
                HashMap<BuildProject, Boolean> rebuildCache = new HashMap<BuildProject, Boolean>();
                for (BuildProject buildProject : topologicallySortedList) {
                    boolean skipExecution = buildProject != buildProjectOptional.get();
                    boolean isRebuildNeeded = this.isRebuildNeeded((Project)buildProject, skipExecution);
                    rebuildCache.put(buildProject, isRebuildNeeded);
                    if (!isRebuildNeeded) {
                        for (BuildProject dependency : projectDependencyGraph.getDirectDependencies((Object)buildProject)) {
                            isRebuildNeeded = (Boolean)rebuildCache.get(dependency);
                            if (!isRebuildNeeded) continue;
                            rebuildCache.put(buildProject, true);
                            break;
                        }
                    }
                    this.executeTasks(args, (Project)buildProject, skipExecution, isRebuildNeeded);
                }
            } else {
                this.executeTasks(args, this.project, false, this.isRebuildNeeded(this.project, false));
            }
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException("unable to resolve the target path:" + e.getMessage());
        }
        catch (ProjectException e) {
            throw LauncherUtils.createLauncherException("unable to create the executable:" + e.getMessage());
        }
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(exitCode);
        }
    }

    private void executeTasks(String[] args, Project project, boolean skipExecution, boolean rebuildNeeded) throws IOException {
        boolean isSingleFile = project.kind().equals((Object)ProjectKind.SINGLE_FILE_PROJECT);
        Target target = new Target(project.targetDir());
        ArrayList<Diagnostic> buildToolDiagnostics = new ArrayList<Diagnostic>();
        this.runExecutableTask = new RunExecutableTask(args, this.outStream, this.errStream, target);
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CleanTargetDirTask(), isSingleFile || !rebuildNeeded).addTask(new RestoreCachedArtifactsTask(), rebuildNeeded).addTask(new RunBuildToolsTask(this.outStream, !rebuildNeeded, buildToolDiagnostics), isSingleFile).addTask(new ResolveMavenDependenciesTask(this.outStream, !rebuildNeeded)).addTask(new CompileTask(this.outStream, this.errStream, false, false, !rebuildNeeded, buildToolDiagnostics)).addTask(new CreateExecutableTask(this.outStream, null, target, true, !rebuildNeeded), skipExecution).addTask(new CacheArtifactsTask("run"), !rebuildNeeded || isSingleFile).addTask(new CreateFingerprintTask(false, skipExecution), !rebuildNeeded || isSingleFile).addTask(this.runExecutableTask, skipExecution).addTask(new DumpBuildTimeTask(this.outStream), !project.buildOptions().dumpBuildTime()).build();
        taskExecutor.executeTasks(project);
    }

    private boolean isRebuildNeeded(Project project, boolean skipExecutable) {
        Path buildFilePath = project.targetDir().resolve("build");
        try {
            BuildJson buildJson = ProjectUtils.readBuildJson((Path)buildFilePath);
            if (!Objects.equals(buildJson.distributionVersion(), RepoUtils.getBallerinaVersion())) {
                return true;
            }
            if (buildJson.isExpiredLastUpdateTime()) {
                return true;
            }
            if (CommandUtil.isFilesModifiedSinceLastBuild(buildJson, project, false, skipExecutable)) {
                return true;
            }
            if (this.isRebuildForCurrCmd()) {
                return true;
            }
            return CommandUtil.isPrevCurrCmdCompatible(project.buildOptions(), buildJson.getBuildOptions());
        }
        catch (IOException iOException) {
            return true;
        }
    }

    private boolean isRebuildForCurrCmd() {
        return this.debugPort != null || this.initialWatch || this.dumpBIR || this.dumpGraph || this.dumpRawGraphs || Boolean.TRUE.equals(this.configSchemaGen) || this.targetDir != null || Boolean.TRUE.equals(this.disableSyntaxTreeCaching) || Boolean.TRUE.equals(this.dumpBuildTime) || Boolean.TRUE.equals(this.showDependencyDiagnostics);
    }

    @Override
    public String getName() {
        return "run";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("run"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("  bal run [--debug <port>] <executable-jar>\n");
        out.append("  bal run [--offline] [<balfile> | <project-path>]\n[--] [args...] \n");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    public void unsetWatch() {
        this.watch = false;
    }

    public void setInitialWatch() {
        this.initialWatch = true;
    }

    public void killProcess() {
        if (this.runExecutableTask != null) {
            this.runExecutableTask.killProcess();
        }
    }

    private BuildOptions constructBuildOptions() {
        BuildOptions.BuildOptionsBuilder buildOptionsBuilder = BuildOptions.builder();
        buildOptionsBuilder.setCodeCoverage(Boolean.valueOf(false)).setExperimental(Boolean.valueOf(this.experimentalFlag)).setOffline(this.offline).setSkipTests(Boolean.valueOf(true)).setTestReport(Boolean.valueOf(false)).setObservabilityIncluded(this.observabilityIncluded).setCloud("").setRemoteManagement(this.remoteManagement).setSticky(this.sticky).setDumpGraph(Boolean.valueOf(this.dumpGraph)).setDumpRawGraphs(Boolean.valueOf(this.dumpRawGraphs)).setConfigSchemaGen(this.configSchemaGen).disableSyntaxTreeCaching(this.disableSyntaxTreeCaching).setDumpBuildTime(this.dumpBuildTime).setShowDependencyDiagnostics(this.showDependencyDiagnostics).setOptimizeDependencyCompilation(this.optimizeDependencyCompilation).setLockingMode(this.lockingMode);
        if (this.targetDir != null) {
            buildOptionsBuilder.targetDir(this.targetDir.toString());
        }
        return buildOptionsBuilder.build();
    }

    public boolean containsService() {
        return this.project == null || ProjectUtils.containsDefaultModuleService((Package)this.project.currentPackage());
    }
}

