/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import com.google.gson.Gson;
import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.TaskExecutor;
import io.ballerina.cli.cmd.CacheArtifactsTask;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.cmd.PackageLockingModeConverter;
import io.ballerina.cli.cmd.RestoreCachedArtifactsTask;
import io.ballerina.cli.launcher.BLauncherException;
import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.task.CleanTargetBinTestsDirTask;
import io.ballerina.cli.task.CleanTargetCacheDirTask;
import io.ballerina.cli.task.CompileTask;
import io.ballerina.cli.task.CreateFingerprintTask;
import io.ballerina.cli.task.CreateTestExecutableTask;
import io.ballerina.cli.task.DumpBuildTimeTask;
import io.ballerina.cli.task.ResolveMavenDependenciesTask;
import io.ballerina.cli.task.RunBuildToolsTask;
import io.ballerina.cli.task.RunNativeImageTestTask;
import io.ballerina.cli.task.RunTestsTask;
import io.ballerina.cli.utils.BuildTime;
import io.ballerina.cli.utils.FileUtils;
import io.ballerina.cli.utils.TestUtils;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.Module;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.ProjectLoadResult;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.projects.directory.WorkspaceProject;
import io.ballerina.projects.environment.PackageLockingMode;
import io.ballerina.projects.internal.model.BuildJson;
import io.ballerina.projects.internal.model.Target;
import io.ballerina.projects.util.ProjectPaths;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.ballerinalang.test.runtime.entity.TestReport;
import org.ballerinalang.test.runtime.util.CodeCoverageUtils;
import picocli.CommandLine;

@CommandLine.Command(name="test", description={"Run package tests"})
public class TestCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private Path projectPath;
    private final boolean exitWhenFinish;
    @CommandLine.Option(names={"--offline"}, description={"Run package tests"})
    private Boolean offline;
    @CommandLine.Parameters(description={"Program arguments"})
    private List<String> argList = new ArrayList<String>();
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental language features."})
    private Boolean experimentalFlag;
    @CommandLine.Option(names={"--debug"}, description={"start in remote debugging mode"})
    private String debugPort;
    @CommandLine.Option(names={"--parallel"}, description={"enable parallel execution of tests"}, defaultValue="false")
    private boolean isParallelExecution;
    @CommandLine.Option(names={"--list-groups"}, description={"list the groups available in the tests"})
    private boolean listGroups;
    @CommandLine.Option(names={"--groups"}, description={"test groups to be executed"})
    private String groupList;
    @CommandLine.Option(names={"--disable-groups"}, description={"test groups to be disabled"})
    private String disableGroupList;
    @CommandLine.Option(names={"--test-report"}, description={"enable test report generation"})
    private Boolean testReport;
    @CommandLine.Option(names={"--code-coverage"}, description={"enable code coverage"})
    private Boolean coverage;
    @CommandLine.Option(names={"--coverage-format"}, description={"list of supported coverage report formats"})
    private String coverageFormat;
    @CommandLine.Option(names={"--observability-included"}, description={"package observability in the executable."})
    private Boolean observabilityIncluded;
    @CommandLine.Option(names={"--tests"}, description={"Test functions to be executed"})
    private String testList;
    @CommandLine.Option(names={"--rerun-failed"}, description={"Rerun failed tests."})
    private boolean rerunTests;
    @CommandLine.Option(names={"--includes"}, hidden=true, description={"hidden option for code coverage to include all classes"})
    private String includes;
    @CommandLine.Option(names={"--dump-build-time"}, description={"calculate and dump build time"}, hidden=true)
    private Boolean dumpBuildTime;
    @CommandLine.Option(names={"--sticky"}, description={"stick to exact versions locked (if exists)"})
    private Boolean sticky;
    @CommandLine.Option(names={"--target-dir"}, description={"target directory path"})
    private Path targetDir;
    @CommandLine.Option(names={"--dump-graph"}, description={"Print the dependency graph."}, hidden=true)
    private boolean dumpGraph;
    @CommandLine.Option(names={"--dump-raw-graphs"}, description={"Print all intermediate graphs created in the dependency resolution process."}, hidden=true)
    private boolean dumpRawGraphs;
    @CommandLine.Option(names={"--graalvm"}, description={"enable running test suite against native image"})
    private Boolean nativeImage;
    @CommandLine.Option(names={"--excludes"}, description={"option to exclude source files/folders from code coverage"})
    private String excludes;
    @CommandLine.Option(names={"--disable-syntax-tree-caching"}, hidden=true, description={"disable syntax tree caching for source files"}, defaultValue="false")
    private Boolean disableSyntaxTreeCaching;
    @CommandLine.Option(names={"--graalvm-build-options"}, description={"additional build options for native image generation"})
    private String graalVMBuildOptions;
    @CommandLine.Option(names={"--show-dependency-diagnostics"}, description={"Show the diagnostics generated by the dependencies"})
    private Boolean showDependencyDiagnostics;
    @CommandLine.Option(names={"--cloud"}, description={"Enable cloud artifact generation"})
    private String cloud;
    @CommandLine.Option(names={"--optimize-dependency-compilation"}, hidden=true, description={"experimental memory optimization for large projects"})
    private Boolean optimizeDependencyCompilation;
    @CommandLine.Option(names={"--locking-mode"}, hidden=true, description={"allow passing the package locking mode."}, converter={PackageLockingModeConverter.class})
    private PackageLockingMode lockingMode;
    @CommandLine.Option(names={"--min-coverage"}, description={"minimum code coverage percentage to pass the test"})
    private Float minCoverage;
    private static final String testCmd = "bal test [--OPTIONS]\n                   [<ballerina-file> | <package-path>] [(-Ckey=value)...]";

    public TestCommand() {
        this.projectPath = Path.of(System.getProperty("user.dir"), new String[0]);
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = true;
    }

    TestCommand(Path projectPath, boolean exitWhenFinish) {
        this.projectPath = projectPath;
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = exitWhenFinish;
        this.offline = true;
    }

    TestCommand(Path projectPath, boolean exitWhenFinish, Boolean optimizeDependencyCompilation) {
        this.projectPath = projectPath;
        this.optimizeDependencyCompilation = optimizeDependencyCompilation;
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = exitWhenFinish;
        this.offline = true;
    }

    TestCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.offline = true;
    }

    TestCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, Boolean testReport, Boolean coverage, String coverageFormat, Boolean optimizeDependencyCompilation) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.testReport = testReport;
        this.coverage = coverage;
        this.coverageFormat = coverageFormat;
        this.optimizeDependencyCompilation = optimizeDependencyCompilation;
        this.offline = true;
    }

    TestCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, Boolean testReport, Path targetDir) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.testReport = testReport;
        this.targetDir = targetDir;
        this.offline = true;
    }

    TestCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, boolean nativeImage, String graalVMBuildOptions) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.nativeImage = nativeImage;
        this.offline = true;
        this.graalVMBuildOptions = graalVMBuildOptions;
    }

    @Override
    public void execute() {
        Project project;
        DiagnosticResult diagnosticResult;
        long start = 0L;
        int exitCode = 0;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("test");
            this.errStream.println(commandUsageInfo);
            return;
        }
        String[] cliArgs = new String[]{};
        if (!this.argList.isEmpty()) {
            if (!this.argList.get(0).matches("-C[\\w\\W]+=([\\w\\W]+)")) {
                this.projectPath = Path.of(this.argList.get(0), new String[0]);
                if (this.argList.size() > 1) {
                    cliArgs = this.argList.subList(1, this.argList.size()).toArray(new String[0]);
                }
            } else {
                cliArgs = this.argList.toArray(new String[0]);
            }
        }
        if (this.isParallelExecution) {
            this.outStream.println("WARNING: Running tests in parallel is an experimental feature");
        }
        if (FileUtils.hasExtension(this.projectPath)) {
            if (this.coverage != null && this.coverage.booleanValue()) {
                this.outStream.println("Code coverage is not yet supported with single bal files. Ignoring the flag and continuing the test run...");
            }
            this.coverage = false;
            this.testReport = false;
        }
        BuildOptions buildOptions = this.constructBuildOptions();
        Path absProjectPath = this.projectPath.toAbsolutePath().normalize();
        try {
            if (buildOptions.dumpBuildTime()) {
                BuildTime.getInstance().timestamp = start = System.currentTimeMillis();
            }
            if (!(ProjectPaths.isBuildProjectRoot((Path)this.projectPath) || ProjectPaths.isStandaloneBalFile((Path)this.projectPath) || ProjectPaths.isWorkspaceProjectRoot((Path)this.projectPath))) {
                throw new ProjectException("invalid package path: " + String.valueOf(absProjectPath) + ". Please provide a valid Ballerina package, workspace or a standalone file.");
            }
            ProjectLoadResult loadResult = ProjectLoader.load((Path)this.projectPath, (BuildOptions)buildOptions);
            diagnosticResult = loadResult.diagnostics();
            if (diagnosticResult.hasErrors()) {
                exitCode = 1;
            }
            project = loadResult.project();
            if (buildOptions.dumpBuildTime()) {
                BuildTime.getInstance().projectLoadDuration = System.currentTimeMillis() - start;
            }
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.errStream, e.getMessage(), testCmd, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.debugPort != null) {
            System.setProperty("debug", this.debugPort);
        }
        if (this.listGroups && (this.rerunTests || this.coverage != null || this.testReport != null || this.groupList != null || this.disableGroupList != null || this.testList != null)) {
            this.outStream.println("\nWarning: Other flags are skipped when list-groups flag is provided.\n");
        }
        if (project.buildOptions().codeCoverage()) {
            if (this.coverageFormat != null && !this.coverageFormat.equals("xml")) {
                String errMsg = "unsupported coverage report format '" + this.coverageFormat + "' found. Only 'xml' format is supported.";
                CommandUtil.printError(this.errStream, errMsg, null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            if (this.excludes != null && this.excludes.isEmpty()) {
                this.outStream.println("warning: ignoring --excludes flag since given exclusion list is empty");
            }
        } else {
            if (this.includes != null) {
                this.outStream.println("warning: ignoring --includes flag since code coverage is not enabled");
            }
            if (this.coverageFormat != null) {
                this.outStream.println("warning: ignoring --coverage-format flag since code coverage is not enabled");
            }
            if (this.excludes != null) {
                this.outStream.println("warning: ignoring --excludes flag since code coverage is not enabled");
            }
        }
        if (project.buildOptions().nativeImage() && project.buildOptions().codeCoverage()) {
            this.outStream.println("WARNING: Code coverage generation is not supported with Ballerina native test");
        }
        if (!project.buildOptions().nativeImage() && !project.buildOptions().graalVMBuildOptions().isEmpty()) {
            this.outStream.println("WARNING: Additional GraalVM build options are ignored since graalvm flag is not set");
        }
        if (!project.buildOptions().cloud().isEmpty() && project.buildOptions().codeCoverage()) {
            this.outStream.println("WARNING: Code coverage generation is not supported with Ballerina cloud test");
        }
        if (!project.buildOptions().cloud().isEmpty() && this.rerunTests) {
            this.outStream.println("WARNING: Rerun failed tests is not supported with Ballerina cloud test");
        }
        if (!project.buildOptions().cloud().isEmpty() && project.buildOptions().testReport()) {
            this.outStream.println("WARNING: Test report generation is not supported with Ballerina cloud test");
        }
        boolean isTestingDelegated = project.buildOptions().cloud().equals("docker");
        AtomicInteger testResult = new AtomicInteger(0);
        TestReport testReport = null;
        if (project.buildOptions().testReport() || project.buildOptions().codeCoverage()) {
            testReport = new TestReport();
        }
        if (project.kind() == ProjectKind.WORKSPACE_PROJECT) {
            Optional<Object> buildProjectOptional;
            diagnosticResult.diagnostics().forEach(diagnostic -> this.errStream.println(diagnostic.toString()));
            if (testReport != null) {
                testReport.setWorkspaceName(Optional.of(project.sourceRoot().getFileName()).get().toString());
            }
            WorkspaceProject workspaceProject = (WorkspaceProject)project;
            DependencyGraph<BuildProject> projectDependencyGraph = CommandUtil.resolveWorkspaceDependencies(workspaceProject, this.outStream);
            ArrayList<BuildProject> topologicallySortedList = new ArrayList<BuildProject>(projectDependencyGraph.toTopologicallySortedList());
            if (!workspaceProject.sourceRoot().equals(absProjectPath)) {
                buildProjectOptional = projectDependencyGraph.getNodes().stream().filter(node -> node.sourceRoot().equals(absProjectPath)).findFirst();
                Collection projectDependencies = projectDependencyGraph.getAllDependencies((Object)((BuildProject)buildProjectOptional.orElseThrow()));
                topologicallySortedList.removeIf(prj -> !projectDependencies.contains(prj) && prj != buildProjectOptional.get());
            } else {
                buildProjectOptional = Optional.empty();
            }
            boolean execResult = false;
            for (BuildProject buildProject : topologicallySortedList) {
                boolean skipExecution = false;
                String prevTestClassPath = "";
                boolean rebuildNeeded = true;
                try {
                    Path buildFilePath = buildProject.targetDir().resolve("build");
                    BuildJson buildJson = ProjectUtils.readBuildJson((Path)buildFilePath);
                    if (buildJson.getTestClassPath() != null) {
                        prevTestClassPath = buildJson.getTestClassPath();
                    }
                }
                catch (IOException buildFilePath) {
                    // empty catch block
                }
                try {
                    if (buildProjectOptional.isPresent() && buildProject != buildProjectOptional.get()) {
                        skipExecution = true;
                    }
                    this.executeTasks(isTestingDelegated, (Project)buildProject, testResult, cliArgs, testReport, rebuildNeeded, prevTestClassPath, skipExecution);
                }
                catch (BLauncherException e) {
                    if (!e.getDetailedMessages().isEmpty() && !e.getDetailedMessages().get(0).equals("error: there are test failures")) {
                        throw e;
                    }
                    execResult = true;
                }
            }
            if (execResult) {
                this.generateTestReport(project, testReport);
                throw LauncherUtils.createLauncherException("error: there are test failures");
            }
        } else {
            if (testReport != null) {
                String projectName = project.currentPackage().packageName().toString();
                if (project.kind() == ProjectKind.SINGLE_FILE_PROJECT) {
                    projectName = Optional.of(project.sourceRoot().getFileName()).get().toString();
                }
                testReport.setWorkspaceName(projectName);
            }
            try {
                String prevTestClassPath = "";
                boolean rebuildNeeded = true;
                try {
                    Path buildFilePath = project.targetDir().resolve("build");
                    BuildJson buildJson = ProjectUtils.readBuildJson((Path)buildFilePath);
                    if (buildJson.getTestClassPath() != null) {
                        prevTestClassPath = buildJson.getTestClassPath();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.executeTasks(isTestingDelegated, project, testResult, cliArgs, testReport, rebuildNeeded, prevTestClassPath, false);
            }
            catch (BLauncherException e) {
                if (!e.getDetailedMessages().isEmpty() && e.getDetailedMessages().get(0).equals("error: there are test failures")) {
                    this.generateTestReport(project, testReport);
                }
                throw e;
            }
        }
        this.generateTestReport(project, testReport);
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(exitCode);
        }
    }

    private void generateTestReport(Project project, TestReport report) {
        block36: {
            Path reportDir;
            if (!project.buildOptions().testReport() && !project.buildOptions().codeCoverage()) {
                return;
            }
            if (report == null || report.getPackages().isEmpty()) {
                return;
            }
            this.outStream.println();
            this.outStream.println("Generating Test Report");
            report.finalizeTestResults(project.buildOptions().codeCoverage());
            Gson gson = new Gson();
            String json = project.kind() == ProjectKind.WORKSPACE_PROJECT ? gson.toJson((Object)report) : gson.toJson(report.getPackages().get(0));
            try {
                Files.createDirectories(project.targetDir(), new FileAttribute[0]);
                Target target = new Target(project.targetDir());
                reportDir = target.getReportPath();
                File jsonFile = new File(reportDir.resolve("test_results.json").toString());
                try (FileOutputStream fileOutputStream = new FileOutputStream(jsonFile);
                     OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
                    writer.write(json);
                    this.outStream.println("\t" + String.valueOf(jsonFile.toPath()) + "\n");
                }
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("error occurred while generating test report: " + String.valueOf(e));
            }
            Path reportZipPath = TestUtils.getReportToolsPath();
            if (Files.exists(reportZipPath, new LinkOption[0])) {
                String content;
                try {
                    try (FileInputStream fileInputStream = new FileInputStream(reportZipPath.toFile());){
                        CodeCoverageUtils.unzipReportResources((InputStream)fileInputStream, (File)reportDir.toFile());
                    }
                    content = Files.readString(reportDir.resolve("index.html"));
                    content = content.replace("__data__", json);
                }
                catch (IOException e) {
                    throw LauncherUtils.createLauncherException("error occurred while preparing test report: " + String.valueOf(e));
                }
                try {
                    File htmlFile = new File(reportDir.resolve("index.html").toString());
                    try (FileOutputStream fileOutputStream = new FileOutputStream(htmlFile);
                         OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
                        writer.write(content);
                        this.outStream.println("\tView the test report at: file://" + String.valueOf(Path.of(htmlFile.getPath(), new String[0]).toAbsolutePath().normalize()));
                        break block36;
                    }
                }
                catch (IOException e) {
                    throw LauncherUtils.createLauncherException("error occurred while writing test report to file: " + String.valueOf(e));
                }
            }
            String reportToolsPath = ProjectUtils.getBalHomePath().resolve("lib").resolve("tools").resolve("coverage").resolve("report.zip").toString();
            this.outStream.println("warning: Could not find the required HTML report tools for code coverage at " + reportToolsPath);
        }
    }

    private void executeTasks(boolean isTestingDelegated, Project project, AtomicInteger testResult, String[] cliArgs, TestReport testReport, boolean rebuildNeeded, String prevTestClassPath, boolean skipExecution) {
        boolean isSingleFile = project.kind().equals((Object)ProjectKind.SINGLE_FILE_PROJECT);
        ArrayList<Diagnostic> buildToolDiagnostics = new ArrayList<Diagnostic>();
        TaskExecutor preBuildTaskExecutor = new TaskExecutor.TaskBuilder().addTask(new CleanTargetCacheDirTask(), isSingleFile).addTask(new CleanTargetBinTestsDirTask(), isSingleFile || !isTestingDelegated).addTask(new RestoreCachedArtifactsTask(), rebuildNeeded).addTask(new RunBuildToolsTask(this.outStream, !rebuildNeeded, buildToolDiagnostics), isSingleFile).build();
        preBuildTaskExecutor.executeTasks(project);
        Iterable originalModules = project.currentPackage().modules();
        HashMap<String, Module> moduleMap = new HashMap<String, Module>();
        for (Module originalModule : originalModules) {
            moduleMap.put(originalModule.moduleName().toString(), originalModule);
        }
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new ResolveMavenDependenciesTask(this.outStream, !rebuildNeeded)).addTask(new CompileTask(this.outStream, this.errStream, false, false, !rebuildNeeded, buildToolDiagnostics)).addTask(new CreateTestExecutableTask(this.outStream, this.groupList, this.disableGroupList, this.testList, this.listGroups, cliArgs, this.isParallelExecution), !isTestingDelegated || skipExecution).addTask(new RunTestsTask(this.outStream, this.errStream, this.rerunTests, this.groupList, this.disableGroupList, this.testList, this.includes, this.coverageFormat, moduleMap, this.listGroups, this.excludes, cliArgs, this.isParallelExecution, rebuildNeeded, prevTestClassPath, testResult, this.minCoverage, testReport), project.buildOptions().nativeImage() || isTestingDelegated || skipExecution).addTask(new RunNativeImageTestTask(this.outStream, this.rerunTests, this.groupList, this.disableGroupList, this.testList, this.includes, this.coverageFormat, moduleMap, this.listGroups, this.isParallelExecution, testReport), !project.buildOptions().nativeImage() || isTestingDelegated || skipExecution).addTask(new DumpBuildTimeTask(this.outStream), !project.buildOptions().dumpBuildTime()).addTask(new CacheArtifactsTask("test", skipExecution), !rebuildNeeded || isSingleFile).addTask(new CreateFingerprintTask(true, false), !rebuildNeeded || isSingleFile).build();
        taskExecutor.executeTasks(project);
    }

    private BuildOptions constructBuildOptions() {
        BuildOptions.BuildOptionsBuilder buildOptionsBuilder = BuildOptions.builder();
        buildOptionsBuilder.setCodeCoverage(this.coverage).setExperimental(this.experimentalFlag).setOffline(this.offline).setSkipTests(Boolean.valueOf(false)).setTestReport(this.testReport).setObservabilityIncluded(this.observabilityIncluded).setDumpBuildTime(this.dumpBuildTime).setSticky(this.sticky).setCloud(this.cloud).setDumpGraph(Boolean.valueOf(this.dumpGraph)).setDumpRawGraphs(Boolean.valueOf(this.dumpRawGraphs)).setNativeImage(this.nativeImage).disableSyntaxTreeCaching(this.disableSyntaxTreeCaching).setGraalVMBuildOptions(this.graalVMBuildOptions).setShowDependencyDiagnostics(this.showDependencyDiagnostics).setOptimizeDependencyCompilation(this.optimizeDependencyCompilation).setLockingMode(this.lockingMode);
        if (this.targetDir != null) {
            buildOptionsBuilder.targetDir(this.targetDir.toString());
        }
        return buildOptionsBuilder.build();
    }

    @Override
    public String getName() {
        return "test";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("test"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("bal test [--OPTIONS]\n                   [<ballerina-file> | <package-path>] [(-Ckey=value)...]\n");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

