/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.BalToolsToml;
import io.ballerina.projects.BlendedBalToolsManifest;
import io.ballerina.projects.internal.BalToolsManifestBuilder;
import io.ballerina.projects.util.BalToolsUtil;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import picocli.CommandLine;

@CommandLine.Command(name="location", description={"Get filesystem location of a tool"}, hidden=true)
public class ToolLocationCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private final boolean exitWhenFinish;
    private static final String TOOL_LOCATION_USAGE_TEXT = "bal tool location <tool-id>[:<version>]";
    @CommandLine.Parameters(description={"Tool specification"})
    private List<String> argList;
    @CommandLine.Option(names={"--repository"}, description={"Repository name"})
    private String repository;
    @CommandLine.Option(names={"--lib"}, description={"Get the location of JAR files instead of tool base path"})
    private boolean lib;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;

    public ToolLocationCommand() {
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = true;
    }

    public ToolLocationCommand(PrintStream outStream, PrintStream errStream, boolean exitWhenFinish) {
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
    }

    @Override
    public void execute() {
        String toolId;
        if (this.helpFlag) {
            this.outStream.println(BLauncherCmd.getCommandUsageInfo("tool-location"));
            return;
        }
        if (this.argList == null || this.argList.isEmpty()) {
            CommandUtil.printError(this.errStream, "tool id is not provided.", TOOL_LOCATION_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.argList.size() > 1) {
            CommandUtil.printError(this.errStream, "too many arguments.", TOOL_LOCATION_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String toolSpec = this.argList.get(0);
        String version = null;
        if (toolSpec.contains(":")) {
            String[] parts = toolSpec.split(":", 2);
            toolId = parts[0];
            version = parts[1];
        } else {
            toolId = toolSpec;
        }
        if (toolId.trim().isEmpty()) {
            CommandUtil.printError(this.errStream, "tool id cannot be empty.", TOOL_LOCATION_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        try {
            BalToolsToml balToolsToml = BalToolsToml.from((Path)BalToolsUtil.BAL_TOOLS_TOML_PATH);
            BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
            BalToolsToml distBalToolsToml = BalToolsToml.from((Path)BalToolsUtil.DIST_BAL_TOOLS_TOML_PATH);
            BalToolsManifest distBalToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)distBalToolsToml).build();
            BlendedBalToolsManifest blendedBalToolsManifest = BlendedBalToolsManifest.from((BalToolsManifest)balToolsManifest, (BalToolsManifest)distBalToolsManifest);
            Optional toolOpt = version != null && this.repository != null ? blendedBalToolsManifest.getTool(toolId, version, this.repository) : (version != null ? blendedBalToolsManifest.getTool(toolId, version, null) : blendedBalToolsManifest.getActiveTool(toolId));
            if (toolOpt.isEmpty()) {
                String errorMsg = "tool '" + toolId;
                if (version != null) {
                    errorMsg = errorMsg + ":" + version;
                }
                errorMsg = errorMsg + "' not found";
                if (this.repository != null) {
                    errorMsg = errorMsg + " in repository '" + this.repository + "'";
                }
                CommandUtil.printError(this.errStream, errorMsg + ".", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            BalToolsManifest.Tool tool = (BalToolsManifest.Tool)toolOpt.get();
            Path toolPath = this.getToolPath(tool);
            if (this.lib) {
                toolPath = toolPath.resolve("tool").resolve("libs");
            }
            if (Files.exists(toolPath, new LinkOption[0])) {
                this.outStream.println(toolPath.toAbsolutePath());
            } else {
                CommandUtil.printError(this.errStream, "tool location does not exist: " + String.valueOf(toolPath.toAbsolutePath()), null, false);
                CommandUtil.exitError(this.exitWhenFinish);
            }
        }
        catch (Exception e) {
            CommandUtil.printError(this.errStream, "failed to get tool location: " + e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
        }
    }

    private Path getToolPath(BalToolsManifest.Tool tool) {
        Path repoPath = BalToolsUtil.getRepoPath((String)tool.repository());
        return CommandUtil.getPlatformSpecificBalaPath(tool.org(), tool.name(), tool.version(), repoPath);
    }

    @Override
    public String getName() {
        return "location";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("tool-location"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append(TOOL_LOCATION_USAGE_TEXT);
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

