/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.BalToolsToml;
import io.ballerina.projects.BlendedBalToolsManifest;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.internal.BalToolsManifestBuilder;
import io.ballerina.projects.util.BalToolsUtil;
import io.ballerina.projects.util.ProjectUtils;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="remove", description={"Search the Ballerina Central for tools."})
public class ToolRemoveCommand
implements BLauncherCmd {
    private final boolean exitWhenFinish;
    private final PrintStream outStream;
    private final PrintStream errStream;
    private String toolId;
    private String version;
    private static final String TOOL_REMOVE_USAGE_TEXT = "bal tool remove <tool-id>:[<version>]";
    @CommandLine.Parameters(description={"Use a tool"})
    private List<String> argList;
    @CommandLine.Option(names={"--repository"})
    private String repositoryName;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;

    public ToolRemoveCommand() {
        this.exitWhenFinish = true;
        this.outStream = System.out;
        this.errStream = System.err;
    }

    public ToolRemoveCommand(PrintStream outStream, PrintStream errStream, boolean exitWhenFinish) {
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
    }

    @Override
    public void execute() {
        if (this.helpFlag) {
            this.outStream.println(BLauncherCmd.getCommandUsageInfo("tool-remove"));
            return;
        }
        if (this.argList == null || this.argList.isEmpty()) {
            CommandUtil.printError(this.errStream, "tool id is not provided.", TOOL_REMOVE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.argList.size() > 1) {
            CommandUtil.printError(this.errStream, "too many arguments.", TOOL_REMOVE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.repositoryName != null && !this.repositoryName.equals("local")) {
            String errMsg = "unsupported repository '" + this.repositoryName + "' found. Only 'local' repository is supported.";
            CommandUtil.printError(this.errStream, errMsg, null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String toolIdAndVersion = this.argList.get(0);
        String[] toolInfo = toolIdAndVersion.split(":");
        if (toolInfo.length == 2) {
            this.toolId = toolInfo[0];
            this.version = toolInfo[1];
        } else if (toolInfo.length == 1) {
            this.toolId = toolIdAndVersion;
            this.version = Names.EMPTY.getValue();
        } else {
            CommandUtil.printError(this.errStream, "invalid tool id.", TOOL_REMOVE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!ProjectUtils.validateToolName((String)this.toolId)) {
            CommandUtil.printError(this.errStream, "invalid tool id.", TOOL_REMOVE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!Names.EMPTY.getValue().equals(this.version)) {
            try {
                SemanticVersion.from((String)this.version);
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, "invalid tool version. " + e.getMessage(), TOOL_REMOVE_USAGE_TEXT, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
        }
        if (Names.EMPTY.getValue().equals(this.version)) {
            this.removeAllToolVersions();
        } else {
            this.removeSpecificToolVersion();
        }
    }

    @Override
    public String getName() {
        return "remove";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("tool-remove"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append(TOOL_REMOVE_USAGE_TEXT);
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private void removeAllToolVersions() {
        BalToolsToml balToolsToml = BalToolsToml.from((Path)BalToolsUtil.BAL_TOOLS_TOML_PATH);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
        Optional<Map> toolVersions = Optional.ofNullable((Map)balToolsManifest.tools().get(this.toolId));
        if (toolVersions.isEmpty() || toolVersions.get().isEmpty()) {
            BalToolsToml distBalToolsToml = BalToolsToml.from((Path)BalToolsUtil.DIST_BAL_TOOLS_TOML_PATH);
            BalToolsManifest distBalToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)distBalToolsToml).build();
            toolVersions = Optional.ofNullable((Map)distBalToolsManifest.tools().get(this.toolId));
            if (toolVersions.isPresent() && !toolVersions.get().isEmpty()) {
                CommandUtil.printError(this.errStream, "tools cannot be removed from the distribution repository.", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            CommandUtil.printError(this.errStream, "tool '" + this.toolId + "' not found.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        balToolsManifest.removeTool(this.toolId);
        balToolsToml.modify(balToolsManifest);
        if (this.repositoryName != null) {
            this.outStream.println("tool '" + this.toolId + "' successfully removed.");
            return;
        }
        Optional tool = toolVersions.get().values().stream().findAny().flatMap(value -> value.values().stream().findAny());
        tool.ifPresent(value -> this.deleteAllCachedToolVersions(value.org(), value.name()));
        this.outStream.println("tool '" + this.toolId + "' successfully removed.");
    }

    private void removeSpecificToolVersion() {
        String name;
        BalToolsToml distBalToolsToml;
        BalToolsManifest distBalToolsManifest;
        BalToolsToml balToolsToml = BalToolsToml.from((Path)BalToolsUtil.BAL_TOOLS_TOML_PATH);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
        BlendedBalToolsManifest blendedBalToolsManifest = BlendedBalToolsManifest.from((BalToolsManifest)balToolsManifest, (BalToolsManifest)(distBalToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)(distBalToolsToml = BalToolsToml.from((Path)BalToolsUtil.DIST_BAL_TOOLS_TOML_PATH))).build()));
        Optional tool = blendedBalToolsManifest.getTool(this.toolId, this.version, this.repositoryName);
        if (tool.isEmpty()) {
            CommandUtil.printError(this.errStream, "tool '" + this.toolId + ":" + this.version + "' not found in the local cache.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if ("distribution".equals(((BalToolsManifest.Tool)tool.get()).repository())) {
            CommandUtil.printError(this.errStream, "tools from the distribution repository cannot be removed.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String org = ((BalToolsManifest.Tool)tool.get()).org();
        Path toolBalaPath = CommandUtil.getPlatformSpecificBalaPath(org, name = ((BalToolsManifest.Tool)tool.get()).name(), ((BalToolsManifest.Tool)tool.get()).version(), BalToolsUtil.getRepoPath((String)((BalToolsManifest.Tool)tool.get()).repository()));
        if (Files.exists(toolBalaPath, new LinkOption[0])) {
            boolean isCompatibleWithPlatform = BalToolsUtil.isCompatibleWithPlatform((String)org, (String)name, (String)this.version, (String)this.repositoryName);
            if (!isCompatibleWithPlatform) {
                CommandUtil.printError(this.errStream, "tool '" + this.toolId + ":" + this.version + "' is not compatible with the current Ballerina distribution '" + RepoUtils.getBallerinaShortVersion() + "'. Use 'bal tool search' to select a version compatible with the current Ballerina distribution.", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            this.deleteCachedToolVersion(((BalToolsManifest.Tool)tool.get()).org(), ((BalToolsManifest.Tool)tool.get()).name(), this.version);
        }
        balToolsManifest.removeToolVersion(this.toolId, this.version, this.repositoryName);
        balToolsToml.modify(balToolsManifest);
        this.outStream.println("tool '" + this.toolId + ":" + this.version + "' successfully removed.");
    }

    private void deleteAllCachedToolVersions(String org, String name) {
        Path toolPath = RepoUtils.createAndGetHomeReposPath().resolve(Path.of("repositories", "central.ballerina.io", "bala", org, name));
        if (!Files.isDirectory(toolPath, new LinkOption[0])) {
            return;
        }
        ProjectUtils.deleteDirectory((Path)toolPath);
    }

    private void deleteCachedToolVersion(String org, String name, String version) {
        Path toolPath = RepoUtils.createAndGetHomeReposPath().resolve(Path.of("repositories", "central.ballerina.io", "bala", org, name, version));
        if (!Files.isDirectory(toolPath, new LinkOption[0])) {
            return;
        }
        ProjectUtils.deleteDirectory((Path)toolPath);
    }
}

