/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.utils.ToolUtils;
import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.BalToolsToml;
import io.ballerina.projects.BlendedBalToolsManifest;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.Settings;
import io.ballerina.projects.internal.BalToolsManifestBuilder;
import io.ballerina.projects.internal.model.Proxy;
import io.ballerina.projects.util.BalToolsUtil;
import io.ballerina.projects.util.ProjectUtils;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.exceptions.PackageAlreadyExistsException;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="update", description={"Search the Ballerina Central for tools."})
public class ToolUpdateCommand
implements BLauncherCmd {
    private final boolean exitWhenFinish;
    private final PrintStream outStream = System.out;
    private final PrintStream errStream = System.err;
    private String toolId;
    private static final String TOOL_UPDATE_USAGE_TEXT = "bal tool update <tool-id>";
    @CommandLine.Parameters(description={"Use a tool"})
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--offline"}, hidden=true)
    private boolean offline;

    public ToolUpdateCommand() {
        this.exitWhenFinish = true;
    }

    @Override
    public void execute() {
        if (this.helpFlag) {
            this.outStream.println(BLauncherCmd.getCommandUsageInfo("tool-update"));
            return;
        }
        if (this.argList == null || this.argList.isEmpty()) {
            CommandUtil.printError(this.errStream, "tool id is not provided.", TOOL_UPDATE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.argList.size() > 1) {
            CommandUtil.printError(this.errStream, "too many arguments.", TOOL_UPDATE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        this.toolId = this.argList.get(0);
        if (!ProjectUtils.validateToolName((String)this.toolId)) {
            CommandUtil.printError(this.errStream, "invalid tool id.", TOOL_UPDATE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        this.updateToolToLatestVersion();
    }

    @Override
    public String getName() {
        return "update";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("tool-update"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append(TOOL_UPDATE_USAGE_TEXT);
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private void updateToolToLatestVersion() {
        BalToolsToml distBalToolsToml;
        BalToolsManifest distBalToolsManifest;
        BalToolsToml balToolsToml = BalToolsToml.from((Path)BalToolsUtil.BAL_TOOLS_TOML_PATH);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
        BlendedBalToolsManifest blendedBalToolsManifest = BlendedBalToolsManifest.from((BalToolsManifest)balToolsManifest, (BalToolsManifest)(distBalToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)(distBalToolsToml = BalToolsToml.from((Path)BalToolsUtil.DIST_BAL_TOOLS_TOML_PATH))).build()));
        Optional tool = blendedBalToolsManifest.getActiveTool(this.toolId);
        if (tool.isEmpty()) {
            CommandUtil.printError(this.errStream, "tool '" + this.toolId + "' is not installed.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if ("local".equals(((BalToolsManifest.Tool)tool.get()).repository())) {
            CommandUtil.printError(this.errStream, "tools from local repository can not be updated. ", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
        }
        Optional currentActiveTool = balToolsManifest.getActiveTool(this.toolId);
        balToolsManifest.compatibleTools().values().stream().flatMap(map -> map.values().stream()).flatMap(map -> map.values().stream()).filter(t -> t.id().equals(this.toolId) && t.force()).forEach(t -> {
            t.setForce(false);
            t.setActive(false);
        });
        BalToolsManifest.Tool highestCompatibleToolVersion = blendedBalToolsManifest.getHighestCompatibleToolVersion(this.toolId);
        if (this.offline) {
            currentActiveTool.ifPresent(activeTool -> {
                if (SemanticVersion.from((String)activeTool.version()).greaterThanOrEqualTo(SemanticVersion.from((String)highestCompatibleToolVersion.version()))) {
                    this.outStream.println("tool '" + this.toolId + "' is already up-to-date.");
                } else {
                    this.outStream.println("tool '" + this.toolId + ":" + highestCompatibleToolVersion.version() + "' successfully set as the active version.");
                    ((Map)balToolsManifest.tools().get(this.toolId)).values().stream().flatMap(map -> map.values().stream()).filter(t -> !t.version().equals(highestCompatibleToolVersion.version())).forEach(t -> {
                        t.setActive(false);
                        t.setForce(false);
                    });
                }
            });
            balToolsToml.modify(balToolsManifest);
            return;
        }
        String supportedPlatform = Arrays.stream(JvmTarget.values()).map(JvmTarget::code).collect(Collectors.joining(","));
        try {
            String version = this.getLatestVersionForUpdateCommand(supportedPlatform, (BalToolsManifest.Tool)tool.get());
            if (SemanticVersion.from((String)((BalToolsManifest.Tool)tool.get()).version()).greaterThanOrEqualTo(SemanticVersion.from((String)version))) {
                this.outStream.println("tool '" + this.toolId + "' is already up-to-date.");
                balToolsToml.modify(balToolsManifest);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            Optional<BalToolsManifest.Tool> toolAvailableLocally = ToolUtils.getToolAvailableLocally(this.toolId, version, null);
            if (toolAvailableLocally.isPresent()) {
                this.outStream.println("tool '" + this.toolId + ":" + version + "' is already available locally.");
                this.addToBalToolsToml(balToolsToml, balToolsManifest, toolAvailableLocally.orElseThrow(), this.errStream);
                this.outStream.println("tool '" + this.toolId + ":" + version + "' successfully set as the active version.");
                return;
            }
            BalToolsManifest.Tool toolFromCentral = BalToolsUtil.pullToolPackageFromRemote((String)this.toolId, (String)version);
            this.addToBalToolsToml(balToolsToml, balToolsManifest, toolFromCentral, this.errStream);
            this.outStream.println("tool '" + this.toolId + ":" + version + "' successfully set as the active version.");
        }
        catch (PackageAlreadyExistsException e) {
            this.errStream.println(e.getMessage());
            CommandUtil.exitError(this.exitWhenFinish);
        }
        catch (ProjectException | CentralClientException e) {
            CommandUtil.printError(this.errStream, "unexpected error occurred while pulling tool:" + e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
        }
    }

    private String getLatestVersionForUpdateCommand(String supportedPlatforms, BalToolsManifest.Tool tool) throws CentralClientException {
        Settings settings = RepoUtils.readSettings();
        System.setProperty("enableOutputStream", "true");
        CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy((Proxy)settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI((Settings)settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
        List versions = client.getPackageVersions(tool.org(), tool.name(), supportedPlatforms, RepoUtils.getBallerinaVersion());
        return this.getLatestVersion(versions, tool.version());
    }

    private String getLatestVersion(List<String> versions, String currentVersionStr) {
        Optional<String> latestVersionInSameMinor = versions.stream().map(SemanticVersion::from).max((v1, v2) -> {
            if (v1.greaterThan(v2)) {
                return 1;
            }
            if (v2.greaterThan(v1)) {
                return -1;
            }
            return 0;
        }).map(SemanticVersion::toString);
        return latestVersionInSameMinor.orElse(currentVersionStr);
    }

    private void addToBalToolsToml(BalToolsToml balToolsToml, BalToolsManifest balToolsManifest, BalToolsManifest.Tool tool, PrintStream printStream) {
        boolean isCompatibleWithPlatform = BalToolsUtil.isCompatibleWithPlatform((String)tool.org(), (String)tool.name(), (String)tool.version(), (String)tool.repository());
        if (!isCompatibleWithPlatform) {
            printStream.println("Tool '" + this.toolId + ":" + tool.version() + "' is not compatible with the current Ballerina distribution version. Run 'bal tool list' to see compatible versions.");
            return;
        }
        Optional currentActiveTool = balToolsManifest.getActiveTool(this.toolId);
        currentActiveTool.ifPresent(activeTool -> activeTool.setForce(false));
        balToolsManifest.addTool(tool.id(), tool.org(), tool.name(), tool.version(), Boolean.valueOf(true), tool.repository());
        balToolsToml.modify(balToolsManifest);
    }
}

