/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.launcher.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.stream.Collectors;

public final class BCompileUtil {
    private BCompileUtil() {
    }

    public static String readFileAsString(String path) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream(path), StandardCharsets.UTF_8));){
            String content = br.readLine();
            if (content == null) {
                String string = sb.toString();
                return string;
            }
            sb.append(content);
            while ((content = br.readLine()) != null) {
                sb.append('\n').append(content);
            }
        }
        return sb.toString();
    }

    public static String readFileAsString(String path, ClassLoader classLoader) throws IOException {
        try (InputStream inputStream = classLoader.getResourceAsStream(path);){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8));){
                string = reader.lines().collect(Collectors.joining("\n"));
            }
            return string;
        }
    }
}

