/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.task.Task;
import io.ballerina.cli.utils.BuildTime;
import io.ballerina.cli.utils.GraalVMCompatibilityUtils;
import io.ballerina.projects.EmitResult;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.internal.model.Target;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;

public class CreateBalaTask
implements Task {
    private final transient PrintStream out;

    public CreateBalaTask(PrintStream out) {
        this.out = out;
    }

    @Override
    public void execute(Project project) {
        Path relativePathToExecutable;
        EmitResult emitResult;
        Path balaPath;
        this.out.println();
        this.out.println("Creating bala");
        try {
            Target target = new Target(project.targetDir());
            balaPath = target.getBalaPath();
        }
        catch (ProjectException | IOException e) {
            throw LauncherUtils.createLauncherException(e.getMessage());
        }
        try {
            String warning;
            PackageCompilation packageCompilation = project.currentPackage().getCompilation();
            JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)packageCompilation, (JvmTarget)JvmTarget.JAVA_21);
            long start = 0L;
            if (project.buildOptions().dumpBuildTime()) {
                start = System.currentTimeMillis();
            }
            if ((warning = GraalVMCompatibilityUtils.getWarningForPackage(project.currentPackage(), jBallerinaBackend.targetPlatform().code())) != null) {
                this.out.println("\n" + warning);
            }
            emitResult = jBallerinaBackend.emit(JBallerinaBackend.OutputType.BALA, balaPath);
            if (project.buildOptions().dumpBuildTime()) {
                BuildTime.getInstance().emitArtifactDuration = System.currentTimeMillis() - start;
                BuildTime.getInstance().compile = true;
            }
        }
        catch (ProjectException e) {
            throw LauncherUtils.createLauncherException("BALA creation failed:" + e.getMessage());
        }
        try {
            relativePathToExecutable = project.sourceRoot().relativize(emitResult.generatedArtifactPath());
        }
        catch (IllegalArgumentException e) {
            relativePathToExecutable = project.sourceRoot().resolve(emitResult.generatedArtifactPath());
        }
        if (relativePathToExecutable.toString().contains("..") || relativePathToExecutable.toString().contains("." + File.separator)) {
            this.out.println("\t" + emitResult.generatedArtifactPath().toString());
        } else {
            this.out.println("\t" + String.valueOf(relativePathToExecutable));
        }
    }
}

