/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.task.Task;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class CreateDependencyGraphTask
implements Task {
    private final transient PrintStream out;
    private final transient PrintStream err;
    private final List<Diagnostic> buildToolDiagnostics;

    public CreateDependencyGraphTask(PrintStream err, PrintStream out, List<Diagnostic> buildToolDiagnostics) {
        this.out = out;
        this.err = err;
        this.buildToolDiagnostics = buildToolDiagnostics;
    }

    @Override
    public void execute(Project project) {
        if (ProjectUtils.isProjectEmpty((Project)project)) {
            throw LauncherUtils.createLauncherException("package is empty. Please add at least one .bal file.");
        }
        System.setProperty("enableOutputStream", "true");
        try {
            DiagnosticResult codeGenAndModifyDiagnosticResult;
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>(this.buildToolDiagnostics);
            PackageResolution packageResolution = project.currentPackage().getResolution();
            if (project.currentPackage().compilationOptions().dumpRawGraphs().booleanValue()) {
                packageResolution.dumpGraphs(this.out);
            }
            if (!this.isResolutionErroneous(project) && this.isProjectKindSuitableForCodeGenAndModify(project) && (codeGenAndModifyDiagnosticResult = project.currentPackage().runCodeGenAndModifyPlugins()) != null) {
                diagnostics.addAll(codeGenAndModifyDiagnosticResult.diagnostics());
            }
            if (packageResolution != project.currentPackage().getResolution()) {
                packageResolution = project.currentPackage().getResolution();
                if (project.currentPackage().compilationOptions().dumpRawGraphs().booleanValue()) {
                    packageResolution.dumpGraphs(this.out);
                }
            }
            if (project.currentPackage().compilationOptions().dumpGraph().booleanValue()) {
                packageResolution.dumpGraphs(this.out);
            }
            if (this.isResolutionErroneous(project)) {
                diagnostics.addAll(project.currentPackage().getResolution().diagnosticResult().diagnostics());
                diagnostics.forEach(d -> this.err.println(d.toString()));
                throw LauncherUtils.createLauncherException("package resolution contains errors");
            }
        }
        catch (ProjectException e) {
            throw LauncherUtils.createLauncherException("dependency graph resolution failed: " + e.getMessage());
        }
    }

    private boolean isProjectKindSuitableForCodeGenAndModify(Project project) {
        return !project.kind().equals((Object)ProjectKind.BALA_PROJECT);
    }

    private boolean isResolutionErroneous(Project project) {
        return project.currentPackage().getResolution().diagnosticResult().hasErrors();
    }
}

