/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.task.Task;
import io.ballerina.projects.Project;
import io.ballerina.projects.internal.model.BuildJson;
import io.ballerina.projects.internal.model.Target;
import io.ballerina.projects.util.ProjectUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wso2.ballerinalang.util.RepoUtils;

public class CreateFingerprintTask
implements Task {
    public static final String JAR = ".jar";
    private final boolean isTestExecution;
    private final boolean skipExecutable;

    public CreateFingerprintTask(boolean isTestExecution, boolean skipExecutable) {
        this.isTestExecution = isTestExecution;
        this.skipExecutable = skipExecutable;
    }

    @Override
    public void execute(Project project) {
        Path buildFilePath = project.targetDir().resolve("build");
        if (!buildFilePath.toFile().exists()) {
            return;
        }
        try {
            BuildJson buildJson = ProjectUtils.readBuildJson((Path)buildFilePath);
            buildJson.setBuildOptions(project.buildOptions());
            CreateFingerprintTask.createFingerPrintForProjectFiles(project, buildJson, this.isTestExecution);
            CreateFingerprintTask.createFingerPrintForArtifacts(project, buildJson, this.isTestExecution, this.skipExecutable);
            CreateFingerprintTask.createFingerPrintForSettingsToml(buildJson);
            this.createFingerPrintForBallerinaToml(buildJson, project);
            CreateFingerprintTask.writeBuildFile(buildFilePath, buildJson);
        }
        catch (JsonSyntaxException | IOException | NoSuchAlgorithmException throwable) {
            // empty catch block
        }
    }

    private void createFingerPrintForBallerinaToml(BuildJson buildJson, Project project) throws IOException, NoSuchAlgorithmException {
        File ballerinaTomlFile = project.sourceRoot().resolve("Ballerina.toml").toFile();
        BuildJson.FileMetaInfo ballerinaTomlMetaInfo = CreateFingerprintTask.getFileMetaInfo(ballerinaTomlFile);
        buildJson.setBallerinaTomlMetaInfo(ballerinaTomlMetaInfo);
    }

    private static void createFingerPrintForProjectFiles(Project project, BuildJson buildJson, boolean isTestExecution) throws IOException, NoSuchAlgorithmException {
        ArrayList<BuildJson.FileMetaInfo> fileMetaInfoList = new ArrayList<BuildJson.FileMetaInfo>();
        List<File> srcToEvaluate = CommandUtil.getSrcFiles(project);
        for (File fileToEvaluate : srcToEvaluate) {
            fileMetaInfoList.add(CreateFingerprintTask.getFileMetaInfo(fileToEvaluate));
        }
        buildJson.setSrcMetaInfo(fileMetaInfoList.toArray(new BuildJson.FileMetaInfo[0]));
        if (isTestExecution) {
            ArrayList<BuildJson.FileMetaInfo> testSrcMetaInfoList = new ArrayList<BuildJson.FileMetaInfo>();
            List<File> testSrcToEvaluate = CommandUtil.getTestSrcFiles(project);
            for (File fileToEvaluate : testSrcToEvaluate) {
                testSrcMetaInfoList.add(CreateFingerprintTask.getFileMetaInfo(fileToEvaluate));
            }
            buildJson.setTestSrcMetaInfo(testSrcMetaInfoList.toArray(new BuildJson.FileMetaInfo[0]));
        }
    }

    private static void createFingerPrintForSettingsToml(BuildJson buildJson) throws IOException, NoSuchAlgorithmException {
        File settingsFile = RepoUtils.createAndGetHomeReposPath().resolve("Settings.toml").toFile();
        if (!settingsFile.exists()) {
            buildJson.setSettingsMetaInfo(null);
            return;
        }
        buildJson.setSettingsMetaInfo(CreateFingerprintTask.getFileMetaInfo(settingsFile));
    }

    private static void createFingerPrintForArtifacts(Project project, BuildJson buildJson, boolean isTestExecution, boolean skipExecutable) throws IOException, NoSuchAlgorithmException {
        Target target = new Target(project.targetDir().resolve("backup"));
        if (isTestExecution) {
            ArrayList<BuildJson.FileMetaInfo> testArtifactMetaInfoList = new ArrayList<BuildJson.FileMetaInfo>();
            File testSuiteFile = target.getTestsCachePath().resolve("test_suit.json").toFile();
            testArtifactMetaInfoList.add(CreateFingerprintTask.getFileMetaInfo(testSuiteFile));
            String packageOrg = project.currentPackage().packageOrg().toString();
            String packageName = project.currentPackage().packageName().toString();
            String packageVersion = project.currentPackage().packageVersion().toString();
            List<Path> testJarArtifactsPath = Files.walk(target.cachesPath().resolve(packageOrg).resolve(packageName).resolve(packageVersion), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(JAR)).toList();
            for (Path testJarArtifactPath : testJarArtifactsPath) {
                testArtifactMetaInfoList.add(CreateFingerprintTask.getFileMetaInfo(testJarArtifactPath.toFile()));
            }
            buildJson.setTestArtifactMetaInfo(testArtifactMetaInfoList.toArray(new BuildJson.FileMetaInfo[0]));
            return;
        }
        if (!skipExecutable) {
            File execFile = target.getExecutablePath(project.currentPackage()).toAbsolutePath().toFile();
            buildJson.setTargetExecMetaInfo(CreateFingerprintTask.getFileMetaInfo(execFile));
        }
    }

    private static BuildJson.FileMetaInfo getFileMetaInfo(File execFile) throws IOException, NoSuchAlgorithmException {
        BuildJson.FileMetaInfo execMetaInfo = new BuildJson.FileMetaInfo();
        execMetaInfo.setFile(execFile.getAbsolutePath());
        execMetaInfo.setLastModifiedTime(Files.getLastModifiedTime(execFile.toPath(), new LinkOption[0]).toMillis());
        execMetaInfo.setSize(Files.size(execFile.toPath()));
        execMetaInfo.setHash(CommandUtil.getSHA256Digest(execFile));
        return execMetaInfo;
    }

    private static void writeBuildFile(Path buildFilePath, BuildJson buildJson) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!buildFilePath.toFile().canWrite()) {
            return;
        }
        try {
            Files.write(buildFilePath, Collections.singleton(gson.toJson((Object)buildJson)), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

