/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.launcher.RuntimePanicException;
import io.ballerina.cli.task.Task;
import io.ballerina.cli.utils.BuildTime;
import io.ballerina.cli.utils.DebugUtils;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.internal.model.Target;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.wso2.ballerinalang.util.Lists;

public class RunExecutableTask
implements Task {
    private final List<String> args;
    private final transient PrintStream out;
    private final transient PrintStream err;
    private final Target target;
    private Process process;

    public RunExecutableTask(String[] args, PrintStream out, PrintStream err, Target target) {
        this.args = Lists.of((Object[])args);
        this.out = out;
        this.err = err;
        this.target = target;
    }

    @Override
    public void execute(Project project) {
        long start = 0L;
        if (project.buildOptions().dumpBuildTime()) {
            start = System.currentTimeMillis();
        }
        this.out.println();
        this.out.println("Running executable");
        this.out.println();
        try {
            this.runGeneratedExecutable(project);
        }
        catch (ProjectException e) {
            throw LauncherUtils.createLauncherException(e.getMessage());
        }
        if (project.buildOptions().dumpBuildTime()) {
            BuildTime.getInstance().runningExecutableDuration = System.currentTimeMillis() - start;
        }
    }

    private void runGeneratedExecutable(Project project) {
        block5: {
            try {
                ArrayList<String> commands = new ArrayList<String>();
                commands.add(System.getProperty("java.command"));
                if (DebugUtils.isInDebugMode()) {
                    commands.add(DebugUtils.getDebugArgs(this.err));
                }
                commands.add("-XX:+HeapDumpOnOutOfMemoryError");
                commands.add("-XX:HeapDumpPath=" + System.getProperty("user.dir"));
                commands.add("-jar");
                commands.add(this.target.getExecutablePath(project.currentPackage()).toAbsolutePath().normalize().toString());
                commands.addAll(this.args);
                ProcessBuilder pb = new ProcessBuilder(commands).inheritIO();
                this.process = pb.start();
                this.process.waitFor();
                int exitValue = this.process.exitValue();
                if (exitValue != 0) {
                    throw new RuntimePanicException(exitValue);
                }
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("Error occurred while running the executable ", e.getCause());
            }
            catch (InterruptedException e) {
                if (this.process == null || !this.process.isAlive()) break block5;
                this.process.destroy();
            }
        }
    }

    public void killProcess() {
        if (this.process != null && this.process.isAlive()) {
            this.process.destroy();
        }
    }
}

