/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.task.Task;
import io.ballerina.cli.utils.BuildTime;
import io.ballerina.cli.utils.DebugUtils;
import io.ballerina.cli.utils.TestUtils;
import io.ballerina.projects.Document;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JarResolver;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.internal.model.BuildJson;
import io.ballerina.projects.internal.model.Target;
import io.ballerina.projects.util.ProjectUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.ballerinalang.test.runtime.entity.ModuleCoverage;
import org.ballerinalang.test.runtime.entity.ModuleStatus;
import org.ballerinalang.test.runtime.entity.PackageTestResult;
import org.ballerinalang.test.runtime.entity.TestReport;
import org.ballerinalang.test.runtime.entity.TestSuite;
import org.ballerinalang.test.runtime.util.JacocoInstrumentUtils;
import org.ballerinalang.test.runtime.util.TesterinaUtils;
import org.ballerinalang.testerina.core.TestProcessor;
import org.wso2.ballerinalang.util.Lists;

public class RunTestsTask
implements Task {
    private final PrintStream out;
    private final PrintStream err;
    private final String includesInCoverage;
    private final String excludesInCoverage;
    private final Float minCoverage;
    private String groupList;
    private String disableGroupList;
    private boolean report;
    private boolean coverage;
    private final String coverageReportFormat;
    private final boolean isRerunTestExecution;
    private String singleExecTests;
    private final Map<String, Module> coverageModules;
    private final boolean listGroups;
    private final List<String> cliArgs;
    private final boolean isParallelExecution;
    TestReport testReport;
    private final boolean rebuildStatus;
    private final String prevTestClassPath;
    private AtomicInteger testResult;
    private static final Boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.getDefault()).contains("win");
    public static final String EXCLUDES_PATTERN_PATH_SEPARATOR = isWindows != false ? "\\\\" : "/";
    public static final String RELATIVE_PATH_PREFIX = isWindows != false ? ".\\" : "./";
    public static final String PATH_SEPARATOR = isWindows != false ? "\\" : "/";
    public static final String UNIX_PATH_SEPARATOR = "/";

    public RunTestsTask(PrintStream out, PrintStream err, boolean rerunTests, String groupList, String disableGroupList, String testList, String includes, String coverageFormat, Map<String, Module> modules, boolean listGroups, String excludes, String[] cliArgs, boolean isParallelExecution, boolean rebuildStatus, String prevTestClassPath, AtomicInteger testResult, Float minCoverage, TestReport testReport) {
        this.out = out;
        this.err = err;
        this.isRerunTestExecution = rerunTests;
        this.cliArgs = List.of(cliArgs);
        this.isParallelExecution = isParallelExecution;
        this.prevTestClassPath = prevTestClassPath;
        if (disableGroupList != null) {
            this.disableGroupList = disableGroupList;
        } else if (groupList != null) {
            this.groupList = groupList;
        }
        if (testList != null) {
            this.singleExecTests = testList;
        }
        this.includesInCoverage = includes;
        this.coverageReportFormat = coverageFormat;
        this.coverageModules = modules;
        this.listGroups = listGroups;
        this.excludesInCoverage = excludes;
        this.rebuildStatus = rebuildStatus;
        this.testResult = testResult;
        this.minCoverage = minCoverage;
        this.testReport = testReport;
    }

    @Override
    public void execute(Project project) {
        Path testsCachePath;
        Target target;
        Path cachesRoot;
        long start = 0L;
        if (project.buildOptions().dumpBuildTime()) {
            start = System.currentTimeMillis();
        }
        this.report = project.buildOptions().testReport();
        this.coverage = project.buildOptions().codeCoverage();
        try {
            if (project.kind() == ProjectKind.BUILD_PROJECT) {
                cachesRoot = project.sourceRoot();
                target = new Target(project.targetDir());
            } else {
                cachesRoot = Files.createTempDirectory("ballerina-test-cache" + System.nanoTime(), new FileAttribute[0]);
                target = new Target(cachesRoot);
            }
            testsCachePath = target.getTestsCachePath();
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException("error while creating target directory: ", e);
        }
        if (!this.rebuildStatus) {
            this.runTestsUsingSuiteJSONCache(project, target, testsCachePath, cachesRoot);
            return;
        }
        PackageCompilation packageCompilation = project.currentPackage().getCompilation();
        JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)packageCompilation, (JvmTarget)JvmTarget.JAVA_21);
        JarResolver jarResolver = jBallerinaBackend.jarResolver();
        this.runTestsUsingSuiteJSON(project, jarResolver, target, testsCachePath, jBallerinaBackend, cachesRoot);
        TestUtils.cleanTempCache(project, cachesRoot);
        if (project.buildOptions().dumpBuildTime()) {
            BuildTime.getInstance().testingExecutionDuration = System.currentTimeMillis() - start;
        }
    }

    private void runTestsUsingSuiteJSON(Project project, JarResolver jarResolver, Target target, Path testsCachePath, JBallerinaBackend jBallerinaBackend, Path cachesRoot) {
        TestProcessor testProcessor = new TestProcessor(jarResolver);
        ArrayList<String> moduleNamesList = new ArrayList<String>();
        HashMap<String, TestSuite> testSuiteMap = new HashMap<String, TestSuite>();
        ArrayList<String> mockClassNames = new ArrayList<String>();
        boolean hasTests = TestUtils.createTestSuitesForProject(project, target, testProcessor, testSuiteMap, moduleNamesList, mockClassNames, this.isRerunTestExecution, this.report, this.coverage);
        TestUtils.writeToTestSuiteJson(testSuiteMap, testsCachePath);
        if (hasTests) {
            int testResult;
            try {
                HashSet<String> exclusionClassList = new HashSet<String>();
                testResult = this.runTestSuite(target, project.currentPackage(), jBallerinaBackend, mockClassNames, exclusionClassList);
                this.performPostTestsTasks(project, testsCachePath, jBallerinaBackend, cachesRoot, moduleNamesList, exclusionClassList);
            }
            catch (IOException | ClassNotFoundException | InterruptedException e) {
                TestUtils.cleanTempCache(project, cachesRoot);
                throw LauncherUtils.createLauncherException("error occurred while running tests", e);
            }
            if (testResult != 0) {
                TestUtils.cleanTempCache(project, cachesRoot);
                this.testResult.set(testResult);
            }
        } else {
            this.out.println("\tNo tests found");
            if (!project.buildOptions().testReport() && !this.coverage) {
                return;
            }
            PackageTestResult pkgTestResult = new PackageTestResult();
            pkgTestResult.setProjectName(project.currentPackage().packageName().toString());
            for (Module module : project.currentPackage().modules()) {
                ModuleStatus moduleStatus = new ModuleStatus();
                String moduleName = module.moduleName().toString();
                if (!moduleName.equals(project.currentPackage().packageName().toString())) {
                    moduleName = ModuleName.from((PackageName)project.currentPackage().packageName(), (String)module.moduleName().moduleNamePart()).toString();
                }
                moduleStatus.setName(moduleName);
                pkgTestResult.addModuleStatus(moduleStatus);
            }
            this.testReport.addPackage(pkgTestResult);
            if (this.coverage) {
                this.generateCoverageForNoTests(project, pkgTestResult);
            }
            try {
                TestUtils.generateTesterinaReports(project, pkgTestResult);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("error occurred while generating test report :", e);
            }
        }
    }

    private void runTestsUsingSuiteJSONCache(Project project, Target target, Path testsCachePath, Path cachesRoot) {
        Map<String, TestSuite> testSuiteMap = RunTestsTask.readTestSuiteJson(testsCachePath.resolve("test_suit.json"));
        List<String> moduleNamesList = testSuiteMap.keySet().stream().toList();
        if (!testSuiteMap.isEmpty()) {
            int testResult;
            try {
                testResult = this.runTestSuiteFromCache(target, project.currentPackage(), this.prevTestClassPath);
                this.performPostTestsTasks(project, testsCachePath, null, cachesRoot, moduleNamesList, null);
            }
            catch (IOException | ClassNotFoundException | InterruptedException e) {
                TestUtils.cleanTempCache(project, cachesRoot);
                throw LauncherUtils.createLauncherException("error occurred while running tests", e);
            }
            if (testResult != 0) {
                TestUtils.cleanTempCache(project, cachesRoot);
                throw LauncherUtils.createLauncherException("there are test failures");
            }
            boolean isCoverageMet = true;
            if (this.minCoverage != null && this.coverage && this.testReport.getCoveragePercentage() < this.minCoverage.floatValue()) {
                isCoverageMet = false;
            }
            if (!isCoverageMet) {
                TestUtils.cleanTempCache(project, cachesRoot);
                throw LauncherUtils.createLauncherException("code coverage is below the minimum threshold of " + this.minCoverage + "%, current coverage is " + this.testReport.getCoveragePercentage() + "%");
            }
        } else {
            this.out.println("\tNo tests found");
            if (!project.buildOptions().testReport() && !this.coverage) {
                return;
            }
            PackageTestResult pkgTestResult = new PackageTestResult();
            pkgTestResult.setProjectName(project.currentPackage().packageName().toString());
            for (Module module : project.currentPackage().modules()) {
                ModuleStatus moduleStatus = new ModuleStatus();
                String moduleName = module.moduleName().toString();
                if (!moduleName.equals(project.currentPackage().packageName().toString())) {
                    moduleName = ModuleName.from((PackageName)project.currentPackage().packageName(), (String)module.moduleName().moduleNamePart()).toString();
                }
                moduleStatus.setName(moduleName);
                pkgTestResult.addModuleStatus(moduleStatus);
            }
            this.testReport.addPackage(pkgTestResult);
            if (this.coverage) {
                this.generateCoverageForNoTests(project, pkgTestResult);
            }
            try {
                TestUtils.generateTesterinaReports(project, pkgTestResult);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("error occurred while generating test report :", e);
            }
        }
    }

    private void generateCoverageForNoTests(Project project, PackageTestResult pkgTestResult) {
        Map<String, ModuleCoverage> moduleCoverageMap = TestUtils.initializeCoverageMap(project);
        for (Module module : project.currentPackage().modules()) {
            ModuleCoverage moduleCoverage = moduleCoverageMap.get(module.moduleName().toString());
            module.documentIds().forEach(documentId -> {
                Document document = module.document(documentId);
                if (document.name().endsWith(".bal")) {
                    List lines = document.textDocument().textLines();
                    ArrayList<Integer> missedLines = new ArrayList<Integer>();
                    ArrayList coveredLines = new ArrayList();
                    ArrayList<Integer> emptyLines = new ArrayList<Integer>();
                    HashSet<Integer> allLines = new HashSet<Integer>();
                    for (int i = 0; i < lines.size(); ++i) {
                        int lineNumber = i + 1;
                        String line = ((String)lines.get(i)).trim();
                        if (line.isEmpty() || line.startsWith("//") || line.startsWith("import ") || line.startsWith("#") || line.endsWith("{")) {
                            emptyLines.add(lineNumber);
                        } else {
                            missedLines.add(lineNumber);
                        }
                        allLines.add(lineNumber);
                    }
                    moduleCoverage.addSourceFileCoverage(document, coveredLines, missedLines, emptyLines, allLines);
                }
            });
        }
        for (Map.Entry entry : moduleCoverageMap.entrySet()) {
            String moduleName = (String)entry.getKey();
            ModuleCoverage moduleCoverage = (ModuleCoverage)entry.getValue();
            moduleCoverage.setName(moduleName);
            pkgTestResult.addModuleCoverage(moduleCoverage);
        }
        try {
            TestUtils.generateTesterinaReports(project, pkgTestResult);
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException("error occurred while generating test report :", e);
        }
    }

    private void performPostTestsTasks(Project project, Path testsCachePath, JBallerinaBackend jBallerinaBackend, Path cachesRoot, List<String> moduleNamesList, Set<String> exclusionClassList) throws IOException {
        if (this.report || this.coverage) {
            PackageTestResult pkgTestResult = new PackageTestResult();
            pkgTestResult.setProjectName(project.currentPackage().packageName().toString());
            this.testReport.addPackage(pkgTestResult);
            for (String moduleName : moduleNamesList) {
                ModuleStatus moduleStatus = TestUtils.loadModuleStatusFromFile(testsCachePath.resolve(moduleName).resolve("module_status.json"));
                if (moduleStatus == null) continue;
                if (!moduleName.equals(project.currentPackage().packageName().toString())) {
                    moduleName = ModuleName.from((PackageName)project.currentPackage().packageName(), (String)moduleName).toString();
                    moduleStatus.setName(moduleName);
                } else {
                    moduleStatus.setName(moduleName);
                }
                pkgTestResult.addModuleStatus(moduleStatus);
            }
            try {
                TestUtils.generateCoverage(project, pkgTestResult, jBallerinaBackend, this.includesInCoverage, this.coverageReportFormat, this.coverageModules, exclusionClassList);
                TestUtils.generateTesterinaReports(project, pkgTestResult);
            }
            catch (IOException e) {
                TestUtils.cleanTempCache(project, cachesRoot);
                throw LauncherUtils.createLauncherException("error occurred while generating test report :", e);
            }
        }
    }

    private int runTestSuite(Target target, Package currentPackage, JBallerinaBackend jBallerinaBackend, List<String> mockClassNames, Set<String> exclusionClassList) throws IOException, InterruptedException, ClassNotFoundException {
        String packageName = currentPackage.packageName().toString();
        String orgName = currentPackage.packageOrg().toString();
        String classPath = TestUtils.getClassPath(jBallerinaBackend, currentPackage);
        List<String> cmdArgs = TestUtils.getInitialCmdArgs(null, null);
        if (currentPackage.project().kind().equals((Object)ProjectKind.BUILD_PROJECT)) {
            BuildJson buildJson = ProjectUtils.readBuildJson((Path)target.path().resolve("build"));
            buildJson.setTestClassPath(classPath);
            ProjectUtils.writeBuildFile((Path)target.path().resolve("build"), (BuildJson)buildJson);
        }
        String mainClassName = "org.ballerinalang.test.runtime.BTestMain";
        String jacocoAgentJarPath = TestUtils.getJacocoAgentJarPath();
        if (this.coverage) {
            if (!mockClassNames.isEmpty()) {
                this.jacocoOfflineInstrumentation(target, currentPackage, jBallerinaBackend, mockClassNames);
            }
            String agentCommand = this.getAgentCommand(target, currentPackage, exclusionClassList, jacocoAgentJarPath, packageName, orgName);
            cmdArgs.add(agentCommand);
        }
        cmdArgs.addAll(Lists.of((Object[])new String[]{"-cp", classPath}));
        if (DebugUtils.isInDebugMode()) {
            cmdArgs.add(DebugUtils.getDebugArgs(this.err));
        }
        cmdArgs.add(mainClassName);
        Path testSuiteJsonPath = target.path().resolve("cache").resolve("tests_cache").resolve("test_suit.json");
        TestUtils.appendRequiredArgs(cmdArgs, target.path().toString(), jacocoAgentJarPath, testSuiteJsonPath.toString(), this.report, this.coverage, this.groupList, this.disableGroupList, this.singleExecTests, this.isRerunTestExecution, this.listGroups, this.cliArgs, false, this.isParallelExecution);
        ProcessBuilder processBuilder = new ProcessBuilder(cmdArgs).inheritIO();
        Process proc = processBuilder.start();
        return proc.waitFor();
    }

    private int runTestSuiteFromCache(Target target, Package currentPackage, String classPath) throws IOException, InterruptedException, ClassNotFoundException {
        List<String> cmdArgs = TestUtils.getInitialCmdArgs(null, null);
        String mainClassName = "org.ballerinalang.test.runtime.BTestMain";
        String jacocoAgentJarPath = TestUtils.getJacocoAgentJarPath();
        cmdArgs.addAll(Lists.of((Object[])new String[]{"-cp", classPath}));
        if (DebugUtils.isInDebugMode()) {
            cmdArgs.add(DebugUtils.getDebugArgs(this.err));
        }
        cmdArgs.add(mainClassName);
        Path testSuiteJsonPath = target.path().resolve("cache").resolve("tests_cache").resolve("test_suit.json");
        TestUtils.appendRequiredArgs(cmdArgs, target.path().toString(), jacocoAgentJarPath, testSuiteJsonPath.toString(), this.report, this.coverage, this.groupList, this.disableGroupList, this.singleExecTests, this.isRerunTestExecution, this.listGroups, this.cliArgs, false, this.isParallelExecution);
        ProcessBuilder processBuilder = new ProcessBuilder(cmdArgs).inheritIO();
        Process proc = processBuilder.start();
        return proc.waitFor();
    }

    public void jacocoOfflineInstrumentation(Target target, Package currentPackage, JBallerinaBackend jBallerinaBackend, List<String> mockClassNames) throws IOException, ClassNotFoundException {
        List<URL> jarUrlList = this.getModuleJarUrlList(jBallerinaBackend, currentPackage);
        Path instrumentDir = target.getTestsCachePath().resolve("coverage").resolve("instrumented");
        JacocoInstrumentUtils.instrumentOffline(jarUrlList, (Path)instrumentDir, mockClassNames);
    }

    public String getAgentCommand(Target target, Package currentPackage, Set<String> exclusionClassList, String jacocoAgentJarPath, String packageName, String orgName) throws IOException {
        String agentCommand = "-javaagent:" + jacocoAgentJarPath + "=destfile=" + String.valueOf(target.getTestsCachePath().resolve("coverage").resolve("ballerina.exec"));
        agentCommand = !".".equals(packageName) && this.includesInCoverage == null ? agentCommand + ",includes=" + orgName + ".*" : agentCommand + ",includes=" + this.includesInCoverage;
        if (!".".equals(packageName) && this.excludesInCoverage != null && !this.excludesInCoverage.isEmpty()) {
            ArrayList<String> exclusionSourceList = new ArrayList<String>(List.of(this.excludesInCoverage.split(",")));
            this.getclassFromSourceFilePath(exclusionSourceList, currentPackage, exclusionClassList);
            agentCommand = agentCommand + ",excludes=" + String.join((CharSequence)":", exclusionClassList);
        }
        return agentCommand;
    }

    private List<Path> getAllSourceFilePaths(String projectRootString) throws IOException {
        List<Path> paths;
        ArrayList<Path> sourceFilePaths = new ArrayList<Path>();
        try (Stream<Path> stream = Files.walk(Path.of(projectRootString, new String[0]), 3, new FileVisitOption[0]);){
            paths = stream.toList();
        }
        if (isWindows.booleanValue()) {
            projectRootString = projectRootString.replace(PATH_SEPARATOR, EXCLUDES_PATTERN_PATH_SEPARATOR);
        }
        List<Path> defaultModuleSources = RunTestsTask.filterPathStream(paths.stream(), projectRootString + EXCLUDES_PATTERN_PATH_SEPARATOR + "*.bal");
        List<Path> generatedSources = RunTestsTask.filterPathStream(paths.stream(), projectRootString + EXCLUDES_PATTERN_PATH_SEPARATOR + "generated**.bal");
        List<Path> moduleSources = RunTestsTask.filterPathStream(paths.stream(), projectRootString + EXCLUDES_PATTERN_PATH_SEPARATOR + "modules" + EXCLUDES_PATTERN_PATH_SEPARATOR + "*" + EXCLUDES_PATTERN_PATH_SEPARATOR + "*.bal");
        Stream.of(defaultModuleSources, generatedSources, moduleSources).forEach(sourceFilePaths::addAll);
        return sourceFilePaths;
    }

    private static List<Path> filterPathStream(Stream<Path> pathStream, String combinedPattern) {
        return pathStream.filter(FileSystems.getDefault().getPathMatcher("glob:" + combinedPattern)::matches).toList();
    }

    private void getclassFromSourceFilePath(List<String> sourcePatternList, Package currentPackage, Set<String> classFileList) {
        String sourceRoot = currentPackage.project().sourceRoot().toString();
        try {
            List<Path> allSourceFilePaths = this.getAllSourceFilePaths(sourceRoot);
            List<Path> validSourceFileList = this.extractValidSourceList(allSourceFilePaths, sourcePatternList, sourceRoot);
            for (Path sourceFilePath : validSourceFileList) {
                String sourceFile = sourceFilePath.toAbsolutePath().toString();
                sourceFile = sourceFile.replace(sourceRoot + PATH_SEPARATOR, "");
                String org = currentPackage.packageOrg().toString();
                String packageName = currentPackage.packageName().toString();
                String version = currentPackage.packageVersion().toString();
                if (sourceFile.contains("modules") || sourceFile.contains("generated")) {
                    sourceFile = sourceFile.replace("modules" + PATH_SEPARATOR, "").replace("generated" + PATH_SEPARATOR, "");
                }
                if (sourceFile.split(Pattern.quote(PATH_SEPARATOR)).length == 2) {
                    String moduleName = sourceFile.split(Pattern.quote(PATH_SEPARATOR))[0];
                    String balFile = sourceFile.split(Pattern.quote(PATH_SEPARATOR))[1].replace(".bal", "");
                    String className = TesterinaUtils.getQualifiedClassName((String)org, (String)(packageName + "." + moduleName), (String)version, (String)balFile);
                    classFileList.add(className);
                    continue;
                }
                if (sourceFile.split(Pattern.quote(PATH_SEPARATOR)).length != 1) continue;
                String balFile = sourceFile.split(Pattern.quote(PATH_SEPARATOR))[0].replace(".bal", "");
                String className = TesterinaUtils.getQualifiedClassName((String)org, (String)packageName, (String)version, (String)balFile);
                classFileList.add(className);
            }
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException("unable to resolve classes for given source files.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<Path> extractValidSourceList(List<Path> allSourceFilePaths, List<String> sourcePatternList, String sourceRoot) {
        ArrayList<String> unMatchedPatterns = new ArrayList<String>();
        HashSet<Path> validSourceFileSet = new HashSet<Path>();
        Iterator<String> iterator = sourcePatternList.iterator();
        while (iterator.hasNext()) {
            List<Path> filteredPaths;
            void var7_7;
            void var7_16;
            void var7_12;
            String string;
            String unModifiedSourcePattern = string = iterator.next();
            boolean isIgnoringPattern = false;
            if (string.startsWith("!")) {
                isIgnoringPattern = true;
                String string2 = string.substring(1);
            }
            if (isWindows.booleanValue()) {
                void var7_10;
                String string3 = var7_10.replace(UNIX_PATH_SEPARATOR, PATH_SEPARATOR);
            }
            if (var7_12.startsWith(RELATIVE_PATH_PREFIX)) {
                String string4 = sourceRoot + PATH_SEPARATOR + var7_12.substring(2);
            } else if (var7_12.startsWith(PATH_SEPARATOR) && !var7_12.startsWith(sourceRoot + PATH_SEPARATOR)) {
                String string5 = sourceRoot + PATH_SEPARATOR + var7_12.substring(1);
            } else if (!var7_12.startsWith(sourceRoot + PATH_SEPARATOR)) {
                String string6 = "**" + PATH_SEPARATOR + (String)var7_12;
            }
            if (!var7_16.endsWith("*") && !var7_16.endsWith(".bal")) {
                void var7_18;
                if (!var7_16.endsWith(PATH_SEPARATOR)) {
                    String string7 = (String)var7_16 + PATH_SEPARATOR;
                }
                String string8 = (String)var7_18 + "**";
            }
            if (isWindows.booleanValue()) {
                void var7_20;
                String string9 = var7_20.replace(PATH_SEPARATOR, EXCLUDES_PATTERN_PATH_SEPARATOR);
            }
            if (!isIgnoringPattern) {
                filteredPaths = RunTestsTask.filterPathStream(allSourceFilePaths.stream(), (String)var7_7);
                if (filteredPaths.isEmpty()) {
                    unMatchedPatterns.add(unModifiedSourcePattern);
                    continue;
                }
                validSourceFileSet.addAll(filteredPaths);
                continue;
            }
            filteredPaths = RunTestsTask.filterPathStream(validSourceFileSet.stream(), (String)var7_7);
            if (filteredPaths.isEmpty()) {
                unMatchedPatterns.add(unModifiedSourcePattern);
                continue;
            }
            validSourceFileSet.removeAll(filteredPaths);
        }
        if (!unMatchedPatterns.isEmpty()) {
            this.out.println("WARNING: No matching sources found for " + String.join((CharSequence)", ", unMatchedPatterns));
        }
        return new ArrayList<Path>(validSourceFileSet);
    }

    private List<URL> getModuleJarUrlList(JBallerinaBackend jBallerinaBackend, Package currentPackage) throws MalformedURLException {
        List<Path> moduleJarPaths = TestUtils.getModuleJarPaths(jBallerinaBackend, currentPackage);
        ArrayList<URL> moduleJarUrls = new ArrayList<URL>(moduleJarPaths.size());
        for (Path path : moduleJarPaths) {
            moduleJarUrls.add(path.toUri().toURL());
        }
        return moduleJarUrls;
    }

    private static Map<String, TestSuite> readTestSuiteJson(Path testSuiteJsonPath) {
        Map map;
        block8: {
            BufferedReader bufferedReader = Files.newBufferedReader(testSuiteJsonPath);
            try {
                map = (Map)new Gson().fromJson((Reader)bufferedReader, (TypeToken)new TypeToken<Map<String, TestSuite>>(){});
                if (bufferedReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return new HashMap<String, TestSuite>();
                }
            }
            bufferedReader.close();
        }
        return map;
    }
}

