/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.utils;

import java.io.PrintStream;

public final class DebugUtils {
    private static final String DEBUG_ARGS_JAVA = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y";
    private static final String JAVA_VERSION_PROP = "java.version";
    private static final String COMPATIBLE_JRE_VERSION = "21";

    private DebugUtils() {
    }

    public static boolean isInDebugMode() {
        return System.getProperty("debug") != null && !System.getProperty("debug").isEmpty();
    }

    public static String getDebugArgs(PrintStream errorStream) {
        DebugUtils.validateJavaVersion(errorStream);
        return String.format("%s,address=*:%s", DEBUG_ARGS_JAVA, System.getProperty("debug"));
    }

    public static String getProfileDebugArg(PrintStream errorStream) {
        DebugUtils.validateJavaVersion(errorStream);
        return String.format("%s,address=*:%s", DEBUG_ARGS_JAVA, System.getProperty("profilerDebug"));
    }

    private static void validateJavaVersion(PrintStream errorStream) {
        String javaVersion = System.getProperty(JAVA_VERSION_PROP);
        if (javaVersion != null && !javaVersion.startsWith(COMPATIBLE_JRE_VERSION)) {
            errorStream.printf("WARNING: Incompatible JRE version '%s' found. Ballerina program debugging supports on JRE version '%s'%n", javaVersion, COMPATIBLE_JRE_VERSION);
        }
    }

    public static boolean isInProfileDebugMode() {
        return System.getProperty("profilerDebug") != null && !System.getProperty("profilerDebug").isEmpty();
    }
}

