/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.BalToolsToml;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.internal.BalToolsManifestBuilder;
import io.ballerina.projects.util.BalToolsUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.RepoUtils;

public class ToolUtils {
    private ToolUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<BalToolsManifest.Tool> getToolFromLocalRepo(String toolId, String version) {
        Gson gson = new Gson();
        Path localBalaPath = RepoUtils.createAndGetHomeReposPath().resolve(Path.of("repositories", "local", "bala"));
        Path localToolJsonPath = localBalaPath.resolve("local-tools.json");
        if (!Files.exists(localToolJsonPath, new LinkOption[0])) {
            return Optional.empty();
        }
        try (BufferedReader bufferedReader = Files.newBufferedReader(localToolJsonPath, StandardCharsets.UTF_8);){
            JsonObject localToolJson = (JsonObject)gson.fromJson((Reader)bufferedReader, JsonObject.class);
            JsonElement localTool = localToolJson.get(toolId);
            if (localTool == null) {
                Optional<BalToolsManifest.Tool> optional = Optional.empty();
                return optional;
            }
            JsonObject pkgDesc = localTool.getAsJsonObject();
            if (pkgDesc.isEmpty()) {
                Optional<BalToolsManifest.Tool> optional = Optional.empty();
                return optional;
            }
            String org = pkgDesc.get("org").getAsString();
            String name = pkgDesc.get("name").getAsString();
            BalToolsManifest.Tool tool = new BalToolsManifest.Tool(toolId, org, name, version, Boolean.valueOf(true), "local");
            if (!Files.exists(localBalaPath.resolve(org).resolve(name).resolve(version), new LinkOption[0])) return Optional.empty();
            Optional<BalToolsManifest.Tool> optional = Optional.of(tool);
            return optional;
        }
        catch (IOException e) {
            throw new ProjectException("Failed to read local-tools.json file: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<BalToolsManifest.Tool> getToolAvailableLocally(String toolId, String version, String repository) {
        if (version.equals(Names.EMPTY.getValue())) {
            return Optional.empty();
        }
        BalToolsToml balToolsToml = BalToolsToml.from((Path)BalToolsUtil.BAL_TOOLS_TOML_PATH);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
        Optional toolOptional = balToolsManifest.getTool(toolId, version, repository);
        if (toolOptional.isEmpty()) {
            return Optional.empty();
        }
        BalToolsManifest.Tool tool = (BalToolsManifest.Tool)toolOptional.get();
        Path toolCacheDir = RepoUtils.createAndGetHomeReposPath().resolve("repositories").resolve("central.ballerina.io").resolve("bala").resolve(tool.org()).resolve(tool.name());
        if (!toolCacheDir.toFile().isDirectory()) return Optional.empty();
        try (Stream<Path> versions = Files.list(toolCacheDir);){
            if (!versions.anyMatch(path -> Optional.of(path.getFileName()).get().toString().equals(version))) return Optional.empty();
            Optional optional = toolOptional;
            return optional;
        }
        catch (IOException e) {
            throw new ProjectException("Error while looking for locally available tools: " + String.valueOf(e));
        }
    }
}

