/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mqtt.compiler;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.mqtt.compiler.PluginConstants;
import io.ballerina.stdlib.mqtt.compiler.PluginUtils;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MqttFunctionValidator {
    private final SyntaxNodeAnalysisContext context;
    private final ServiceDeclarationNode serviceDeclarationNode;
    private final SemanticModel semanticModel;
    private final FunctionDefinitionNode onMessage;
    private final FunctionDefinitionNode onError;
    private final FunctionDefinitionNode onComplete;

    public MqttFunctionValidator(SyntaxNodeAnalysisContext context, FunctionDefinitionNode onMessage, FunctionDefinitionNode onError, FunctionDefinitionNode onComplete) {
        this.context = context;
        this.serviceDeclarationNode = (ServiceDeclarationNode)context.node();
        this.onMessage = onMessage;
        this.onError = onError;
        this.onComplete = onComplete;
        this.semanticModel = context.semanticModel();
    }

    public void validate() {
        this.validateMandatoryFunction();
        if (Objects.nonNull(this.onError)) {
            this.validateOnError();
        }
        if (Objects.nonNull(this.onComplete)) {
            this.validateOnComplete();
        }
    }

    private void validateMandatoryFunction() {
        if (Objects.isNull(this.onMessage)) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.NO_ON_MESSAGE, (Location)this.serviceDeclarationNode.location());
            return;
        }
        this.validateOnMessageFunction();
    }

    private void validateOnMessageFunction() {
        if (!PluginUtils.isRemoteFunction(this.context, this.onMessage)) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.FUNCTION_SHOULD_BE_REMOTE, (Location)this.onMessage.location());
        }
        this.validateOnMessageParameters(this.onMessage);
        this.validateReturnTypeErrorOrNil(this.onMessage);
    }

    private void validateOnError() {
        if (!PluginUtils.isRemoteFunction(this.context, this.onError)) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.FUNCTION_SHOULD_BE_REMOTE, (Location)this.onError.location());
        }
        this.validateOnErrorParameters(this.onError);
        this.validateReturnTypeErrorOrNil(this.onError);
    }

    private void validateOnComplete() {
        if (!PluginUtils.isRemoteFunction(this.context, this.onComplete)) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.FUNCTION_SHOULD_BE_REMOTE, (Location)this.onComplete.location());
        }
        this.validateOnCompleteParameters(this.onComplete);
        this.validateReturnTypeErrorOrNil(this.onComplete);
    }

    private void validateOnErrorParameters(FunctionDefinitionNode functionDefinitionNode) {
        SeparatedNodeList parameters = functionDefinitionNode.functionSignature().parameters();
        if (parameters.size() == 1) {
            this.validateErrorParameter((ParameterNode)parameters.get(0));
        } else if (parameters.size() > 1) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_ERROR_PARAM_COUNT, (Location)functionDefinitionNode.functionSignature().location());
        } else {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.MUST_HAVE_ERROR, (Location)functionDefinitionNode.functionSignature().location());
        }
    }

    private void validateOnCompleteParameters(FunctionDefinitionNode functionDefinitionNode) {
        SeparatedNodeList parameters = functionDefinitionNode.functionSignature().parameters();
        if (parameters.size() == 1) {
            this.validateOnCompleteParameter((ParameterNode)parameters.get(0));
        } else if (parameters.size() > 1) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_DELIVERY_TOKEN_PARAM_COUNT, (Location)functionDefinitionNode.functionSignature().location());
        } else {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.MUST_HAVE_DELIVERY_TOKEN, (Location)functionDefinitionNode.functionSignature().location());
        }
    }

    private void validateErrorParameter(ParameterNode parameterNode) {
        SyntaxKind paramSyntaxKind = ((RequiredParameterNode)parameterNode).typeName().kind();
        if (paramSyntaxKind.equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE)) {
            Node parameterTypeNode = ((RequiredParameterNode)parameterNode).typeName();
            Optional paramSymbol = this.semanticModel.symbol(parameterTypeNode);
            if (!((String)((Symbol)paramSymbol.get()).getName().get()).equals("Error") || !PluginUtils.validateModuleId((ModuleSymbol)((Symbol)paramSymbol.get()).getModule().get())) {
                this.reportErrorDiagnostic(PluginConstants.CompilationErrors.ONLY_ERROR_ALLOWED, (Location)parameterNode.location());
            }
        } else if (!paramSyntaxKind.equals((Object)SyntaxKind.ERROR_TYPE_DESC)) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.ONLY_ERROR_ALLOWED, (Location)parameterNode.location());
        }
    }

    private void validateOnCompleteParameter(ParameterNode parameterNode) {
        Node parameterTypeNode;
        Optional symbol;
        SyntaxKind paramSyntaxKind = ((RequiredParameterNode)parameterNode).typeName().kind();
        if (paramSyntaxKind.equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE) && (symbol = this.semanticModel.symbol(parameterTypeNode = ((RequiredParameterNode)parameterNode).typeName())).isPresent() && ((Symbol)symbol.get()).getName().isPresent() && ((String)((Symbol)symbol.get()).getName().get()).equals("DeliveryToken") && ((Symbol)symbol.get()).getModule().isPresent() && PluginUtils.validateModuleId((ModuleSymbol)((Symbol)symbol.get()).getModule().get())) {
            return;
        }
        this.reportErrorDiagnostic(PluginConstants.CompilationErrors.ONLY_DELIVERY_TOKEN_ALLOWED, (Location)parameterNode.location());
    }

    private void validateOnMessageParameters(FunctionDefinitionNode functionDefinitionNode) {
        SeparatedNodeList parameters = functionDefinitionNode.functionSignature().parameters();
        NodeLocation location = functionDefinitionNode.functionSignature().location();
        if (parameters.size() > 2) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_PARAM_COUNT, (Location)location);
            return;
        }
        if (parameters.size() < 1) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.MUST_HAVE_CALLER_AND_MESSAGE, (Location)location);
            return;
        }
        if (parameters.size() == 2) {
            this.validateMessageParam((RequiredParameterNode)parameters.get(0));
            this.validateCallerParam((RequiredParameterNode)parameters.get(1));
        } else {
            this.validateMessageParam((RequiredParameterNode)parameters.get(0));
        }
    }

    private void validateCallerParam(RequiredParameterNode requiredParameterNode) {
        QualifiedNameReferenceNode referenceNode;
        Optional symbol;
        if (requiredParameterNode.typeName().kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE && (symbol = this.semanticModel.symbol((Node)(referenceNode = (QualifiedNameReferenceNode)requiredParameterNode.typeName()))).isPresent() && ((Symbol)symbol.get()).getName().isPresent() && ((String)((Symbol)symbol.get()).getName().get()).equals("Caller") && ((Symbol)symbol.get()).getModule().isPresent() && PluginUtils.validateModuleId((ModuleSymbol)((Symbol)symbol.get()).getModule().get())) {
            return;
        }
        this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_CALLER_PARAMETER, (Location)requiredParameterNode.location());
    }

    private void validateMessageParam(RequiredParameterNode requiredParameterNode) {
        QualifiedNameReferenceNode referenceNode;
        Optional symbol;
        if (requiredParameterNode.typeName().kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE && (symbol = this.semanticModel.symbol((Node)(referenceNode = (QualifiedNameReferenceNode)requiredParameterNode.typeName()))).isPresent() && ((Symbol)symbol.get()).getName().isPresent() && ((String)((Symbol)symbol.get()).getName().get()).equals("Message") && ((Symbol)symbol.get()).getModule().isPresent() && PluginUtils.validateModuleId((ModuleSymbol)((Symbol)symbol.get()).getModule().get())) {
            return;
        }
        this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_MESSAGE_PARAMETER, (Location)requiredParameterNode.location());
    }

    private void validateReturnTypeErrorOrNil(FunctionDefinitionNode functionDefinitionNode) {
        Optional returnTypeDesc;
        MethodSymbol methodSymbol = PluginUtils.getMethodSymbol(this.context, functionDefinitionNode);
        if (methodSymbol != null && (returnTypeDesc = methodSymbol.typeDescriptor().returnTypeDescriptor()).isPresent()) {
            if (((TypeSymbol)returnTypeDesc.get()).typeKind() == TypeDescKind.UNION) {
                List returnTypeMembers = ((UnionTypeSymbol)returnTypeDesc.get()).memberTypeDescriptors();
                for (TypeSymbol returnType : returnTypeMembers) {
                    if (returnType.typeKind() == TypeDescKind.NIL) continue;
                    if (returnType.typeKind() == TypeDescKind.TYPE_REFERENCE) {
                        TypeReferenceTypeSymbol returnTypeSymbol = (TypeReferenceTypeSymbol)returnType;
                        if (returnType.signature().equals("error") || PluginUtils.validateModuleId((ModuleSymbol)returnType.getModule().get()) && returnTypeSymbol.typeDescriptor().typeKind() == TypeDescKind.ERROR) continue;
                        this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_RETURN_TYPE_ERROR_OR_NIL, (Location)returnType.getLocation().get());
                        continue;
                    }
                    if (returnType.typeKind() == TypeDescKind.ERROR) continue;
                    this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_RETURN_TYPE_ERROR_OR_NIL, (Location)returnType.getLocation().get());
                }
            } else if (((TypeSymbol)returnTypeDesc.get()).typeKind() != TypeDescKind.NIL) {
                this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_RETURN_TYPE_ERROR_OR_NIL, (Location)functionDefinitionNode.location());
            }
        }
    }

    public void reportErrorDiagnostic(PluginConstants.CompilationErrors error, Location location) {
        this.context.reportDiagnostic(PluginUtils.getDiagnostic(error, DiagnosticSeverity.ERROR, location));
    }
}

