/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser.tree;

import io.ballerina.toml.internal.parser.tree.STDocumentMemberDeclarationNode;
import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.toml.internal.parser.tree.STNodeTransformer;
import io.ballerina.toml.internal.parser.tree.STNodeVisitor;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STKeyValueNode
extends STDocumentMemberDeclarationNode {
    public final STNode identifier;
    public final STNode assign;
    public final STNode value;

    STKeyValueNode(STNode identifier, STNode assign, STNode value) {
        this(identifier, assign, value, Collections.emptyList());
    }

    STKeyValueNode(STNode identifier, STNode assign, STNode value, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.KEY_VALUE, diagnostics);
        this.identifier = identifier;
        this.assign = assign;
        this.value = value;
        this.addChildren(identifier, assign, value);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STKeyValueNode(this.identifier, this.assign, this.value, diagnostics);
    }

    public STKeyValueNode modify(STNode identifier, STNode assign, STNode value) {
        if (this.checkForReferenceEquality(identifier, assign, value)) {
            return this;
        }
        return new STKeyValueNode(identifier, assign, value, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new KeyValueNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

