/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.commons.types;

import io.ballerina.stdlib.graphql.commons.types.InputValue;
import io.ballerina.stdlib.graphql.commons.types.Position;
import io.ballerina.stdlib.graphql.commons.types.Type;
import io.ballerina.stdlib.graphql.commons.utils.TypeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Field
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private Type type;
    private final boolean isDeprecated;
    private final String deprecationReason;
    private final Position position;
    private final List<InputValue> args;

    public Field(String name, String description) {
        this(name, description, null, false, null, null);
    }

    public Field(String name, Type type) {
        this(name, null, type);
    }

    public Field(String name, String description, Type type) {
        this(name, description, type, false, null, null);
    }

    public Field(String name, String description, boolean isDeprecated, String deprecationReason) {
        this(name, description, null, isDeprecated, deprecationReason, null);
    }

    public Field(String name, String description, Type type, boolean isDeprecated, String deprecationReason, Position position) {
        this.name = TypeUtils.removeEscapeCharacter(name);
        this.description = description;
        this.type = type;
        this.isDeprecated = isDeprecated;
        this.deprecationReason = deprecationReason;
        this.position = position;
        this.args = new ArrayList<InputValue>();
    }

    public String getName() {
        return this.name;
    }

    public void addArg(InputValue inputValue) {
        this.args.add(inputValue);
    }

    public String getDescription() {
        return this.description;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public String getDeprecationReason() {
        return this.deprecationReason;
    }

    public List<InputValue> getArgs() {
        return this.args;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setType(Type type) {
        this.type = type;
    }
}

