/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.ftp.util.FtpConstants;
import io.ballerina.stdlib.ftp.util.FtpUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class ContentByteStreamIteratorUtils {
    public static Object next(BObject recordIterator) {
        InputStream inputStream = (InputStream)recordIterator.getNativeData("Input_Stream");
        BMap streamEntry = ValueCreator.createRecordValue((Module)FtpUtil.getFtpPackage(), (String)"ContentStreamEntry");
        try {
            byte[] buffer = new byte[8192];
            int readNumber = inputStream.read(buffer);
            if (readNumber == -1) {
                inputStream.close();
                recordIterator.set(StringUtils.fromString((String)"isClosed"), (Object)true);
                return null;
            }
            byte[] returnArray = readNumber < 8192 ? Arrays.copyOfRange(buffer, 0, readNumber) : buffer;
            streamEntry.put((Object)FtpConstants.FIELD_VALUE, (Object)ValueCreator.createArrayValue((byte[])returnArray));
        }
        catch (IOException e) {
            streamEntry.put((Object)FtpConstants.FIELD_VALUE, (Object)ErrorCreator.createError((BString)StringUtils.fromString((String)"Unable to parse value")));
        }
        return streamEntry;
    }

    public static Object close(BObject recordIterator) {
        InputStream inputStream = (InputStream)recordIterator.getNativeData("Input_Stream");
        try {
            inputStream.close();
        }
        catch (IOException e) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)"Unable to clean input stream"), (Throwable)e);
        }
        return null;
    }
}

