/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.server;

import io.ballerina.runtime.api.types.AnnotatableType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.ftp.transport.message.FileInfo;
import io.ballerina.stdlib.ftp.util.FtpFileExtensionMapper;
import io.ballerina.stdlib.ftp.util.FtpUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentMethodRouter {
    private static final Logger log = LoggerFactory.getLogger(ContentMethodRouter.class);
    private static final String FUNCTION_CONFIG_ANNOTATION = "FunctionConfig";
    private static final String ANNOTATION_PATTERN_FIELD = "fileNamePattern";
    private final BObject service;
    private final Map<String, MethodType> annotationPatternToMethod;
    private final Map<String, MethodType> availableContentMethods;

    public ContentMethodRouter(BObject service) {
        this.service = service;
        this.annotationPatternToMethod = new HashMap<String, MethodType>();
        this.availableContentMethods = new HashMap<String, MethodType>();
        this.initializeMethodMappings();
    }

    private void initializeMethodMappings() {
        MethodType[] contentMethods;
        for (MethodType method : contentMethods = FtpUtil.getAllContentHandlerMethods(this.service)) {
            BMap<BString, Object> annotation;
            Object patternObj;
            String methodName = method.getName();
            this.availableContentMethods.put(methodName, method);
            Optional<BMap<BString, Object>> annotationOpt = this.getFileConfigAnnotation(method);
            if (!annotationOpt.isPresent() || (patternObj = (annotation = annotationOpt.get()).get((Object)StringUtils.fromString((String)ANNOTATION_PATTERN_FIELD))) == null) continue;
            String pattern = patternObj.toString();
            this.annotationPatternToMethod.put(pattern, method);
            log.debug("Registered annotation pattern '{}' for method '{}'", (Object)pattern, (Object)methodName);
        }
    }

    public Optional<MethodType> routeFile(FileInfo fileInfo) {
        String fileName = fileInfo.getFileName().getBaseName();
        String extension = fileInfo.getFileName().getExtension();
        Optional<MethodType> annotatedMethod = this.findMethodByAnnotationPattern(fileName);
        if (annotatedMethod.isPresent()) {
            log.debug("Routing file '{}' to method '{}' via annotation pattern", (Object)fileName, (Object)annotatedMethod.get().getName());
            return annotatedMethod;
        }
        String recommendedMethod = FtpFileExtensionMapper.getMethodForExtension(extension);
        Optional<MethodType> extensionMethod = Optional.ofNullable(this.availableContentMethods.get(recommendedMethod));
        if (extensionMethod.isPresent()) {
            log.debug("Routing file '{}' with extension '{}' to method '{}'", new Object[]{fileName, extension, recommendedMethod});
            return extensionMethod;
        }
        Optional<MethodType> genericMethod = Optional.ofNullable(this.availableContentMethods.get("onFile"));
        if (genericMethod.isPresent()) {
            log.debug("Routing file '{}' to generic onFile method (fallback)", (Object)fileName);
            return genericMethod;
        }
        log.debug("No content handler found for file '{}', will fall back to onFileChange", (Object)fileName);
        return Optional.empty();
    }

    private Optional<MethodType> findMethodByAnnotationPattern(String fileName) {
        for (Map.Entry<String, MethodType> entry : this.annotationPatternToMethod.entrySet()) {
            String pattern = entry.getKey();
            try {
                if (!Pattern.matches(pattern, fileName)) continue;
                return Optional.of(entry.getValue());
            }
            catch (Exception e) {
                log.warn("Invalid regex pattern '{}' in FileConfig annotation: {}", (Object)pattern, (Object)e.getMessage());
            }
        }
        return Optional.empty();
    }

    private Optional<BMap<BString, Object>> getFileConfigAnnotation(MethodType method) {
        MethodType annotatableMethod;
        BMap annotations;
        if (method instanceof AnnotatableType && (annotations = (annotatableMethod = method).getAnnotations()) != null) {
            for (BString key : (BString[])annotations.getKeys()) {
                Object annotationValue;
                String keyStr = key.getValue();
                if (!keyStr.endsWith(FUNCTION_CONFIG_ANNOTATION) || !((annotationValue = annotations.get((Object)key)) instanceof BMap)) continue;
                return Optional.of((BMap)annotationValue);
            }
        }
        return Optional.empty();
    }

    public boolean hasContentMethods() {
        return !this.availableContentMethods.isEmpty();
    }
}

