/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.server;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.ftp.server.ContentMethodRouter;
import io.ballerina.stdlib.ftp.transport.message.FileInfo;
import io.ballerina.stdlib.ftp.transport.message.RemoteFileSystemEvent;
import io.ballerina.stdlib.ftp.util.FtpContentConverter;
import io.ballerina.stdlib.ftp.util.FtpUtil;
import io.ballerina.stdlib.ftp.util.ModuleUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpContentCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(FtpContentCallbackHandler.class);
    private final Runtime ballerinaRuntime;
    private final FileSystemManager fileSystemManager;
    private final FileSystemOptions fileSystemOptions;

    public FtpContentCallbackHandler(Runtime ballerinaRuntime, FileSystemManager fileSystemManager, FileSystemOptions fileSystemOptions) {
        this.ballerinaRuntime = ballerinaRuntime;
        this.fileSystemManager = fileSystemManager;
        this.fileSystemOptions = fileSystemOptions;
    }

    public void processContentCallbacks(BObject service, RemoteFileSystemEvent event, ContentMethodRouter router, BObject callerObject) {
        List<FileInfo> addedFiles = event.getAddedFiles();
        for (FileInfo fileInfo : addedFiles) {
            try {
                Optional<MethodType> methodTypeOpt = router.routeFile(fileInfo);
                if (methodTypeOpt.isEmpty()) {
                    log.warn("No content handler method found for file: {}. Skipping content processing.", (Object)fileInfo.getPath());
                    continue;
                }
                MethodType methodType = methodTypeOpt.get();
                byte[] fileContent = this.fetchFileContentFromRemote(fileInfo);
                Object convertedContent = this.convertFileContent(fileContent, methodType);
                Object[] methodArguments = this.prepareContentMethodArguments(methodType, convertedContent, fileInfo, callerObject);
                this.invokeContentMethodAsync(service, methodType.getName(), methodArguments);
            }
            catch (Exception exception) {
                log.error("Failed to process file: " + fileInfo.getPath(), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] fetchFileContentFromRemote(FileInfo fileInfo) throws Exception {
        String fileUri = fileInfo.getPath();
        FileObject fileObject = null;
        InputStream inputStream = null;
        try {
            fileObject = this.fileSystemManager.resolveFile(fileUri, this.fileSystemOptions);
            inputStream = fileObject.getContent().getInputStream();
            byte[] byArray = FtpContentConverter.convertInputStreamToByteArray(inputStream);
            return byArray;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    log.warn("Failed to close input stream", (Throwable)e);
                }
            }
            if (fileObject != null) {
                try {
                    fileObject.close();
                }
                catch (Exception e) {
                    log.warn("Failed to close file object", (Throwable)e);
                }
            }
        }
    }

    private Object convertFileContent(byte[] fileContent, MethodType methodType) throws Exception {
        String methodName = methodType.getName();
        Parameter firstParameter = methodType.getParameters()[0];
        Type firstParamType = TypeUtils.getReferredType((Type)firstParameter.type);
        int firstParamTypeTag = firstParamType.getTag();
        switch (methodName) {
            case "onFile": {
                return this.convertOnFileContent(fileContent, firstParamTypeTag);
            }
            case "onFileText": {
                return FtpContentConverter.convertBytesToString(fileContent);
            }
            case "onFileJson": {
                return FtpContentConverter.convertBytesToJson(fileContent, firstParamType);
            }
            case "onFileXml": {
                return FtpContentConverter.convertBytesToXml(fileContent, firstParamType);
            }
            case "onFileCsv": {
                return FtpContentConverter.convertBytesToCsv(fileContent, firstParamType);
            }
        }
        throw new IllegalArgumentException("Unknown content method: " + methodName);
    }

    private Object convertOnFileContent(byte[] fileContent, int firstParamTypeTag) {
        if (firstParamTypeTag == 32) {
            return FtpContentConverter.convertToBallerinaByteArray(fileContent);
        }
        return this.createByteStreamFromContent(fileContent);
    }

    private Object createByteStreamFromContent(byte[] content) {
        try {
            BObject contentByteStreamObject = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"ContentByteStream", (Object[])new Object[]{null, null});
            ByteArrayInputStream inputStream = new ByteArrayInputStream(content);
            contentByteStreamObject.addNativeData("Input_Stream", (Object)inputStream);
            ArrayType byteArrayType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_BYTE);
            StreamType streamType = TypeCreator.createStreamType((Type)byteArrayType, (Type)PredefinedTypes.TYPE_NULL);
            return ValueCreator.createStreamValue((StreamType)streamType, (BObject)contentByteStreamObject);
        }
        catch (Exception e) {
            log.error("Failed to create stream with content", (Throwable)e);
            return ErrorCreator.createError((BString)StringUtils.fromString((String)"Unable to create stream"), (Throwable)e);
        }
    }

    private Object[] prepareContentMethodArguments(MethodType methodType, Object convertedContent, FileInfo fileInfo, BObject callerObject) {
        Parameter[] parameters = methodType.getParameters();
        if (parameters.length == 1) {
            return new Object[]{convertedContent};
        }
        if (parameters.length == 2) {
            int secondParamTypeTag = TypeUtils.getReferredType((Type)parameters[1].type).getTag();
            if (secondParamTypeTag == 24) {
                return new Object[]{convertedContent, this.createFileInfoRecord(fileInfo)};
            }
            if (secondParamTypeTag == 47) {
                return new Object[]{convertedContent, callerObject};
            }
        } else if (parameters.length == 3) {
            return new Object[]{convertedContent, this.createFileInfoRecord(fileInfo), callerObject};
        }
        return new Object[]{convertedContent};
    }

    private BMap<BString, Object> createFileInfoRecord(FileInfo fileInfo) {
        HashMap<String, Object> fileInfoParams = new HashMap<String, Object>();
        fileInfoParams.put("path", fileInfo.getPath());
        fileInfoParams.put("size", fileInfo.getFileSize());
        fileInfoParams.put("lastModifiedTimestamp", fileInfo.getLastModifiedTime());
        fileInfoParams.put("name", fileInfo.getFileName().getBaseName());
        fileInfoParams.put("isFolder", fileInfo.isFolder());
        fileInfoParams.put("isFile", fileInfo.isFile());
        try {
            fileInfoParams.put("pathDecoded", fileInfo.getFileName().getPathDecoded());
        }
        catch (Exception e) {
            fileInfoParams.put("pathDecoded", fileInfo.getPath());
        }
        fileInfoParams.put("extension", fileInfo.getFileName().getExtension());
        fileInfoParams.put("publicURIString", fileInfo.getPublicURIString());
        fileInfoParams.put("fileType", fileInfo.getFileType().getName());
        fileInfoParams.put("isAttached", fileInfo.isAttached());
        fileInfoParams.put("isContentOpen", fileInfo.isContentOpen());
        fileInfoParams.put("isExecutable", fileInfo.isExecutable());
        fileInfoParams.put("isHidden", fileInfo.isHidden());
        fileInfoParams.put("isReadable", fileInfo.isReadable());
        fileInfoParams.put("isWritable", fileInfo.isWritable());
        fileInfoParams.put("depth", fileInfo.getFileName().getDepth());
        fileInfoParams.put("scheme", fileInfo.getFileName().getScheme());
        fileInfoParams.put("uri", fileInfo.getUrl().getPath());
        fileInfoParams.put("rootURI", fileInfo.getFileName().getRootURI());
        fileInfoParams.put("friendlyURI", fileInfo.getFileName().getFriendlyURI());
        return ValueCreator.createRecordValue((Module)new Module("ballerina", "ftp", FtpUtil.getFtpPackage().getMajorVersion()), (String)"FileInfo", fileInfoParams);
    }

    private void invokeContentMethodAsync(BObject service, String methodName, Object[] methodArguments) {
        Thread.startVirtualThread(() -> {
            try {
                ObjectType serviceType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service));
                boolean isConcurrentSafe = serviceType.isIsolated() && serviceType.isIsolated(methodName);
                StrandMetadata strandMetadata = new StrandMetadata(isConcurrentSafe, null);
                Object result = this.ballerinaRuntime.callMethod(service, methodName, strandMetadata, methodArguments);
                if (result instanceof BError) {
                    ((BError)((Object)((Object)result))).printStackTrace();
                }
            }
            catch (BError error) {
                error.printStackTrace();
            }
            catch (Exception exception) {
                log.error("Error invoking content method: " + methodName, (Throwable)exception);
            }
        });
    }
}

