/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.server;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.ftp.exception.RemoteFileSystemConnectorException;
import io.ballerina.stdlib.ftp.server.ContentMethodRouter;
import io.ballerina.stdlib.ftp.server.FtpContentCallbackHandler;
import io.ballerina.stdlib.ftp.transport.listener.RemoteFileSystemListener;
import io.ballerina.stdlib.ftp.transport.message.FileInfo;
import io.ballerina.stdlib.ftp.transport.message.RemoteFileSystemBaseMessage;
import io.ballerina.stdlib.ftp.transport.message.RemoteFileSystemEvent;
import io.ballerina.stdlib.ftp.transport.server.connector.contract.RemoteFileSystemServerConnector;
import io.ballerina.stdlib.ftp.util.FtpUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpListener
implements RemoteFileSystemListener {
    private static final Logger log = LoggerFactory.getLogger(FtpListener.class);
    private final Runtime runtime;
    private Map<String, BObject> registeredServices = new HashMap<String, BObject>();
    private BObject caller;
    private FileSystemManager fileSystemManager;
    private FileSystemOptions fileSystemOptions;

    FtpListener(Runtime runtime) {
        this.runtime = runtime;
    }

    public void setFileSystemManager(FileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
    }

    public void setFileSystemOptions(FileSystemOptions fileSystemOptions) {
        this.fileSystemOptions = fileSystemOptions;
    }

    @Override
    public boolean onMessage(RemoteFileSystemBaseMessage remoteFileSystemBaseMessage) {
        if (remoteFileSystemBaseMessage instanceof RemoteFileSystemEvent) {
            RemoteFileSystemEvent event = (RemoteFileSystemEvent)remoteFileSystemBaseMessage;
            if (this.runtime != null) {
                for (BObject service : this.registeredServices.values()) {
                    Optional<MethodType> onFileChangeMethodType;
                    ContentMethodRouter router = new ContentMethodRouter(service);
                    Optional<MethodType> onFileDeletedMethodType = FtpUtil.getOnFileDeletedMethod(service);
                    if (router.hasContentMethods()) {
                        this.processContentBasedCallbacks(service, event, router);
                        continue;
                    }
                    if (onFileDeletedMethodType.isPresent()) {
                        if (!event.getDeletedFiles().isEmpty()) {
                            this.processFileDeletedCallback(service, event, onFileDeletedMethodType.get());
                        }
                        if (event.getAddedFiles().isEmpty() || !(onFileChangeMethodType = FtpUtil.getOnFileChangeMethod(service)).isPresent()) continue;
                        this.processMetadataOnlyCallbacks(service, event, onFileChangeMethodType.get());
                        continue;
                    }
                    onFileChangeMethodType = FtpUtil.getOnFileChangeMethod(service);
                    if (onFileChangeMethodType.isPresent()) {
                        this.processMetadataOnlyCallbacks(service, event, onFileChangeMethodType.get());
                        continue;
                    }
                    log.error("No valid remote method found in service");
                }
            } else {
                log.error("Runtime should not be null.");
            }
        }
        return true;
    }

    private void processContentBasedCallbacks(BObject service, RemoteFileSystemEvent event, ContentMethodRouter router) {
        if (!event.getAddedFiles().isEmpty()) {
            if (this.fileSystemManager == null || this.fileSystemOptions == null) {
                log.error("FileSystemManager or FileSystemOptions not initialized for content callbacks. Content methods require proper FileSystem initialization. Skipping added files processing.");
            } else {
                try {
                    FtpContentCallbackHandler contentHandler = new FtpContentCallbackHandler(this.runtime, this.fileSystemManager, this.fileSystemOptions);
                    contentHandler.processContentCallbacks(service, event, router, this.caller);
                }
                catch (Exception e) {
                    log.error("Error in content callback processing for added files", (Throwable)e);
                }
            }
        }
        if (!event.getDeletedFiles().isEmpty()) {
            Optional<MethodType> onFileDeletedMethodType = FtpUtil.getOnFileDeletedMethod(service);
            if (onFileDeletedMethodType.isPresent()) {
                this.processFileDeletedCallback(service, event, onFileDeletedMethodType.get());
            } else {
                log.debug("No onFileDeleted method found. Skipping deletion event processing for {} deleted files.", (Object)event.getDeletedFiles().size());
            }
        }
    }

    private void processFileDeletedCallback(BObject service, RemoteFileSystemEvent event, MethodType methodType) {
        List<String> deletedFilesList = event.getDeletedFiles();
        BString[] deletedFilesBStringArray = new BString[deletedFilesList.size()];
        for (int i = 0; i < deletedFilesList.size(); ++i) {
            deletedFilesBStringArray[i] = StringUtils.fromString((String)deletedFilesList.get(i));
        }
        BArray deletedFilesArray = ValueCreator.createArrayValue((BString[])deletedFilesBStringArray);
        Parameter[] params = methodType.getParameters();
        Object[] args = this.getOnFileDeletedMethodArguments(params, deletedFilesArray);
        if (args != null) {
            this.invokeOnFileDeletedAsync(service, args);
        }
    }

    private void processMetadataOnlyCallbacks(BObject service, RemoteFileSystemEvent event, MethodType methodType) {
        Map<String, Object> watchEventParamValues = this.processWatchEventParamValues(event);
        Parameter[] params = methodType.getParameters();
        Object[] args = this.getMethodArguments(params, watchEventParamValues);
        if (args != null) {
            this.invokeMethodAsync(service, args);
        }
    }

    private Object[] getMethodArguments(Parameter[] params, Map<String, Object> watchEventParamValues) {
        if (params.length == 1) {
            return new Object[]{this.getWatchEvent(params[0], watchEventParamValues)};
        }
        if (params.length == 2) {
            if ((params[0].type.isReadOnly() || TypeUtils.getReferredType((Type)params[0].type).getTag() == 24) && TypeUtils.getReferredType((Type)params[1].type).getTag() == 47) {
                return new Object[]{this.getWatchEvent(params[0], watchEventParamValues), this.caller};
            }
            if ((params[1].type.isReadOnly() || TypeUtils.getReferredType((Type)params[1].type).getTag() == 24) && TypeUtils.getReferredType((Type)params[0].type).getTag() == 47) {
                return new Object[]{this.caller, this.getWatchEvent(params[1], watchEventParamValues)};
            }
            log.error("Invalid parameter types in onFileChange method");
        } else {
            log.error("Invalid parameter count in onFileChange method");
        }
        return null;
    }

    private Object[] getOnFileDeletedMethodArguments(Parameter[] params, BArray deletedFiles) {
        if (params.length == 1) {
            return new Object[]{deletedFiles};
        }
        if (params.length == 2) {
            return new Object[]{deletedFiles, this.caller};
        }
        log.error("Invalid parameter count in onFileDeleted method");
        return null;
    }

    private void invokeOnFileDeletedAsync(BObject service, Object ... args) {
        Thread.startVirtualThread(() -> {
            try {
                ObjectType serviceType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service));
                boolean isConcurrentSafe = serviceType.isIsolated() && serviceType.isIsolated("onFileDeleted");
                StrandMetadata strandMetadata = new StrandMetadata(isConcurrentSafe, null);
                Object result = this.runtime.callMethod(service, "onFileDeleted", strandMetadata, args);
                if (result instanceof BError) {
                    ((BError)((Object)((Object)result))).printStackTrace();
                }
            }
            catch (BError error) {
                error.printStackTrace();
            }
        });
    }

    private void invokeMethodAsync(BObject service, Object ... args) {
        Thread.startVirtualThread(() -> {
            try {
                ObjectType serviceType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service));
                boolean isConcurrentSafe = serviceType.isIsolated() && serviceType.isIsolated("onFileChange");
                StrandMetadata strandMetadata = new StrandMetadata(isConcurrentSafe, null);
                Object result = this.runtime.callMethod(service, "onFileChange", strandMetadata, args);
                if (result instanceof BError) {
                    ((BError)((Object)((Object)result))).printStackTrace();
                }
            }
            catch (BError error) {
                error.printStackTrace();
            }
        });
    }

    private BMap<BString, Object> getWatchEvent(Parameter parameter, Map<String, Object> parameters) {
        List addedFileParamList = (List)parameters.get("addedFiles");
        BString[] deletedFileBStringArray = (BString[])parameters.get("deletedFiles");
        Object[] addedFileInfoArray = new Object[addedFileParamList.size()];
        if (this.readonlyWatchEventExists(parameter)) {
            for (int i = 0; i < addedFileParamList.size(); ++i) {
                BMap fileInfo = ValueCreator.createReadonlyRecordValue((Module)new Module("ballerina", "ftp", FtpUtil.getFtpPackage().getMajorVersion()), (String)"FileInfo", (Map)((Map)addedFileParamList.get(i)));
                addedFileInfoArray[i] = fileInfo;
            }
            BArray addedFileInfoBArray = ValueCreator.createArrayValue((Object[])addedFileInfoArray, (ArrayType)TypeCreator.createArrayType((Type)FtpUtil.getFileInfoType(), (boolean)true));
            BArray deletedFileBArray = ValueCreator.createReadonlyArrayValue((BString[])deletedFileBStringArray);
            HashMap<String, BArray> watchEventMap = new HashMap<String, BArray>();
            watchEventMap.put("addedFiles", addedFileInfoBArray);
            watchEventMap.put("deletedFiles", deletedFileBArray);
            return ValueCreator.createReadonlyRecordValue((Module)new Module("ballerina", "ftp", FtpUtil.getFtpPackage().getMajorVersion()), (String)"WatchEvent", watchEventMap);
        }
        for (int i = 0; i < addedFileParamList.size(); ++i) {
            BMap fileInfo = ValueCreator.createRecordValue((Module)new Module("ballerina", "ftp", FtpUtil.getFtpPackage().getMajorVersion()), (String)"FileInfo", (Map)((Map)addedFileParamList.get(i)));
            addedFileInfoArray[i] = fileInfo;
        }
        BArray addedFileInfoBArray = ValueCreator.createArrayValue((Object[])addedFileInfoArray, (ArrayType)TypeCreator.createArrayType((Type)FtpUtil.getFileInfoType(), (boolean)false));
        BArray deletedFileBArray = ValueCreator.createArrayValue((BString[])deletedFileBStringArray);
        HashMap<String, BArray> watchEventMap = new HashMap<String, BArray>();
        watchEventMap.put("addedFiles", addedFileInfoBArray);
        watchEventMap.put("deletedFiles", deletedFileBArray);
        return ValueCreator.createRecordValue((Module)new Module("ballerina", "ftp", FtpUtil.getFtpPackage().getMajorVersion()), (String)"WatchEvent", watchEventMap);
    }

    private boolean readonlyWatchEventExists(Parameter parameter) {
        return parameter.type.isReadOnly() && ((IntersectionType)parameter.type).getEffectiveType().getTag() == 24;
    }

    private Map<String, Object> processWatchEventParamValues(RemoteFileSystemEvent fileSystemEvent) {
        List<FileInfo> addedFileList = fileSystemEvent.getAddedFiles();
        List<String> deletedFileList = fileSystemEvent.getDeletedFiles();
        ArrayList addedFilesParamsList = new ArrayList();
        for (int i = 0; i < addedFileList.size(); ++i) {
            FileInfo info = addedFileList.get(i);
            HashMap<String, Object> fileInfoParams = new HashMap<String, Object>();
            fileInfoParams.put("path", info.getPath());
            fileInfoParams.put("size", info.getFileSize());
            fileInfoParams.put("lastModifiedTimestamp", info.getLastModifiedTime());
            fileInfoParams.put("name", info.getFileName().getBaseName());
            fileInfoParams.put("isFolder", info.isFolder());
            fileInfoParams.put("isFile", info.isFile());
            try {
                fileInfoParams.put("pathDecoded", info.getFileName().getPathDecoded());
            }
            catch (FileSystemException e) {
                fileInfoParams.put("pathDecoded", info.getPath());
            }
            fileInfoParams.put("extension", info.getFileName().getExtension());
            fileInfoParams.put("publicURIString", info.getPublicURIString());
            fileInfoParams.put("fileType", info.getFileType().getName());
            fileInfoParams.put("isAttached", info.isAttached());
            fileInfoParams.put("isContentOpen", info.isContentOpen());
            fileInfoParams.put("isExecutable", info.isExecutable());
            fileInfoParams.put("isHidden", info.isHidden());
            fileInfoParams.put("isReadable", info.isReadable());
            fileInfoParams.put("isWritable", info.isWritable());
            fileInfoParams.put("depth", info.getFileName().getDepth());
            fileInfoParams.put("scheme", info.getFileName().getScheme());
            fileInfoParams.put("uri", info.getUrl().getPath());
            fileInfoParams.put("rootURI", info.getFileName().getRootURI());
            fileInfoParams.put("friendlyURI", info.getFileName().getFriendlyURI());
            addedFilesParamsList.add(fileInfoParams);
        }
        BString[] deletedFilesBstringArray = new BString[deletedFileList.size()];
        for (int i = 0; i < deletedFileList.size(); ++i) {
            deletedFilesBstringArray[i] = StringUtils.fromString((String)deletedFileList.get(i));
        }
        HashMap<String, Object> processedParamMap = new HashMap<String, Object>();
        processedParamMap.put("addedFiles", addedFilesParamsList);
        processedParamMap.put("deletedFiles", deletedFilesBstringArray);
        return processedParamMap;
    }

    @Override
    public void onError(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BError done() {
        Set<Map.Entry<String, BObject>> serviceEntries = this.registeredServices.entrySet();
        for (Map.Entry<String, BObject> serviceEntry : serviceEntries) {
            BObject service = serviceEntry.getValue();
            try {
                RemoteFileSystemServerConnector serverConnector;
                Object stopError;
                Object serverConnectorObject = service.getNativeData("serverConnector");
                if (!(serverConnectorObject instanceof RemoteFileSystemServerConnector) || !((stopError = (serverConnector = (RemoteFileSystemServerConnector)serverConnectorObject).stop()) instanceof BError)) continue;
                BError bError = (BError)((Object)stopError);
                return bError;
            }
            catch (RemoteFileSystemConnectorException e) {
                BError bError = FtpUtil.createError(e.getMessage(), FtpUtil.findRootCause(e), FtpUtil.ErrorType.Error.errorType());
                return bError;
            }
            finally {
                service.addNativeData("serverConnector", null);
            }
        }
        log.debug("Successfully finished the action.");
        return null;
    }

    protected void addService(BObject service) {
        Type serviceType = TypeUtils.getType((Object)service);
        if (service != null && serviceType != null && serviceType.getName() != null) {
            this.registeredServices.put(serviceType.getName(), service);
        }
    }

    public void setCaller(BObject caller) {
        this.caller = caller;
    }

    public BObject getCaller() {
        return this.caller;
    }
}

