/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.util;

import io.ballerina.lib.data.csvdata.csv.Native;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.ftp.util.FtpUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FtpContentConverter {
    private static final Logger log = LoggerFactory.getLogger(FtpContentConverter.class);
    private static final BString ALLOW_DATA_PROJECTION = StringUtils.fromString((String)"allowDataProjection");

    private FtpContentConverter() {
    }

    public static BString convertBytesToString(byte[] content) {
        String textContent = new String(content, StandardCharsets.UTF_8);
        return StringUtils.fromString((String)textContent);
    }

    public static Object convertBytesToJson(byte[] content, Type targetType) {
        try {
            BArray byteArray = ValueCreator.createArrayValue((byte[])content);
            BMap<BString, Object> options = FtpContentConverter.createJsonParseOptions();
            BTypedesc typedesc = ValueCreator.createTypedescValue((Type)targetType);
            Object result = io.ballerina.lib.data.jsondata.json.Native.parseBytes((BArray)byteArray, options, (BTypedesc)typedesc);
            if (result instanceof BError) {
                log.error("Failed to parse JSON content: {}", (Object)((BError)result).getMessage());
                return result;
            }
            return result;
        }
        catch (Exception e) {
            log.error("Error converting bytes to JSON", (Throwable)e);
            return FtpUtil.createError("Failed to parse JSON content: " + e.getMessage(), FtpUtil.ErrorType.Error.errorType());
        }
    }

    public static Object convertBytesToXml(byte[] content, Type targetType) {
        try {
            BArray byteArray = ValueCreator.createArrayValue((byte[])content);
            BMap<BString, Object> options = FtpContentConverter.createXmlParseOptions();
            Type referredType = TypeUtils.getReferredType((Type)targetType);
            BTypedesc typedesc = ValueCreator.createTypedescValue((Type)referredType);
            Object result = io.ballerina.lib.data.xmldata.xml.Native.parseBytes((BArray)byteArray, options, (BTypedesc)typedesc);
            if (result instanceof BError) {
                log.error("Failed to parse XML content: {}", (Object)((BError)result).getMessage());
                return result;
            }
            return result;
        }
        catch (Exception e) {
            log.error("Error converting bytes to XML", (Throwable)e);
            return FtpUtil.createError("Failed to parse XML content: " + e.getMessage(), FtpUtil.ErrorType.Error.errorType());
        }
    }

    public static Object convertBytesToCsv(byte[] content, Type targetType) {
        try {
            BArray byteArray = ValueCreator.createArrayValue((byte[])content);
            BMap<BString, Object> options = FtpContentConverter.createCsvParseOptions();
            Type referredType = TypeUtils.getReferredType((Type)targetType);
            BTypedesc typedesc = ValueCreator.createTypedescValue((Type)referredType);
            Object result = Native.parseBytes((BArray)byteArray, options, (BTypedesc)typedesc);
            if (result instanceof BError) {
                log.error("Failed to parse CSV content: {}", (Object)((BError)result).getMessage());
                return result;
            }
            return result;
        }
        catch (Exception e) {
            log.error("Error converting bytes to CSV", (Throwable)e);
            return FtpUtil.createError("Failed to parse CSV content: " + e.getMessage(), FtpUtil.ErrorType.Error.errorType());
        }
    }

    private static BMap<BString, Object> createJsonParseOptions() {
        BMap options = ValueCreator.createMapValue();
        options.put((Object)ALLOW_DATA_PROJECTION, (Object)true);
        return options;
    }

    private static BMap<BString, Object> createXmlParseOptions() {
        BMap options = ValueCreator.createMapValue();
        options.put((Object)ALLOW_DATA_PROJECTION, (Object)true);
        return options;
    }

    private static BMap<BString, Object> createCsvParseOptions() {
        BMap options = ValueCreator.createMapValue();
        options.put((Object)ALLOW_DATA_PROJECTION, (Object)true);
        return options;
    }

    public static byte[] convertInputStreamToByteArray(InputStream inputStream) throws Exception {
        int bytesRead;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        return outputStream.toByteArray();
    }

    public static BArray convertToBallerinaByteArray(byte[] content) {
        return ValueCreator.createArrayValue((byte[])content);
    }
}

