/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.util;

import java.util.HashMap;
import java.util.Map;

public final class FtpFileExtensionMapper {
    private static final Map<String, String> EXTENSION_TO_METHOD_MAP = new HashMap<String, String>();

    private FtpFileExtensionMapper() {
    }

    public static String getMethodForExtension(String extension) {
        if (extension == null || extension.isEmpty()) {
            return "onFile";
        }
        String normalizedExtension = extension.toLowerCase();
        return EXTENSION_TO_METHOD_MAP.getOrDefault(normalizedExtension, "onFile");
    }

    public static boolean hasMapping(String extension) {
        if (extension == null || extension.isEmpty()) {
            return false;
        }
        return EXTENSION_TO_METHOD_MAP.containsKey(extension.toLowerCase());
    }

    static {
        EXTENSION_TO_METHOD_MAP.put("json", "onFileJson");
        EXTENSION_TO_METHOD_MAP.put("xml", "onFileXml");
        EXTENSION_TO_METHOD_MAP.put("csv", "onFileCsv");
        EXTENSION_TO_METHOD_MAP.put("txt", "onFileText");
        EXTENSION_TO_METHOD_MAP.put("log", "onFileText");
        EXTENSION_TO_METHOD_MAP.put("md", "onFileText");
    }
}

