/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mcp.plugin;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.plugins.ModifierTask;
import io.ballerina.projects.plugins.SourceModifierContext;
import io.ballerina.stdlib.mcp.plugin.ModifierContext;
import io.ballerina.stdlib.mcp.plugin.ToolAnnotationConfig;
import io.ballerina.stdlib.mcp.plugin.Utils;
import io.ballerina.tools.text.TextDocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class McpSourceModifier
implements ModifierTask<SourceModifierContext> {
    private final Map<DocumentId, ModifierContext> modifierContextMap;

    McpSourceModifier(Map<DocumentId, ModifierContext> modifierContextMap) {
        this.modifierContextMap = modifierContextMap;
    }

    public void modify(SourceModifierContext context) {
        for (Map.Entry<DocumentId, ModifierContext> entry : this.modifierContextMap.entrySet()) {
            this.modifyDocumentWithTools(context, entry.getKey(), entry.getValue());
        }
    }

    private void modifyDocumentWithTools(SourceModifierContext context, DocumentId documentId, ModifierContext modifierContext) {
        Module module = context.currentPackage().module(documentId.moduleId());
        SemanticModel semanticModel = context.compilation().getSemanticModel(documentId.moduleId());
        ModulePartNode rootNode = (ModulePartNode)module.document(documentId).syntaxTree().rootNode();
        ModulePartNode updatedRoot = this.modifyModulePartRoot(semanticModel, rootNode, modifierContext, documentId);
        this.updateDocument(context, module, documentId, updatedRoot);
    }

    private ModulePartNode modifyModulePartRoot(SemanticModel semanticModel, ModulePartNode modulePartNode, ModifierContext modifierContext, DocumentId documentId) {
        List<ModuleMemberDeclarationNode> modifiedMembers = this.getModifiedModuleMembers(semanticModel, (NodeList<ModuleMemberDeclarationNode>)modulePartNode.members(), modifierContext);
        return modulePartNode.modify().withMembers(NodeFactory.createNodeList(modifiedMembers)).apply();
    }

    private List<ModuleMemberDeclarationNode> getModifiedModuleMembers(SemanticModel semanticModel, NodeList<ModuleMemberDeclarationNode> members, ModifierContext modifierContext) {
        Map<FunctionDefinitionNode, AnnotationNode> modifiedAnnotations = this.getModifiedAnnotations(modifierContext);
        ArrayList<ModuleMemberDeclarationNode> modifiedMembers = new ArrayList<ModuleMemberDeclarationNode>();
        for (ModuleMemberDeclarationNode member : members) {
            modifiedMembers.add(this.getModifiedModuleMember(semanticModel, member, modifiedAnnotations));
        }
        return modifiedMembers;
    }

    private Map<FunctionDefinitionNode, AnnotationNode> getModifiedAnnotations(ModifierContext modifierContext) {
        HashMap<FunctionDefinitionNode, AnnotationNode> updatedAnnotationMap = new HashMap<FunctionDefinitionNode, AnnotationNode>();
        for (Map.Entry<FunctionDefinitionNode, ToolAnnotationConfig> entry : modifierContext.getAnnotationConfigMap().entrySet()) {
            updatedAnnotationMap.put(entry.getKey(), this.getModifiedAnnotation(entry.getValue()));
        }
        return updatedAnnotationMap;
    }

    private AnnotationNode getModifiedAnnotation(ToolAnnotationConfig config) {
        String mappingConstructorExpression = this.generateConfigMappingConstructor(config);
        String annotationString = "@mcp:Tool" + mappingConstructorExpression;
        return NodeParser.parseAnnotation((String)annotationString);
    }

    private String generateConfigMappingConstructor(ToolAnnotationConfig config) {
        return this.generateConfigMappingConstructor(config, SyntaxKind.OPEN_BRACE_TOKEN.stringValue(), SyntaxKind.CLOSE_BRACE_TOKEN.stringValue());
    }

    private String generateConfigMappingConstructor(ToolAnnotationConfig config, String openBraceSource, String closeBraceSource) {
        StringBuilder sb = new StringBuilder();
        sb.append(openBraceSource);
        String desc = config.description().replaceAll("\\R", " ");
        sb.append("description:").append(desc).append(",");
        sb.append("schema:").append(config.schema());
        sb.append(closeBraceSource);
        return sb.toString();
    }

    private ModuleMemberDeclarationNode getModifiedModuleMember(SemanticModel semanticModel, ModuleMemberDeclarationNode member, Map<FunctionDefinitionNode, AnnotationNode> modifiedAnnotations) {
        if (member.kind() == SyntaxKind.SERVICE_DECLARATION) {
            return this.modifyServiceDeclaration(semanticModel, (ServiceDeclarationNode)member, modifiedAnnotations);
        }
        return member;
    }

    private ModuleMemberDeclarationNode modifyServiceDeclaration(SemanticModel semanticModel, ServiceDeclarationNode classDefinitionNode, Map<FunctionDefinitionNode, AnnotationNode> modifiedAnnotations) {
        NodeList members = classDefinitionNode.members();
        ArrayList<Object> modifiedMembers = new ArrayList<Object>();
        for (Node member : members) {
            if (member.kind() != SyntaxKind.OBJECT_METHOD_DEFINITION) {
                modifiedMembers.add(member);
                continue;
            }
            FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)member;
            AnnotationNode modifiedAnnotationNode = modifiedAnnotations.get(functionDefinitionNode);
            if (modifiedAnnotationNode == null) continue;
            MetadataNode newMetadata = this.createOrUpdateMetadata(semanticModel, functionDefinitionNode, modifiedAnnotationNode);
            FunctionDefinitionNode updatedFunction = functionDefinitionNode.modify().withMetadata(newMetadata).apply();
            modifiedMembers.add(updatedFunction);
        }
        return classDefinitionNode.modify().withMembers(NodeFactory.createNodeList(modifiedMembers)).apply();
    }

    private MetadataNode createOrUpdateMetadata(SemanticModel semanticModel, FunctionDefinitionNode functionDefinitionNode, AnnotationNode modifiedAnnotationNode) {
        if (functionDefinitionNode.metadata().isEmpty()) {
            return this.createMetadata(modifiedAnnotationNode);
        }
        MetadataNode existingMetadata = (MetadataNode)functionDefinitionNode.metadata().get();
        Optional<AnnotationNode> toolAnnotationNode = Utils.getToolAnnotationNode(semanticModel, functionDefinitionNode);
        if (toolAnnotationNode.isPresent()) {
            return this.modifyMetadata(existingMetadata, toolAnnotationNode.get(), modifiedAnnotationNode);
        }
        return this.modifyWithToolAnnotation(existingMetadata, modifiedAnnotationNode);
    }

    private MetadataNode modifyWithToolAnnotation(MetadataNode metadata, AnnotationNode annotationNode) {
        ArrayList<AnnotationNode> updatedAnnotations = new ArrayList<AnnotationNode>();
        metadata.annotations().forEach(updatedAnnotations::add);
        updatedAnnotations.add(annotationNode);
        return metadata.modify().withAnnotations(NodeFactory.createNodeList(updatedAnnotations)).apply();
    }

    private MetadataNode modifyMetadata(MetadataNode metadata, AnnotationNode toolAnnotationNode, AnnotationNode modifiedAnnotationNode) {
        ArrayList<AnnotationNode> updatedAnnotations = new ArrayList<AnnotationNode>();
        for (AnnotationNode annotation : metadata.annotations()) {
            if (annotation.equals(toolAnnotationNode)) {
                updatedAnnotations.add(modifiedAnnotationNode);
                continue;
            }
            updatedAnnotations.add(annotation);
        }
        return metadata.modify().withAnnotations(NodeFactory.createNodeList(updatedAnnotations)).apply();
    }

    private MetadataNode createMetadata(AnnotationNode annotationNode) {
        NodeList annotationNodeList = NodeFactory.createNodeList((Node[])new AnnotationNode[]{annotationNode});
        return NodeFactory.createMetadataNode(null, (NodeList)annotationNodeList);
    }

    private void updateDocument(SourceModifierContext context, Module module, DocumentId documentId, ModulePartNode updatedRoot) {
        SyntaxTree syntaxTree = module.document(documentId).syntaxTree().modifyWith((Node)updatedRoot);
        TextDocument textDocument = syntaxTree.textDocument();
        if (module.documentIds().contains(documentId)) {
            context.modifySourceFile(textDocument, documentId);
        } else {
            context.modifyTestSourceFile(textDocument, documentId);
        }
    }
}

