/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mcp.plugin;

import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.mcp.plugin.ModifierContext;
import io.ballerina.stdlib.mcp.plugin.SchemaUtils;
import io.ballerina.stdlib.mcp.plugin.ToolAnnotationConfig;
import io.ballerina.stdlib.mcp.plugin.Utils;
import io.ballerina.stdlib.mcp.plugin.diagnostics.CompilationDiagnostic;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.Location;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class RemoteFunctionAnalysisTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    public static final String EMPTY_STRING = "";
    public static final String NIL_EXPRESSION = "()";
    private final Map<DocumentId, ModifierContext> modifierContextMap;
    private SyntaxNodeAnalysisContext context;

    RemoteFunctionAnalysisTask(Map<DocumentId, ModifierContext> modifierContextMap) {
        this.modifierContextMap = modifierContextMap;
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        this.context = context;
        FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)context.node();
        if (!Utils.isMcpServiceFunction(context.semanticModel(), functionDefinitionNode)) {
            return;
        }
        Optional<FunctionSymbol> functionSymbol = this.getFunctionSymbol(functionDefinitionNode);
        if (functionSymbol.isEmpty()) {
            return;
        }
        if (!Utils.validateParameterTypes(functionSymbol.get(), functionDefinitionNode, context)) {
            return;
        }
        AnnotationNode toolAnnotationNode = Utils.getToolAnnotationNode(context.semanticModel(), functionDefinitionNode).orElse(null);
        NodeLocation functionNodeLocation = functionDefinitionNode.location();
        ToolAnnotationConfig config = this.createAnnotationConfig(functionSymbol.get(), functionNodeLocation, toolAnnotationNode);
        this.addToModifierContext(context, functionDefinitionNode, config);
    }

    private ToolAnnotationConfig createAnnotationConfig(FunctionSymbol functionSymbol, NodeLocation functionNodeLocation, AnnotationNode annotationNode) {
        String functionName = functionSymbol.getName().orElse("unknownFunction");
        String description = Utils.addDoubleQuotes(Utils.escapeDoubleQuotes(Objects.requireNonNullElse(Utils.getDescription((Documentable)functionSymbol), functionName)));
        if (annotationNode == null) {
            String schema = this.getParameterSchema(functionSymbol, (Location)functionNodeLocation);
            return new ToolAnnotationConfig(description, schema);
        }
        SeparatedNodeList fields = annotationNode.annotValue().isEmpty() ? NodeFactory.createSeparatedNodeList((Node[])new Node[0]) : ((MappingConstructorExpressionNode)annotationNode.annotValue().get()).fields();
        Map<String, ExpressionNode> fieldValues = this.extractFieldValues((SeparatedNodeList<MappingFieldNode>)fields);
        if (fieldValues.containsKey("description")) {
            description = fieldValues.get("description").toSourceCode();
        }
        String parameters = fieldValues.containsKey("schema") ? fieldValues.get("schema").toSourceCode() : this.getParameterSchema(functionSymbol, (Location)functionNodeLocation);
        return new ToolAnnotationConfig(description, parameters);
    }

    private Optional<FunctionSymbol> getFunctionSymbol(FunctionDefinitionNode functionDefinitionNode) {
        Optional functionSymbol = this.context.semanticModel().symbol((Node)functionDefinitionNode);
        return functionSymbol.filter(symbol -> symbol.kind() == SymbolKind.FUNCTION || symbol.kind() == SymbolKind.METHOD).map(FunctionSymbol.class::cast);
    }

    private Map<String, ExpressionNode> extractFieldValues(SeparatedNodeList<MappingFieldNode> fields) {
        return fields.stream().filter(field -> field.kind() == SyntaxKind.SPECIFIC_FIELD).map(field -> (SpecificFieldNode)field).filter(field -> field.valueExpr().isPresent()).collect(Collectors.toMap(field -> field.fieldName().toSourceCode().trim(), field -> field.valueExpr().orElse(NodeParser.parseExpression((String)NIL_EXPRESSION))));
    }

    private String getParameterSchema(FunctionSymbol functionSymbol, Location alternativeFunctionLocation) {
        try {
            return SchemaUtils.getParameterSchema(functionSymbol, this.context);
        }
        catch (Exception e) {
            Diagnostic diagnostic = CompilationDiagnostic.getDiagnostic(CompilationDiagnostic.UNABLE_TO_GENERATE_SCHEMA_FOR_FUNCTION, functionSymbol.getLocation().orElse(alternativeFunctionLocation), functionSymbol.getName().orElse("unknownFunction"));
            this.reportDiagnostic(diagnostic);
            return NIL_EXPRESSION;
        }
    }

    private void reportDiagnostic(Diagnostic diagnostic) {
        this.context.reportDiagnostic(diagnostic);
    }

    private void addToModifierContext(SyntaxNodeAnalysisContext context, FunctionDefinitionNode functionDefinitionNode, ToolAnnotationConfig toolAnnotationConfig) {
        this.modifierContextMap.computeIfAbsent(context.documentId(), document -> new ModifierContext()).add(functionDefinitionNode, toolAnnotationConfig);
    }
}

