/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mcp.plugin.diagnostics;

import io.ballerina.stdlib.mcp.plugin.diagnostics.DiagnosticCode;
import io.ballerina.stdlib.mcp.plugin.diagnostics.DiagnosticMessage;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;

public enum CompilationDiagnostic {
    UNABLE_TO_GENERATE_SCHEMA_FOR_FUNCTION(DiagnosticMessage.ERROR_101, DiagnosticCode.MCP_101, DiagnosticSeverity.ERROR),
    INVALID_PARAMETER_TYPE(DiagnosticMessage.ERROR_102, DiagnosticCode.MCP_102, DiagnosticSeverity.ERROR),
    SESSION_PARAM_MUST_BE_FIRST(DiagnosticMessage.ERROR_103, DiagnosticCode.MCP_103, DiagnosticSeverity.ERROR),
    SESSION_PARAM_NOT_ALLOWED_IN_STATELESS_MODE(DiagnosticMessage.ERROR_104, DiagnosticCode.MCP_104, DiagnosticSeverity.ERROR);

    private final String diagnostic;
    private final String diagnosticCode;
    private final DiagnosticSeverity diagnosticSeverity;

    private CompilationDiagnostic(DiagnosticMessage message, DiagnosticCode diagnosticCode, DiagnosticSeverity diagnosticSeverity) {
        this.diagnostic = message.getMessage();
        this.diagnosticCode = diagnosticCode.name();
        this.diagnosticSeverity = diagnosticSeverity;
    }

    public static Diagnostic getDiagnostic(CompilationDiagnostic compilationDiagnostic, Location location, Object ... args) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(compilationDiagnostic.getDiagnosticCode(), compilationDiagnostic.getDiagnostic(), compilationDiagnostic.getDiagnosticSeverity());
        return DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])args);
    }

    public String getDiagnostic() {
        return this.diagnostic;
    }

    public String getDiagnosticCode() {
        return this.diagnosticCode;
    }

    public DiagnosticSeverity getDiagnosticSeverity() {
        return this.diagnosticSeverity;
    }
}

