/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.file.service;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.file.utils.ModuleUtils;
import java.util.HashMap;
import java.util.Map;
import org.wso2.transport.localfilesystem.server.connector.contract.LocalFileSystemEvent;
import org.wso2.transport.localfilesystem.server.connector.contract.LocalFileSystemListener;

public class FSListener
implements LocalFileSystemListener {
    private Runtime runtime;
    private Map<BObject, Map<String, MethodType>> serviceRegistry = new HashMap<BObject, Map<String, MethodType>>();

    public FSListener(Runtime runtime) {
        this.runtime = runtime;
    }

    public void onMessage(LocalFileSystemEvent fileEvent) {
        Thread.startVirtualThread(() -> {
            Object balFileEvent = this.createBallerinaFileEvent(fileEvent);
            for (Map.Entry<BObject, Map<String, MethodType>> serviceEntry : this.serviceRegistry.entrySet()) {
                MethodType serviceFunction = serviceEntry.getValue().get(fileEvent.getEvent());
                if (serviceFunction == null) continue;
                String functionName = serviceFunction.getName();
                BObject service = serviceEntry.getKey();
                ObjectType type = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service));
                boolean isConcurrentSafe = type.isIsolated() && type.isIsolated(functionName);
                this.runtime.callMethod(service, functionName, new StrandMetadata(isConcurrentSafe, null), new Object[]{balFileEvent});
            }
        });
    }

    private Object createBallerinaFileEvent(LocalFileSystemEvent fileEvent) {
        BMap eventStruct = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"FileEvent");
        eventStruct.put((Object)StringUtils.fromString((String)"name"), (Object)StringUtils.fromString((String)fileEvent.getFileName()));
        eventStruct.put((Object)StringUtils.fromString((String)"operation"), (Object)StringUtils.fromString((String)fileEvent.getEvent()));
        return eventStruct;
    }

    public void addService(BObject service, Map<String, MethodType> attachedFunctions) {
        this.serviceRegistry.put(service, attachedFunctions);
    }

    public void removeService(BObject service) {
        this.serviceRegistry.remove(service);
    }
}

