/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.formatter.core.options;

import org.ballerinalang.formatter.core.FormatterException;

public enum FormatSection {
    BRACES("braces"),
    FUNCTION_CALL("functionCall"),
    FUNCTION_DEFINITION("functionDefinition"),
    IF_STATEMENT("ifStatement"),
    IMPORT("import"),
    INDENT("indent"),
    QUERY("query"),
    SPACING("spacing"),
    WRAPPING("wrapping");

    private final String val;

    private FormatSection(String val) {
        this.val = val;
    }

    public String getStringValue() {
        return this.val;
    }

    public static FormatSection fromString(String value) throws FormatterException {
        for (FormatSection section : FormatSection.values()) {
            if (!section.val.equals(value)) continue;
            return section;
        }
        throw new FormatterException("invalid format section: " + value);
    }
}

