/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.formatter.core.options;

import java.util.Map;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.formatter.core.FormatterUtils;
import org.ballerinalang.formatter.core.options.FormatSection;
import org.ballerinalang.formatter.core.options.WrappingMethod;

public class FunctionDefFormattingOptions {
    private final WrappingMethod parametersWrap;
    private final boolean alignMultilineParameters;
    private final boolean newLineAfterLeftParen;
    private final boolean rightParenOnNewLine;

    private FunctionDefFormattingOptions(WrappingMethod parametersWrap, boolean alignMultilineParameters, boolean newLineAfterLeftParen, boolean rightParenOnNewLine) {
        this.parametersWrap = parametersWrap;
        this.alignMultilineParameters = alignMultilineParameters;
        this.newLineAfterLeftParen = newLineAfterLeftParen;
        this.rightParenOnNewLine = rightParenOnNewLine;
    }

    public WrappingMethod parametersWrap() {
        return this.parametersWrap;
    }

    public boolean alignMultilineParameters() {
        return this.alignMultilineParameters;
    }

    public boolean newLineAfterLeftParen() {
        return this.newLineAfterLeftParen;
    }

    public boolean rightParenOnNewLine() {
        return this.rightParenOnNewLine;
    }

    public static FunctionDefFormattingOptionsBuilder builder() {
        return new FunctionDefFormattingOptionsBuilder();
    }

    public static class FunctionDefFormattingOptionsBuilder {
        private static final String PARAMETERS_WRAP = "parametersWrap";
        private static final String ALIGN_MULTILINE_PARAMETERS = "alignMultilineParameters";
        private static final String NEWLINE_AFTER_LEFT_PAREN = "newLineAfterLeftParen";
        private static final String RIGHT_PAREN_ON_NEWLINE = "rightParenOnNewLine";
        private WrappingMethod parametersWrap = WrappingMethod.valueOf(FormatterUtils.getDefaultString(FormatSection.FUNCTION_DEFINITION, "parametersWrap"));
        private boolean alignMultilineParameters = FormatterUtils.getDefaultBoolean(FormatSection.FUNCTION_DEFINITION, "alignMultilineParameters");
        private boolean newLineAfterLeftParen = FormatterUtils.getDefaultBoolean(FormatSection.FUNCTION_DEFINITION, "newLineAfterLeftParen");
        private boolean rightParenOnNewLine = FormatterUtils.getDefaultBoolean(FormatSection.FUNCTION_DEFINITION, "rightParenOnNewLine");

        public FunctionDefFormattingOptionsBuilder setParametersWrap(WrappingMethod parametersWrap) {
            this.parametersWrap = parametersWrap;
            return this;
        }

        public FunctionDefFormattingOptionsBuilder setAlignMultilineParameters(boolean alignMultilineParameters) {
            this.alignMultilineParameters = alignMultilineParameters;
            return this;
        }

        public FunctionDefFormattingOptionsBuilder setNewLineAfterLeftParen(boolean newLineAfterLeftParen) {
            this.newLineAfterLeftParen = newLineAfterLeftParen;
            return this;
        }

        public FunctionDefFormattingOptionsBuilder setRightParenOnNewLine(boolean rightParenOnNewLine) {
            this.rightParenOnNewLine = rightParenOnNewLine;
            return this;
        }

        public FunctionDefFormattingOptions build() {
            return new FunctionDefFormattingOptions(this.parametersWrap, this.alignMultilineParameters, this.newLineAfterLeftParen, this.rightParenOnNewLine);
        }

        public FunctionDefFormattingOptions build(Map<String, Object> configs) throws FormatterException {
            block12: for (Map.Entry<String, Object> functionDefinitionEntry : configs.entrySet()) {
                String functionDefinitionKey;
                switch (functionDefinitionKey = functionDefinitionEntry.getKey()) {
                    case "parametersWrap": {
                        this.setParametersWrap(WrappingMethod.fromString((String)functionDefinitionEntry.getValue()));
                        continue block12;
                    }
                    case "alignMultilineParameters": {
                        this.setAlignMultilineParameters((Boolean)functionDefinitionEntry.getValue());
                        continue block12;
                    }
                    case "newLineAfterLeftParen": {
                        this.setNewLineAfterLeftParen((Boolean)functionDefinitionEntry.getValue());
                        continue block12;
                    }
                    case "rightParenOnNewLine": {
                        this.setRightParenOnNewLine((Boolean)functionDefinitionEntry.getValue());
                        continue block12;
                    }
                }
                throw new FormatterException("invalid function definition formatting option: " + functionDefinitionKey);
            }
            return this.build();
        }
    }
}

