/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.formatter.core.options;

import java.util.Map;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.formatter.core.FormatterUtils;
import org.ballerinalang.formatter.core.options.FormatSection;

public class IndentFormattingOptions {
    private final int indentSize;
    private final int continuationIndentSize;
    private final String wsCharacter;

    private IndentFormattingOptions(int indentSize, int continuationIndentSize, String wsCharacter) {
        this.indentSize = indentSize;
        this.continuationIndentSize = continuationIndentSize;
        this.wsCharacter = wsCharacter;
    }

    public int indentSize() {
        return this.indentSize;
    }

    public String wsCharacter() {
        return this.wsCharacter;
    }

    public int continuationIndentSize() {
        return this.continuationIndentSize;
    }

    public static IndentFormattingOptionsBuilder builder() {
        return new IndentFormattingOptionsBuilder();
    }

    public static class IndentFormattingOptionsBuilder {
        private static final String INDENT_SIZE = "indentSize";
        private static final String CONTINUATION_INDENT_SIZE = "continuationIndentSize";
        private int indentSize = FormatterUtils.getDefaultInt(FormatSection.INDENT, "indentSize");
        private int continuationIndentSize = FormatterUtils.getDefaultInt(FormatSection.INDENT, "continuationIndentSize");
        private static final String WS_CHARACTER = " ";

        public IndentFormattingOptionsBuilder setIndentSize(int indentSize) {
            this.indentSize = indentSize;
            return this;
        }

        public IndentFormattingOptionsBuilder setContinuationIndentSize(int continuationIndentSize) {
            this.continuationIndentSize = continuationIndentSize;
            return this;
        }

        public IndentFormattingOptions build() {
            return new IndentFormattingOptions(this.indentSize, this.continuationIndentSize, WS_CHARACTER);
        }

        public IndentFormattingOptions build(Map<String, Object> configs) throws FormatterException {
            block8: for (Map.Entry<String, Object> indentEntry : configs.entrySet()) {
                String indentKey;
                switch (indentKey = indentEntry.getKey()) {
                    case "indentSize": {
                        this.setIndentSize(((Number)indentEntry.getValue()).intValue());
                        continue block8;
                    }
                    case "continuationIndentSize": {
                        this.setContinuationIndentSize(((Number)indentEntry.getValue()).intValue());
                        continue block8;
                    }
                }
                throw new FormatterException("invalid indent formatting option: " + indentKey);
            }
            return this.build();
        }
    }
}

