/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.formatter.core.options;

import java.util.Map;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.formatter.core.FormatterUtils;
import org.ballerinalang.formatter.core.options.FormatSection;

public class WrappingFormattingOptions {
    private final int maxLineLength;
    private final boolean lineWrap;
    private final boolean simpleBlocksInOneLine;
    private final boolean simpleFunctionsInOneLine;

    private WrappingFormattingOptions(int maxLineLength, boolean lineWrap, boolean simpleBlocksInOneLine, boolean simpleFunctionsInOneLine) {
        this.maxLineLength = maxLineLength;
        this.lineWrap = lineWrap;
        this.simpleBlocksInOneLine = simpleBlocksInOneLine;
        this.simpleFunctionsInOneLine = simpleFunctionsInOneLine;
    }

    public int maxLineLength() {
        return this.maxLineLength;
    }

    public boolean isSimpleBlocksInOneLine() {
        return this.simpleBlocksInOneLine;
    }

    public boolean isSimpleFunctionsInOneLine() {
        return this.simpleFunctionsInOneLine;
    }

    public boolean lineWrap() {
        return this.lineWrap;
    }

    public static WrappingFormattingOptionsBuilder builder() {
        return new WrappingFormattingOptionsBuilder();
    }

    public static class WrappingFormattingOptionsBuilder {
        private static final String MAX_LINE_LENGTH = "maxLineLength";
        private static final String SIMPLE_BLOCKS_IN_ONE_LINE = "simpleBlocksInOneLine";
        private static final String SIMPLE_METHODS_IN_ONE_LINE = "simpleFunctionsInOneLine";
        private static final String LINE_WRAP = "lineWrap";
        private int maxLineLength = FormatterUtils.getDefaultInt(FormatSection.WRAPPING, "maxLineLength");
        private boolean simpleBlocksInOneLine = FormatterUtils.getDefaultBoolean(FormatSection.WRAPPING, "simpleBlocksInOneLine");
        private boolean simpleFunctionsInOneLine = FormatterUtils.getDefaultBoolean(FormatSection.WRAPPING, "simpleFunctionsInOneLine");
        private boolean lineWrap = FormatterUtils.getDefaultBoolean(FormatSection.WRAPPING, "lineWrap");

        public WrappingFormattingOptionsBuilder setMaxLineLength(int maxLineLength) {
            this.maxLineLength = maxLineLength;
            return this;
        }

        public WrappingFormattingOptionsBuilder setSimpleBlocksInOneLine(boolean simpleBlocksInOneLine) {
            this.simpleBlocksInOneLine = simpleBlocksInOneLine;
            return this;
        }

        public WrappingFormattingOptionsBuilder setLineWrap(boolean lineWrap) {
            this.lineWrap = lineWrap;
            return this;
        }

        public WrappingFormattingOptionsBuilder setSimpleFunctionsInOneLine(boolean simpleFunctionsInOneLine) {
            this.simpleFunctionsInOneLine = simpleFunctionsInOneLine;
            return this;
        }

        public WrappingFormattingOptions build() {
            return new WrappingFormattingOptions(this.maxLineLength, this.lineWrap, this.simpleBlocksInOneLine, this.simpleFunctionsInOneLine);
        }

        public WrappingFormattingOptions build(Map<String, Object> configs) throws FormatterException {
            block10: for (Map.Entry<String, Object> wrappingEntry : configs.entrySet()) {
                String wrappingKey;
                switch (wrappingKey = wrappingEntry.getKey()) {
                    case "maxLineLength": {
                        this.setMaxLineLength(((Number)wrappingEntry.getValue()).intValue());
                        this.setLineWrap(true);
                        continue block10;
                    }
                    case "simpleBlocksInOneLine": {
                        this.setSimpleBlocksInOneLine((Boolean)wrappingEntry.getValue());
                        continue block10;
                    }
                    case "simpleFunctionsInOneLine": {
                        this.setSimpleFunctionsInOneLine((Boolean)wrappingEntry.getValue());
                        continue block10;
                    }
                }
                throw new FormatterException("invalid wrapping formatting option: " + wrappingKey);
            }
            return this.build();
        }
    }
}

