/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.logging.accesslog;

import io.ballerina.stdlib.http.api.logging.accesslog.HttpAccessLogConfig;
import io.ballerina.stdlib.http.api.logging.accesslog.HttpAccessLogFormatter;
import io.ballerina.stdlib.http.api.logging.accesslog.HttpAccessLogMessage;
import io.ballerina.stdlib.http.api.logging.accesslog.HttpAccessLogUtil;
import io.ballerina.stdlib.http.api.logging.accesslog.HttpAccessLogger;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerHttpAccessLogger
implements HttpAccessLogger {
    private static final Logger LOG = LoggerFactory.getLogger(ListenerHttpAccessLogger.class);
    private static final InternalLogger ACCESS_LOGGER = InternalLoggerFactory.getInstance((String)"http.accesslog");
    private final Calendar inboundRequestArrivalTime;
    private Long contentLength = 0L;
    private String remoteAddress;

    public ListenerHttpAccessLogger(Calendar inboundRequestArrivalTime, String remoteAddress) {
        this.inboundRequestArrivalTime = inboundRequestArrivalTime;
        this.remoteAddress = remoteAddress;
    }

    public ListenerHttpAccessLogger(Calendar inboundRequestArrivalTime, Long contentLength, String remoteAddress) {
        this.inboundRequestArrivalTime = inboundRequestArrivalTime;
        this.contentLength = contentLength;
        this.remoteAddress = remoteAddress;
    }

    @Override
    public void logAccessInfo(HttpCarbonMessage inboundRequestMsg, HttpCarbonMessage outboundResponseMsg) {
        long requestBodySize;
        HttpHeaders headers = inboundRequestMsg.getHeaders();
        if (headers.contains("x-forwarded-for")) {
            String forwardedHops = headers.get("x-forwarded-for");
            int firstCommaIndex = forwardedHops.indexOf(44);
            this.remoteAddress = firstCommaIndex != -1 ? forwardedHops.substring(0, firstCommaIndex) : forwardedHops;
        }
        String userAgent = "-";
        if (headers.contains((CharSequence)HttpHeaderNames.USER_AGENT)) {
            userAgent = headers.get((CharSequence)HttpHeaderNames.USER_AGENT);
        }
        String referrer = "-";
        if (headers.contains((CharSequence)HttpHeaderNames.REFERER)) {
            referrer = headers.get((CharSequence)HttpHeaderNames.REFERER);
        }
        String method = inboundRequestMsg.getHttpMethod();
        String uri = inboundRequestMsg.getRequestUrl();
        HttpRequest request = inboundRequestMsg.getNettyHttpRequest();
        String protocol = request != null ? request.protocolVersion().toString() : inboundRequestMsg.getHttpVersion();
        if (headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
            try {
                requestBodySize = Long.parseLong(headers.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
            }
            catch (Exception ignored) {
                requestBodySize = 0L;
            }
        } else {
            requestBodySize = inboundRequestMsg.getContentSize().intValue();
        }
        int statusCode = Util.getHttpResponseStatus(outboundResponseMsg).code();
        long requestTime = Calendar.getInstance().getTimeInMillis() - this.inboundRequestArrivalTime.getTimeInMillis();
        HttpAccessLogMessage inboundMessage = new HttpAccessLogMessage(this.remoteAddress, this.inboundRequestArrivalTime, method, uri, protocol, statusCode, this.contentLength, referrer, userAgent);
        inboundMessage.setRequestBodySize(requestBodySize);
        inboundMessage.setRequestTime(requestTime);
        List<HttpAccessLogMessage> outboundMessages = HttpAccessLogUtil.getHttpAccessLogMessages(inboundRequestMsg);
        String formattedAccessLogMessage = HttpAccessLogFormatter.formatAccessLogMessage(inboundMessage, outboundMessages, HttpAccessLogConfig.getInstance().getAccessLogFormat(), HttpAccessLogConfig.getInstance().getAccessLogAttributes());
        ACCESS_LOGGER.log(InternalLogLevel.INFO, formattedAccessLogMessage);
    }

    @Override
    public void updateAccessLogInfo(HttpCarbonMessage requestMessage, HttpCarbonMessage responseMessage) {
        LOG.warn("updateAccessLogInfo is not a dependant action of this logger");
    }

    public void updateContentLength(HttpContent httpContent) {
        this.contentLength = this.contentLength + (long)httpContent.content().readableBytes();
    }
}

