/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.constraint.Constraints;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.service.signature.Parameter;
import io.ballerina.stdlib.http.api.service.signature.builder.AbstractPayloadBuilder;
import io.ballerina.stdlib.http.api.service.signature.converter.JsonToRecordConverter;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.mime.util.EntityBodyHandler;
import io.ballerina.stdlib.mime.util.MimeConstants;
import java.util.ArrayList;
import java.util.List;

public class PayloadParam
implements Parameter {
    private int index;
    private Type type;
    private final String token;
    private boolean readonly;
    private boolean nilable;
    private final List<String> mediaTypes = new ArrayList<String>();
    private Type customParameterType;
    private final boolean requireConstraintValidation;
    private final boolean laxDataBinding;

    PayloadParam(String token, boolean constraintValidation, boolean laxDataBinding) {
        this.token = token;
        this.requireConstraintValidation = constraintValidation;
        this.laxDataBinding = laxDataBinding;
    }

    public void init(Type type, Type customParameterType, int index) {
        this.type = type;
        this.customParameterType = customParameterType;
        this.index = index;
        this.validatePayloadParam(type);
    }

    @Override
    public String getTypeName() {
        return "payload";
    }

    public int getIndex() {
        return this.index;
    }

    public Type getType() {
        return this.type;
    }

    public String getToken() {
        return this.token;
    }

    List<String> getMediaTypes() {
        return this.mediaTypes;
    }

    private void validatePayloadParam(Type parameterType) {
        List memberTypes;
        if (parameterType instanceof IntersectionType) {
            memberTypes = ((IntersectionType)parameterType).getConstituentTypes();
            int size = memberTypes.size();
            if (size > 2) {
                throw HttpUtil.createHttpError("invalid payload param type '" + parameterType.getName() + "': only readonly intersection is allowed");
            }
            for (Type type : memberTypes) {
                if (type.getTag() == 51) {
                    this.readonly = true;
                    continue;
                }
                parameterType = type;
            }
        }
        if (parameterType instanceof UnionType) {
            memberTypes = ((UnionType)parameterType).getMemberTypes();
            for (Type type : memberTypes) {
                if (type.getTag() == 34) {
                    this.readonly = true;
                    continue;
                }
                if (type.getTag() != 14) continue;
                this.nilable = true;
            }
        }
        this.type = parameterType;
    }

    public void populateFeed(BObject inRequest, HttpCarbonMessage httpCarbonMessage, Object[] paramFeed) {
        BObject inRequestEntity = (BObject)inRequest.get(MimeConstants.REQUEST_ENTITY_FIELD);
        HttpUtil.populateEntityBody(inRequest, inRequestEntity, true, true);
        int index = this.getIndex();
        Type payloadType = this.getType();
        Object dataSource = EntityBodyHandler.getMessageDataSource((BObject)inRequestEntity);
        if (dataSource != null) {
            this.populateFeedWithAlreadyBuiltPayload(paramFeed, inRequestEntity, index, payloadType, dataSource);
        } else {
            this.populateFeedWithFreshPayload(httpCarbonMessage, paramFeed, inRequestEntity, index, payloadType);
        }
    }

    private void populateFeedWithAlreadyBuiltPayload(Object[] paramFeed, BObject inRequestEntity, int index, Type payloadType, Object dataSource) {
        try {
            switch (payloadType.getTag()) {
                case 32: {
                    int actualTypeTag = TypeUtils.getReferredType((Type)((ArrayType)payloadType).getElementType()).getTag();
                    if (actualTypeTag == 2) {
                        paramFeed[index] = this.validateConstraints(dataSource);
                        break;
                    }
                    if (actualTypeTag == 24) {
                        dataSource = JsonToRecordConverter.convert(payloadType, inRequestEntity, this.readonly, this.laxDataBinding);
                        paramFeed[index] = this.validateConstraints(dataSource);
                        break;
                    }
                    throw HttpUtil.createHttpError("incompatible element type found inside an array " + ((ArrayType)payloadType).getElementType().getName());
                }
                case 24: {
                    dataSource = JsonToRecordConverter.convert(payloadType, inRequestEntity, this.readonly, this.laxDataBinding);
                    paramFeed[index] = this.validateConstraints(dataSource);
                    break;
                }
                default: {
                    paramFeed[index] = this.validateConstraints(dataSource);
                    break;
                }
            }
        }
        catch (BError ex) {
            String message = "data binding failed: " + HttpUtil.getPrintableErrorMsg(ex);
            throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_PAYLOAD_BINDING_LISTENER_ERROR, message);
        }
    }

    private int populateFeedWithFreshPayload(HttpCarbonMessage inboundMessage, Object[] paramFeed, BObject inRequestEntity, int index, Type payloadType) {
        try {
            String contentType = HttpUtil.getContentTypeFromTransportMessage(inboundMessage);
            AbstractPayloadBuilder payloadBuilder = AbstractPayloadBuilder.getBuilder(contentType, payloadType, this.laxDataBinding);
            Object payloadBuilderValue = payloadBuilder.getValue(inRequestEntity, this.readonly);
            paramFeed[index] = this.validateConstraints(payloadBuilderValue);
            inboundMessage.setProperty("EntityObj", inRequestEntity);
            return ++index;
        }
        catch (BError ex) {
            String typeName = ex.getType().getName();
            if ("NoContentError".equals(typeName) && this.nilable) {
                paramFeed[index] = null;
                return ++index;
            }
            if (HttpErrorType.INTERNAL_PAYLOAD_VALIDATION_LISTENER_ERROR.getErrorName().equals(typeName)) {
                throw ex;
            }
            String message = "data binding failed: " + HttpUtil.getPrintableErrorMsg(ex);
            throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_PAYLOAD_BINDING_LISTENER_ERROR, message);
        }
    }

    private Object validateConstraints(Object payloadBuilderValue) {
        Object result;
        if (this.requireConstraintValidation && (result = Constraints.validate((Object)payloadBuilderValue, (BTypedesc)ValueCreator.createTypedescValue((Type)this.customParameterType))) instanceof BError) {
            String message = "payload validation failed: " + HttpUtil.getPrintableErrorMsg((BError)((Object)result));
            throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_PAYLOAD_VALIDATION_LISTENER_ERROR, message);
        }
        return payloadBuilderValue;
    }
}

