/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.uri;

import io.ballerina.stdlib.http.api.HttpResourceArguments;
import io.ballerina.stdlib.http.uri.URITemplateException;
import io.ballerina.stdlib.http.uri.parser.DataElement;
import io.ballerina.stdlib.http.uri.parser.DataElementFactory;
import io.ballerina.stdlib.http.uri.parser.DataReturnAgent;
import io.ballerina.stdlib.http.uri.parser.Node;
import io.ballerina.stdlib.http.uri.parser.URITemplateParser;
import java.io.UnsupportedEncodingException;

public class URITemplate<DataType, InboundMsgType> {
    private Node<DataType, InboundMsgType> syntaxTree;

    public URITemplate(Node<DataType, InboundMsgType> syntaxTree) {
        this.syntaxTree = syntaxTree;
    }

    public DataType matches(String uri, HttpResourceArguments variables, InboundMsgType inboundMsg) {
        DataReturnAgent dataReturnAgent = new DataReturnAgent();
        boolean isFound = this.syntaxTree.matchAll(uri, variables, 0, inboundMsg, dataReturnAgent);
        if (isFound) {
            return dataReturnAgent.getData();
        }
        if (dataReturnAgent.getError() != null) {
            throw dataReturnAgent.getError();
        }
        return null;
    }

    public void parse(String uriTemplate, DataType resource, DataElementFactory<? extends DataElement<DataType, InboundMsgType>> elementCreator) throws URITemplateException, UnsupportedEncodingException {
        uriTemplate = this.removeTheFirstAndLastBackSlash(uriTemplate);
        URITemplateParser<DataType, InboundMsgType> parser = new URITemplateParser<DataType, InboundMsgType>(this.syntaxTree, elementCreator);
        parser.parse(uriTemplate, resource);
    }

    public void parse(String[] uriSegments, DataType resource, DataElementFactory<? extends DataElement<DataType, InboundMsgType>> elementCreator) throws URITemplateException, UnsupportedEncodingException {
        URITemplateParser<DataType, InboundMsgType> parser = new URITemplateParser<DataType, InboundMsgType>(this.syntaxTree, elementCreator);
        parser.parse(uriSegments, resource);
    }

    private String removeTheFirstAndLastBackSlash(String template) throws URITemplateException {
        String uri = template;
        if ("/".equals(uri)) {
            return uri;
        }
        if (uri.startsWith("*")) {
            throw new URITemplateException("Invalid path literal");
        }
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        return uri;
    }
}

