/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.uri;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public final class URIUtil {
    public static final String URI_PATH_DELIMITER = "/";
    private static final BitSet DONT_ENCODE;

    private static int compareSegments(String encoded, String plain, ComparisonMode mode) {
        int srcIdx = 0;
        int tgtIdx = 0;
        int srcLen = encoded.length();
        int tgtLen = plain.length();
        while (srcIdx < srcLen && tgtIdx < tgtLen) {
            char tgtChar;
            char srcChar = encoded.charAt(srcIdx);
            if (srcChar == (tgtChar = plain.charAt(tgtIdx))) {
                ++srcIdx;
                ++tgtIdx;
                continue;
            }
            if (srcChar == '%') {
                if (srcIdx + 2 >= srcLen) {
                    return -1;
                }
                try {
                    int decoded = Integer.parseInt(encoded.substring(srcIdx + 1, srcIdx + 3), 16);
                    if (decoded != tgtChar) {
                        return -1;
                    }
                }
                catch (NumberFormatException e) {
                    return -1;
                }
                srcIdx += 3;
                ++tgtIdx;
                continue;
            }
            if (mode == ComparisonMode.CONTAINS) {
                ++srcIdx;
                continue;
            }
            return -1;
        }
        if (mode == ComparisonMode.FULL_MATCH) {
            return srcIdx == srcLen && tgtIdx == tgtLen ? 1 : -1;
        }
        if (mode == ComparisonMode.CONTAINS) {
            return srcIdx == srcLen ? 1 : -1;
        }
        return tgtIdx == tgtLen ? srcIdx : -1;
    }

    public static boolean isPathSegmentEqual(String encodedSegment, String plainSegment) {
        return URIUtil.compareSegments(encodedSegment, plainSegment, ComparisonMode.FULL_MATCH) == 1;
    }

    public static boolean containsPathSegment(String encodedPart, String plainPart) {
        return URIUtil.compareSegments(encodedPart, plainPart, ComparisonMode.CONTAINS) == 1;
    }

    public static String getSubPath(String path, String basePath) {
        int idx = URIUtil.compareSegments(path, basePath, ComparisonMode.SUBPATH);
        if (idx == -1) {
            return path;
        }
        if (idx < path.length()) {
            return path.substring(idx);
        }
        return URI_PATH_DELIMITER;
    }

    public static String encodePathSegment(String pathSegment) {
        byte[] bytes;
        StringBuilder encoded = new StringBuilder();
        for (byte b : bytes = pathSegment.getBytes(StandardCharsets.UTF_8)) {
            int charValue = b & 0xFF;
            if (DONT_ENCODE.get(charValue) && charValue != 47 && charValue != 63 && charValue != 35 && charValue != 37) {
                encoded.append((char)charValue);
                continue;
            }
            encoded.append('%');
            encoded.append(String.format("%02X", charValue));
        }
        return encoded.toString();
    }

    public static List<String> getPathSegments(String path) {
        return Stream.of(path.split(URI_PATH_DELIMITER)).filter(segment -> !segment.isEmpty()).toList();
    }

    public static boolean isPathMatch(String encodedPath, String plainPath) {
        List<String> encodedSegments = URIUtil.getPathSegments(encodedPath);
        List<String> plainSegments = URIUtil.getPathSegments(plainPath);
        if (encodedSegments.size() < plainSegments.size()) {
            return false;
        }
        for (int i = 0; i < plainSegments.size(); ++i) {
            if (URIUtil.isPathSegmentEqual(encodedSegments.get(i), plainSegments.get(i))) continue;
            return false;
        }
        return true;
    }

    public static void populateQueryParamMap(String queryParamString, BMap<BString, Object> queryParamsMap) throws UnsupportedEncodingException {
        HashMap tempParamMap = new HashMap();
        String[] queryParamVals = queryParamString.split("&");
        for (String queryParam : queryParamVals) {
            int index = queryParam.indexOf(61);
            if (index == -1) {
                if (tempParamMap.containsKey(queryParam)) continue;
                tempParamMap.put(queryParam, null);
                continue;
            }
            String queryParamName = queryParam.substring(0, index).trim();
            String queryParamValue = queryParam.substring(index + 1).trim();
            ArrayList<String> values = new ArrayList<String>();
            HashSet<String> uniqueValues = new HashSet<String>();
            for (String val : queryParamValue.split(",")) {
                String decodedValue = URLDecoder.decode(val, StandardCharsets.UTF_8);
                if (!uniqueValues.add(decodedValue)) continue;
                values.add(decodedValue);
            }
            if (tempParamMap.containsKey(queryParamName) && tempParamMap.get(queryParamName) != null) {
                ((List)tempParamMap.get(queryParamName)).addAll(values);
                continue;
            }
            tempParamMap.put(queryParamName, values);
        }
        for (Map.Entry entry : tempParamMap.entrySet()) {
            List entryValue = (List)entry.getValue();
            if (entryValue != null) {
                queryParamsMap.put((Object)StringUtils.fromString((String)((String)entry.getKey())), (Object)StringUtils.fromStringArray((String[])entryValue.toArray(new String[0])));
                continue;
            }
            queryParamsMap.put((Object)StringUtils.fromString((String)((String)entry.getKey())), null);
        }
    }

    public static BMap<BString, Object> getMatrixParamsMap(String path, HttpCarbonMessage carbonMessage) {
        BMap matrixParamsBMap = ValueCreator.createMapValue();
        Map pathToMatrixParamMap = (Map)carbonMessage.getProperty("MATRIX_PARAMS");
        Map matrixParamsMap = (Map)pathToMatrixParamMap.get(path);
        if (matrixParamsMap != null) {
            for (Map.Entry matrixParamEntry : matrixParamsMap.entrySet()) {
                matrixParamsBMap.put((Object)StringUtils.fromString((String)((String)matrixParamEntry.getKey())), (Object)StringUtils.fromString((String)((String)matrixParamEntry.getValue())));
            }
        }
        return matrixParamsBMap;
    }

    public static String extractMatrixParams(String path, Map<String, Map<String, String>> matrixParams, HttpCarbonMessage inboundReqMsg) {
        if (path.startsWith(URI_PATH_DELIMITER)) {
            path = path.substring(1);
        }
        String[] pathSplits = path.split("\\?");
        String[] pathSegments = pathSplits[0].split(URI_PATH_DELIMITER);
        String pathToMatrixParam = "";
        for (String pathSegment : pathSegments) {
            String[] splitPathSegment = pathSegment.split(";");
            pathToMatrixParam = pathToMatrixParam.concat(URI_PATH_DELIMITER + splitPathSegment[0]);
            HashMap<String, String> segmentMatrixParams = new HashMap<String, String>();
            for (int i = 1; i < splitPathSegment.length; ++i) {
                String[] splitMatrixParam = splitPathSegment[i].split("=");
                if (splitMatrixParam.length != 2) {
                    String message = String.format("found non-matrix parameter '%s' in path '%s'", splitPathSegment[i], path);
                    throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_BAD_MATRIX_PARAMS_ERROR, message);
                }
                segmentMatrixParams.put(splitMatrixParam[0], splitMatrixParam[1]);
            }
            matrixParams.put(pathToMatrixParam, segmentMatrixParams);
        }
        for (int i = 1; i < pathSplits.length; ++i) {
            pathToMatrixParam = pathToMatrixParam.concat("?").concat(pathSplits[i]);
        }
        return pathToMatrixParam;
    }

    private URIUtil() {
    }

    static {
        int i;
        DONT_ENCODE = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            DONT_ENCODE.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            DONT_ENCODE.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            DONT_ENCODE.set(i);
        }
        DONT_ENCODE.set(45);
        DONT_ENCODE.set(46);
        DONT_ENCODE.set(95);
        DONT_ENCODE.set(126);
        DONT_ENCODE.set(33);
        DONT_ENCODE.set(36);
        DONT_ENCODE.set(38);
        DONT_ENCODE.set(39);
        DONT_ENCODE.set(40);
        DONT_ENCODE.set(41);
        DONT_ENCODE.set(42);
        DONT_ENCODE.set(43);
        DONT_ENCODE.set(44);
        DONT_ENCODE.set(59);
        DONT_ENCODE.set(61);
        DONT_ENCODE.set(58);
        DONT_ENCODE.set(64);
    }

    private static enum ComparisonMode {
        FULL_MATCH,
        CONTAINS,
        SUBPATH;

    }
}

