/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.value;

import io.apicurio.datamodels.models.ServerVariable;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Server;
import io.apicurio.datamodels.util.NodeUtil;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.value.AbstractInvalidPropertyValueRule;
import java.util.ArrayList;
import java.util.List;

public class OasServerVarNotFoundInTemplateRule
extends AbstractInvalidPropertyValueRule {
    public OasServerVarNotFoundInTemplateRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private List<String> parseServerTemplate(String serverTemplate) {
        ArrayList<String> vars = new ArrayList<String>();
        if (!this.hasValue(serverTemplate)) {
            return vars;
        }
        int startIdx = serverTemplate.indexOf("{");
        int endIdx = -1;
        while (startIdx != -1) {
            endIdx = serverTemplate.indexOf(125, startIdx);
            if (endIdx != -1) {
                vars.add(serverTemplate.substring(startIdx + 1, endIdx));
                startIdx = serverTemplate.indexOf(123, endIdx);
                continue;
            }
            startIdx = -1;
        }
        return vars;
    }

    @Override
    public void visitServerVariable(ServerVariable node) {
        String varName = this.getMappedNodeName(node);
        OpenApi30Server server = (OpenApi30Server)node.parent();
        List<String> vars = this.parseServerTemplate(server.getUrl());
        String[] varArray = NodeUtil.asArray(vars);
        this.reportIfInvalid(this.isValidEnumItem(varName, varArray), node, null, this.map("name", varName));
    }
}

