/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.value;

import io.apicurio.datamodels.models.Operation;
import io.apicurio.datamodels.models.openapi.OpenApiOperation;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Operation;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Operation;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.value.AbstractInvalidPropertyValueRule;

public class OasUnexpectedRequestBodyRule
extends AbstractInvalidPropertyValueRule {
    public OasUnexpectedRequestBodyRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    protected boolean isValidRequestBodyOperation(OpenApiOperation operation) {
        String method = this.getOperationMethod(operation);
        return this.isValidEnumItem(method, this.array("put", "post", "options", "patch"));
    }

    protected boolean hasRequestBody(Operation node) {
        if (node instanceof OpenApi31Operation) {
            return this.hasValue(((OpenApi31Operation)node).getRequestBody());
        }
        if (node instanceof OpenApi30Operation) {
            return this.hasValue(((OpenApi30Operation)node).getRequestBody());
        }
        return false;
    }

    @Override
    public void visitOperation(Operation node) {
        if (this.hasRequestBody(node)) {
            OpenApiOperation operation = (OpenApiOperation)node;
            String method = this.getOperationMethod(operation);
            this.reportIfInvalid(this.isValidRequestBodyOperation(operation), operation, "requestBody", this.map("method", method.toUpperCase()));
        }
    }
}

