/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.cmd;

import io.ballerina.asyncapi.cmd.AsyncApiMessages;
import io.ballerina.asyncapi.cmd.Utils;
import io.ballerina.asyncapi.cmd.websockets.AsyncApiDiagnostic;
import io.ballerina.asyncapi.cmd.websockets.AsyncApiToBallerinaGenerator;
import io.ballerina.asyncapi.cmd.websockets.BallerinaToAsyncApiGenerator;
import io.ballerina.asyncapi.cmd.websockets.CmdUtils;
import io.ballerina.asyncapi.codegenerator.application.CodeGenerator;
import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.AsyncApiConverterDiagnostic;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.DiagnosticMessages;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.ExceptionDiagnostic;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.IncompatibleRemoteDiagnostic;
import io.ballerina.cli.BLauncherCmd;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.ballerinalang.formatter.core.FormatterException;
import picocli.CommandLine;

@CommandLine.Command(name="asyncapi", description={"Generate the Ballerina sources for a given AsyncAPI definition."})
public class AsyncApiCmd
implements BLauncherCmd {
    public static final String LICENSE_FLAG = "--license";
    public static final String SERVICE_FLAG = "--service";
    public static final String TEST_FLAG = "--with-tests";
    public static final String JSON_FLAG = "--json";
    public static final String INPUT_FLAG = "--input";
    public static final String OUTPUT_FLAG = "--output";
    public static final String INPUT_FLAG_ALT = "-i";
    public static final String OUTPUT_FLAG_ALT = "-o";
    public static final String PROTOCOL_FLAG = "--protocol";
    private static final String FILE_EXTENSION_SEPARATOR = ".";
    private static final String BAL_EXTENSION = ".bal";
    public static final Set<String> VALID_HTTP_NAMES = new HashSet<String>(Arrays.asList("http", "https"));
    public static final Set<String> VALID_WS_NAMES = new HashSet<String>(Arrays.asList("ws", "wss", "websocket"));
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String EXPERIMENTAL_WARNING = "WARNING: The support for the WebSocket protocol is currently an experimental feature, and its behavior may be subject to change in future releases." + LINE_SEPARATOR;
    private static final String CMD_NAME = "asyncapi";
    private static final int EXIT_CODE_0 = 0;
    private static final int EXIT_CODE_1 = 1;
    private static final int EXIT_CODE_2 = 2;
    private static final ExitHandler DEFAULT_EXIT_HANDLER = code -> Runtime.getRuntime().exit(code);
    private final PrintStream outStream;
    private final Path executionPath;
    private Path targetOutputPath;
    private final ExitHandler exitHandler;
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"-i", "--input"}, description={"File path to the AsyncAPI specification"})
    private String inputFile;
    @CommandLine.Option(names={"-o", "--output"}, description={"Directory to store the generated Ballerina service. If this is not provided, the generated files will be stored in the current execution directory"})
    private String outputPath;
    @CommandLine.Option(names={"--protocol"}, description={"The protocol to be used for the service"})
    private String protocol = "http";
    @CommandLine.Option(names={"--license"}, description={"Location of the file which contains the license header"})
    private String licenseFilePath;
    @CommandLine.Option(names={"--service"}, description={"Service name that need to documented as asyncapi contract"})
    private String service;
    @CommandLine.Option(names={"--with-tests"}, hidden=true, description={"Generate test files"})
    private boolean includeTestFiles;
    @CommandLine.Option(names={"--json"}, description={"Generate json file"})
    private boolean generatedFileType;
    private String extension;

    public AsyncApiCmd() {
        this(System.err, Paths.get(System.getProperty("user.dir"), new String[0]), DEFAULT_EXIT_HANDLER);
    }

    public AsyncApiCmd(PrintStream outStream, Path executionDir) {
        this(outStream, executionDir, DEFAULT_EXIT_HANDLER);
    }

    public AsyncApiCmd(PrintStream outStream, Path executionDir, ExitHandler exitHandler) {
        this.outStream = outStream;
        this.executionPath = executionDir;
        this.exitHandler = exitHandler;
    }

    private void exit(int code) {
        this.exitHandler.exit(code);
    }

    @Override
    public void execute() {
        if (this.helpFlag) {
            this.printLongDesc(new StringBuilder());
            this.exit(0);
            return;
        }
        if (this.inputFile == null || this.inputFile.isBlank()) {
            this.printLongDesc(new StringBuilder());
            this.exit(2);
            return;
        }
        String normalizedProtocol = this.protocol.toLowerCase(Locale.ROOT);
        if (VALID_HTTP_NAMES.contains(normalizedProtocol)) {
            if (!this.verifyValidInputsForHttp()) {
                return;
            }
            if (!Utils.isAsyncApiSpecFile(this.inputFile)) {
                this.outStream.println("An AsyncApi definition file is required to generate the listener. \ne.g: bal asyncapi --input <AsyncAPIContract>");
                this.outStream.flush();
                this.exit(1);
                return;
            }
            CodeGenerator codeGenerator = new CodeGenerator();
            try {
                codeGenerator.generate(this.inputFile, this.outputPath == null ? String.valueOf(this.executionPath) : this.outputPath);
            }
            catch (BallerinaAsyncApiException e) {
                this.outStream.println(e.getMessage());
                this.outStream.flush();
                this.exit(1);
                return;
            }
        }
        if (VALID_WS_NAMES.contains(normalizedProtocol)) {
            this.outStream.println(EXPERIMENTAL_WARNING);
            if (Utils.isAsyncApiSpecFile(this.inputFile)) {
                this.giveWarningsForInvalidClientGenOptions();
                try {
                    this.asyncApiToBallerinaWs(this.inputFile);
                }
                catch (IOException e) {
                    this.outStream.println(e.getLocalizedMessage());
                    this.outStream.flush();
                    this.exit(1);
                }
                return;
            }
            if (Utils.isBallerinaFile(this.inputFile)) {
                this.giveWarningsForInvalidSpecGenOptions();
                try {
                    this.ballerinaToAsyncApiWs(this.inputFile);
                }
                catch (Exception e) {
                    this.outStream.println(e.getLocalizedMessage());
                    this.outStream.flush();
                    this.exit(1);
                }
                return;
            }
            this.outStream.println("Bal service file is required to generate the asyncapi definition. \ne.g: bal asyncapi --input <Ballerina file path>");
            this.outStream.flush();
            this.exit(1);
            return;
        }
        this.outStream.println(String.format("ERROR invalid protocol: %s. Supported protocols are `http` and `ws`.", this.protocol));
        this.outStream.flush();
        this.exit(1);
        return;
        this.outStream.flush();
        this.exit(0);
    }

    private void giveWarningsForInvalidSpecGenOptions() {
        if (this.licenseFilePath != null) {
            this.outStream.println(AsyncApiMessages.INVALID_USE_OF_LICENSE_FLAG_WARNING);
        }
        if (this.includeTestFiles) {
            this.outStream.println(AsyncApiMessages.INVALID_USE_OF_TEST_FLAG_WARNING);
        }
    }

    private void giveWarningsForInvalidClientGenOptions() {
        if (this.generatedFileType) {
            this.outStream.println(AsyncApiMessages.INVALID_USE_OF_JSON_FLAG_WARNING);
        }
        if (this.service != null) {
            this.outStream.println(AsyncApiMessages.INVALID_USE_OF_SERVICE_FLAG_WARNING);
        }
    }

    private boolean verifyValidInputsForHttp() {
        if (this.licenseFilePath != null) {
            this.outStream.println(String.format("ERROR unsupported %s flag for http protocol", LICENSE_FLAG));
            this.exit(1);
            return false;
        }
        if (this.service != null) {
            this.outStream.println(String.format("ERROR unsupported %s flag for http protocol", SERVICE_FLAG));
            this.exit(1);
            return false;
        }
        if (this.includeTestFiles) {
            this.outStream.println(String.format("ERROR unsupported %s flag for http protocol", TEST_FLAG));
            this.exit(1);
            return false;
        }
        if (this.generatedFileType) {
            this.outStream.println(String.format("ERROR unsupported %s flag for http protocol", JSON_FLAG));
            this.exit(1);
            return false;
        }
        return true;
    }

    private void ballerinaToAsyncApiWs(String fileName) {
        ArrayList<AsyncApiConverterDiagnostic> errors = new ArrayList<AsyncApiConverterDiagnostic>();
        File balFile = new File(fileName);
        try {
            Path balFilePath = Paths.get(balFile.getCanonicalPath(), new String[0]);
            this.setOutputPathWs();
            List<AsyncApiConverterDiagnostic> generationErrors = BallerinaToAsyncApiGenerator.generateAsyncAPIDefinitionsAllService(balFilePath, this.targetOutputPath, this.service, this.generatedFileType, this.outStream);
            errors.addAll(generationErrors);
        }
        catch (IOException e) {
            DiagnosticMessages message = DiagnosticMessages.AAS_CONVERTOR_102;
            ExceptionDiagnostic error = new ExceptionDiagnostic(message.getCode(), message.getDescription(), null, e.getLocalizedMessage());
            errors.add(error);
        }
        if (!errors.isEmpty()) {
            for (AsyncApiConverterDiagnostic error : errors) {
                AsyncApiDiagnostic diagnostic;
                if (error instanceof ExceptionDiagnostic) {
                    ExceptionDiagnostic exceptionDiagnostic = (ExceptionDiagnostic)error;
                    diagnostic = CmdUtils.constructAsyncAPIDiagnostic(exceptionDiagnostic.getCode(), exceptionDiagnostic.getMessage(), exceptionDiagnostic.getDiagnosticSeverity(), exceptionDiagnostic.getLocation().orElse(null), new Object[0]);
                    this.outStream.println((Object)diagnostic);
                    this.exit(1);
                    return;
                }
                if (!(error instanceof IncompatibleRemoteDiagnostic)) continue;
                IncompatibleRemoteDiagnostic incompatibleError = (IncompatibleRemoteDiagnostic)error;
                diagnostic = CmdUtils.constructAsyncAPIDiagnostic(incompatibleError.getCode(), incompatibleError.getMessage(), incompatibleError.getDiagnosticSeverity(), incompatibleError.getLocation().get(), new Object[0]);
                this.outStream.println((Object)diagnostic);
            }
        }
    }

    private void asyncApiToBallerinaWs(String fileName) throws IOException {
        String licenseHeader = this.extractLicenseHeaderWs();
        if (licenseHeader == null) {
            return;
        }
        AsyncApiToBallerinaGenerator generator = new AsyncApiToBallerinaGenerator(licenseHeader, this.includeTestFiles);
        File asyncApiFile = new File(fileName);
        this.setOutputPathWs();
        Path resourcePath = Paths.get(asyncApiFile.getCanonicalPath(), new String[0]);
        this.generatesClientFileWs(generator, resourcePath);
    }

    private String extractLicenseHeaderWs() {
        try {
            if (this.licenseFilePath != null && !this.licenseFilePath.isBlank()) {
                Path filePath = Paths.get(new File(this.licenseFilePath).getCanonicalPath(), new String[0]);
                Object licenseHeader = Files.readString(Paths.get(filePath.toString(), new String[0]));
                if (!((String)licenseHeader).endsWith(LINE_SEPARATOR)) {
                    licenseHeader = (String)licenseHeader + LINE_SEPARATOR + LINE_SEPARATOR;
                } else if (!((String)licenseHeader).endsWith(LINE_SEPARATOR + LINE_SEPARATOR)) {
                    licenseHeader = (String)licenseHeader + LINE_SEPARATOR;
                }
                return licenseHeader;
            }
        }
        catch (IOException e) {
            this.outStream.println(String.format("Invalid license file path : %s. %s.", this.licenseFilePath, e.getMessage()));
            this.exit(1);
            return null;
        }
        return "";
    }

    private void setOutputPathWs() {
        this.targetOutputPath = this.executionPath;
        if (this.outputPath != null) {
            this.targetOutputPath = Paths.get(this.outputPath, new String[0]).isAbsolute() ? Paths.get(this.outputPath, new String[0]) : Paths.get(this.targetOutputPath.toString(), this.outputPath);
        }
    }

    private void generatesClientFileWs(AsyncApiToBallerinaGenerator generator, Path resourcePath) {
        try {
            generator.generateClient(resourcePath, this.targetOutputPath);
        }
        catch (BallerinaAsyncApiExceptionWs | IOException | FormatterException e) {
            if (e.getLocalizedMessage() != null) {
                this.outStream.println(e.getLocalizedMessage());
            } else {
                this.outStream.println("Error occurred when generating client for AsyncAPI contract");
            }
            this.exit(1);
        }
    }

    @Override
    public String getName() {
        return CMD_NAME;
    }

    @Override
    public void printLongDesc(StringBuilder stringBuilder) {
        ClassLoader classLoader = AsyncApiCmd.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream("ballerina-asyncapi.help");
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(inputStreamReader);){
            String content = br.readLine();
            this.outStream.append(content);
            while ((content = br.readLine()) != null) {
                this.outStream.append('\n').append(content);
            }
            this.outStream.append('\n');
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void printUsage(StringBuilder stringBuilder) {
    }

    @Override
    public void setParentCmdParser(CommandLine commandLine) {
    }

    @FunctionalInterface
    public static interface ExitHandler {
        public void exit(int var1);
    }
}

