/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.cmd;

import java.io.File;
import java.util.Locale;

public class Utils {
    private static final String FILE_EXTENSION_SEPARATOR = ".";
    private static final String BAL_EXTENSION = "bal";
    private static final String JSON_EXTENSION = "json";
    private static final String YAML_EXTENSION = "yaml";
    private static final String YML_EXTENSION = "yml";

    static boolean isAsyncApiSpecFile(String extension) {
        return Utils.isYamlFile(extension) || Utils.isJsonFile(extension);
    }

    public static boolean isYamlFile(String filePath) {
        String extension = Utils.getFileExtension(filePath);
        if (extension == null) {
            return false;
        }
        return (extension = extension.toLowerCase(Locale.ROOT)).endsWith(YAML_EXTENSION) || extension.endsWith(YML_EXTENSION);
    }

    public static boolean isJsonFile(String filePath) {
        String extension = Utils.getFileExtension(filePath);
        if (extension == null) {
            return false;
        }
        return extension.toLowerCase(Locale.ROOT).endsWith(JSON_EXTENSION);
    }

    public static boolean isBallerinaFile(String extension) {
        return extension.endsWith(BAL_EXTENSION);
    }

    private static String getFileExtension(String fileName) {
        if (fileName.lastIndexOf(FILE_EXTENSION_SEPARATOR) < fileName.lastIndexOf(File.separatorChar)) {
            return null;
        }
        int i = fileName.lastIndexOf(FILE_EXTENSION_SEPARATOR);
        return fileName.substring(i + 1);
    }
}

