/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.cmd.websockets;

import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.AsyncApiConverterDiagnostic;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.DiagnosticMessages;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.ExceptionDiagnostic;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.model.AsyncApiResult;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils.CodegenUtils;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils.ServiceToAsyncApiConverterUtils;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class BallerinaToAsyncApiGenerator {
    public static List<AsyncApiConverterDiagnostic> generateAsyncAPIDefinitionsAllService(Path servicePath, Path outPath, String serviceName, Boolean needJson, PrintStream outStream) {
        Document doc;
        DocumentId docId;
        ArrayList<AsyncApiConverterDiagnostic> errors = new ArrayList<AsyncApiConverterDiagnostic>();
        BuildOptions buildOptions = BuildOptions.builder().setOffline(Boolean.valueOf(true)).build();
        Project project = ProjectLoader.load((Path)servicePath, (BuildOptions)buildOptions).project();
        Package currentPackage = project.currentPackage();
        if (project.kind().equals((Object)ProjectKind.BUILD_PROJECT)) {
            docId = project.documentId(servicePath);
            doc = currentPackage.module(docId.moduleId()).document(docId);
        } else {
            Module currentModule = currentPackage.getDefaultModule();
            Iterator documentIterator = currentModule.documentIds().iterator();
            docId = (DocumentId)documentIterator.next();
            doc = currentModule.document(docId);
        }
        Path inputPath = project.documentPath(docId).orElse(null);
        SyntaxTree syntaxTree = doc.syntaxTree();
        PackageCompilation compilation = currentPackage.getCompilation();
        boolean hasErrors = compilation.diagnosticResult().hasErrors();
        if (hasErrors) {
            BallerinaToAsyncApiGenerator.printDiagnostics(outStream, compilation.diagnosticResult().diagnostics());
            return errors;
        }
        SemanticModel semanticModel = compilation.getSemanticModel(docId.moduleId());
        List<AsyncApiResult> asyncAPIDefinitions = ServiceToAsyncApiConverterUtils.generateAsyncAPISpecDefinition(syntaxTree, semanticModel, serviceName, needJson, inputPath);
        if (asyncAPIDefinitions.isEmpty()) {
            return errors;
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        for (AsyncApiResult definition : asyncAPIDefinitions) {
            BallerinaToAsyncApiGenerator.writeToFile(outPath, definition, needJson, errors, fileNames);
        }
        BallerinaToAsyncApiGenerator.printSuccessMessage(outStream, fileNames);
        return errors;
    }

    private static void printDiagnostics(PrintStream outStream, Collection<Diagnostic> diagnostics) {
        outStream.println("COMPILATION ERRORS:");
        for (Diagnostic e : diagnostics) {
            if (!e.diagnosticInfo().severity().equals((Object)DiagnosticSeverity.ERROR)) continue;
            outStream.println(e.message());
        }
    }

    private static void printSuccessMessage(PrintStream outStream, List<String> fileNames) {
        outStream.println("AsyncAPI definition(s) generated successfully and copied to :");
        for (String fileName : fileNames) {
            outStream.println("-- " + fileName);
        }
    }

    private static void createOutputDirectory(Path outPath, List<AsyncApiConverterDiagnostic> errors) {
        try {
            Files.createDirectories(outPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            DiagnosticMessages message = DiagnosticMessages.AAS_CONVERTOR_102;
            ExceptionDiagnostic error = new ExceptionDiagnostic(message.getCode(), message.getDescription() + e.getLocalizedMessage(), null, new Object[0]);
            errors.add(error);
        }
    }

    private static void writeToFile(Path outPath, AsyncApiResult definition, boolean needJson, List<AsyncApiConverterDiagnostic> errors, List<String> fileNames) {
        if (Files.notExists(outPath, new LinkOption[0])) {
            BallerinaToAsyncApiGenerator.createOutputDirectory(outPath, errors);
        }
        try {
            Optional<String> content;
            errors.addAll(definition.getDiagnostics());
            if (definition.getAsyncAPI().isEmpty()) {
                return;
            }
            Optional<String> optional = content = needJson ? definition.getJson() : definition.getYaml();
            if (content.isEmpty()) {
                return;
            }
            String fileName = CodegenUtils.resolveContractFileName(outPath, definition.getServiceName(), needJson);
            CodegenUtils.writeFile(outPath.resolve(fileName), content.get());
            fileNames.add(fileName);
        }
        catch (IOException e) {
            DiagnosticMessages message = DiagnosticMessages.AAS_CONVERTOR_102;
            ExceptionDiagnostic error = new ExceptionDiagnostic(message.getCode(), message.getDescription() + e.getLocalizedMessage(), null, new Object[0]);
            errors.add(error);
        }
    }
}

