/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.codegenerator.controller;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.deref.Dereferencer;
import io.apicurio.datamodels.models.asyncapi.AsyncApiDocument;
import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.apicurio.datamodels.refs.ReferenceResolverChain;
import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.codegenerator.controller.SpecController;
import io.ballerina.asyncapi.codegenerator.entity.MultiChannel;
import io.ballerina.asyncapi.codegenerator.entity.ServiceType;
import io.ballerina.asyncapi.codegenerator.usecase.ExtractChannelsFromSpec;
import io.ballerina.asyncapi.codegenerator.usecase.ExtractIdentifierPathFromSpec;
import io.ballerina.asyncapi.codegenerator.usecase.ExtractIdentifierTypeFromSpec;
import io.ballerina.asyncapi.codegenerator.usecase.ExtractSchemasFromSpec;
import java.util.List;
import java.util.Map;

public class AsyncApiSpecController
implements SpecController {
    private List<ServiceType> serviceTypes;
    private Map<String, AsyncApiSchema> schemas;
    private String eventIdentifierType;
    private String eventIdentifierPath;

    public AsyncApiSpecController(String asyncApiSpecJson) throws BallerinaAsyncApiException {
        this.readSpec(asyncApiSpecJson);
    }

    private void readSpec(String asyncApiSpecJson) throws BallerinaAsyncApiException {
        AsyncApiDocument asyncApiSpec = (AsyncApiDocument)Library.readDocumentFromJSONString(asyncApiSpecJson);
        Dereferencer dereferencer = new Dereferencer(ReferenceResolverChain.getInstance(), false);
        asyncApiSpec = (AsyncApiDocument)dereferencer.dereference(asyncApiSpec);
        ExtractChannelsFromSpec extractServiceTypes = new ExtractChannelsFromSpec(asyncApiSpec);
        ExtractSchemasFromSpec extractSchemas = new ExtractSchemasFromSpec(asyncApiSpec);
        ExtractIdentifierTypeFromSpec extractIdentifierType = new ExtractIdentifierTypeFromSpec(asyncApiSpec);
        ExtractIdentifierPathFromSpec extractIdentifierPath = new ExtractIdentifierPathFromSpec(asyncApiSpec);
        MultiChannel multiChannel = (MultiChannel)extractServiceTypes.extract();
        this.serviceTypes = multiChannel.getServiceTypes();
        this.schemas = (Map)extractSchemas.extract();
        this.schemas.putAll(multiChannel.getInlineSchemas());
        this.eventIdentifierType = (String)extractIdentifierType.extract();
        this.eventIdentifierPath = (String)extractIdentifierPath.extract();
    }

    @Override
    public List<ServiceType> getServiceTypes() {
        return this.serviceTypes;
    }

    @Override
    public Map<String, AsyncApiSchema> getSchemas() {
        return this.schemas;
    }

    @Override
    public String getEventIdentifierType() {
        return this.eventIdentifierType;
    }

    @Override
    public String getEventIdentifierPath() {
        return this.eventIdentifierPath;
    }
}

